/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.modules.languages.ParserManagerImpl;

public abstract class ParserManager {
    private static Map<Document, WeakReference<ParserManager>> managers = new WeakHashMap<Document, WeakReference<ParserManager>>();

    public static synchronized ParserManager get(Document document) {
        ParserManager parserManager;
        WeakReference<ParserManager> weakReference = managers.get(document);
        ParserManager parserManager2 = parserManager = weakReference != null ? (ParserManager)weakReference.get() : null;
        if (parserManager == null) {
            parserManager = new ParserManagerImpl(document);
            managers.put(document, new WeakReference<ParserManager>(parserManager));
        }
        return parserManager;
    }

    public abstract State getState();

    public abstract ASTNode getAST() throws ParseException;

    public abstract void addListener(ParserManagerListener var1);

    public abstract void removeListener(ParserManagerListener var1);

    public abstract void addASTEvaluator(ASTEvaluator var1);

    public abstract void removeASTEvaluator(ASTEvaluator var1);

    private static void printManagers() {
        System.out.println("\nParserManagers:");
        for (Document document : managers.keySet()) {
            WeakReference<ParserManager> weakReference;
            String string = (String)document.getProperty("title");
            if (string == null) {
                string = document.toString();
            }
            if ((weakReference = managers.get(document)).get() == null) continue;
            System.out.println("  " + string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PARSING,
        OK,
        ERROR,
        NOT_PARSED;

    }
}

