/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import mondrian.olap.Util;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.BooleanProperty;
import org.eigenbase.util.property.DoubleProperty;
import org.eigenbase.util.property.IntegerProperty;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.StringProperty;
import org.eigenbase.util.property.TriggerableProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianProperties
extends TriggerableProperties {
    private final FilePropertySource mondrianDotPropertiesSource = new FilePropertySource(new File("mondrian.properties"));
    private int populateCount;
    private static final Logger LOGGER = Logger.getLogger(MondrianProperties.class);
    private static MondrianProperties instance;
    private static final String mondrianDotProperties = "mondrian.properties";
    public final IntegerProperty QueryLimit = new IntegerProperty((Properties)((Object)this), "mondrian.query.limit", 40);
    public final IntegerProperty TraceLevel = new IntegerProperty((Properties)((Object)this), "mondrian.trace.level");
    public final StringProperty DebugOutFile = new StringProperty((Properties)((Object)this), "mondrian.debug.out.file", null);
    public final StringProperty JdbcDrivers = new StringProperty((Properties)((Object)this), "mondrian.jdbcDrivers", "sun.jdbc.odbc.JdbcOdbcDriver,org.hsqldb.jdbcDriver,oracle.jdbc.OracleDriver,com.mysql.jdbc.Driver");
    public final IntegerProperty ResultLimit = new IntegerProperty((Properties)((Object)this), "mondrian.result.limit", 0);
    public final IntegerProperty CachePoolCostLimit = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.CachePool.costLimit", 10000);
    public final BooleanProperty PrintCacheablesAfterQuery = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.RolapResult.printCacheables");
    public final BooleanProperty FlushAfterQuery = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.RolapResult.flushAfterEachQuery");
    public final StringProperty TestName = new StringProperty((Properties)((Object)this), "mondrian.test.Name", null);
    public final StringProperty TestClass = new StringProperty((Properties)((Object)this), "mondrian.test.Class", null);
    public final StringProperty TestConnectString = new StringProperty((Properties)((Object)this), "mondrian.test.connectString", null);
    public final StringProperty FoodmartJdbcURL = new StringProperty((Properties)((Object)this), "mondrian.foodmart.jdbcURL", "jdbc:odbc:MondrianFoodMart");
    public final StringProperty TestJdbcURL = new StringProperty((Properties)((Object)this), "mondrian.test.jdbcURL", null);
    public final StringProperty TestJdbcUser = new StringProperty((Properties)((Object)this), "mondrian.test.jdbcUser", null);
    public final StringProperty TestJdbcPassword = new StringProperty((Properties)((Object)this), "mondrian.test.jdbcPassword", null);
    public final IntegerProperty LargeDimensionThreshold = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.LargeDimensionThreshold", 100);
    public final IntegerProperty SparseSegmentCountThreshold = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.SparseSegmentValueThreshold", 1000);
    public final DoubleProperty SparseSegmentDensityThreshold = new DoubleProperty((Properties)((Object)this), "mondrian.rolap.SparseSegmentDensityThreshold", 0.5);
    public final StringProperty QueryFilePattern = new StringProperty((Properties)((Object)this), "mondrian.test.QueryFilePattern", null);
    public final StringProperty QueryFileDirectory = new StringProperty((Properties)((Object)this), "mondrian.test.QueryFileDirectory", null);
    public final IntegerProperty Iterations = new IntegerProperty((Properties)((Object)this), "mondrian.test.Iterations", 1);
    public final IntegerProperty VUsers = new IntegerProperty((Properties)((Object)this), "mondrian.test.VUsers", 1);
    public final IntegerProperty TimeLimit = new IntegerProperty((Properties)((Object)this), "mondrian.test.TimeLimit", 0);
    public final BooleanProperty Warmup = new BooleanProperty((Properties)((Object)this), "mondrian.test.Warmup", false);
    public final StringProperty CatalogURL = new StringProperty((Properties)((Object)this), "mondrian.catalogURL", null);
    public final BooleanProperty UseAggregates = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.Use", false);
    public final BooleanProperty ReadAggregates = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.Read", false);
    public final BooleanProperty ChooseAggregateByVolume = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.ChooseByVolume", false);
    public final StringProperty AggregateRules = new StringProperty((Properties)((Object)this), "mondrian.rolap.aggregates.rules", "/DefaultRules.xml");
    public final StringProperty AggregateRuleTag = new StringProperty((Properties)((Object)this), "mondrian.rolap.aggregates.rule.tag", "default");
    public final BooleanProperty GenerateAggregateSql = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.generateSql", false);
    public final BooleanProperty DisableCaching = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.star.disableCaching", false);
    public final BooleanProperty EnableTriggers = new BooleanProperty((Properties)((Object)this), "mondrian.olap.triggers.enable", true);
    public final BooleanProperty GenerateFormattedSql = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.generate.formatted.sql", false);
    public final BooleanProperty EnableNonEmptyOnAllAxis = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.nonempty", false);
    public final BooleanProperty CompareSiblingsByOrderKey = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.compareSiblingsByOrderKey", false);
    public final BooleanProperty EnableExpCache = new BooleanProperty((Properties)((Object)this), "mondrian.expCache.enable", true);
    public final IntegerProperty TestExpDependencies = new IntegerProperty((Properties)((Object)this), "mondrian.test.ExpDependencies", 0);
    public final IntegerProperty TestSeed = new IntegerProperty((Properties)((Object)this), "mondrian.test.random.seed", 1234);
    public final StringProperty LocalePropFile = new StringProperty((Properties)((Object)this), "mondrian.rolap.localePropFile", null);
    public final BooleanProperty EnableNativeCrossJoin = new BooleanProperty((Properties)((Object)this), "mondrian.native.crossjoin.enable", true);
    public final BooleanProperty EnableNativeTopCount = new BooleanProperty((Properties)((Object)this), "mondrian.native.topcount.enable", true);
    public final BooleanProperty EnableNativeFilter = new BooleanProperty((Properties)((Object)this), "mondrian.native.filter.enable", true);
    public final BooleanProperty EnableNativeNonEmpty = new BooleanProperty((Properties)((Object)this), "mondrian.native.nonempty.enable", true);
    public final StringProperty AlertNativeEvaluationUnsupported = new StringProperty((Properties)((Object)this), "mondrian.native.unsupported.alert", "OFF");
    public final BooleanProperty EnableTotalCount = new BooleanProperty((Properties)((Object)this), "mondrian.xmla.drillthroughTotalCount.enable", true);
    public final BooleanProperty CaseSensitive = new BooleanProperty((Properties)((Object)this), "mondrian.olap.case.sensitive", false);
    public final IntegerProperty MaxRows = new IntegerProperty((Properties)((Object)this), "mondrian.xmla.drillthroughMaxRows", 1000);
    public final IntegerProperty MaxConstraints = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.maxConstraints", 1000);
    public final IntegerProperty MaxEvalDepth = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.evaluate.MaxEvalDepth", 10);
    public final StringProperty JdbcFactoryClass = new StringProperty((Properties)((Object)this), "mondrian.rolap.aggregates.jdbcFactoryClass", null);
    public final IntegerProperty QueryTimeout = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.queryTimeout", 0);
    public final BooleanProperty IgnoreInvalidMembers = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.ignoreInvalidMembers", false);
    public final IntegerProperty IterationLimit = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.iterationLimit", 0);
    public final BooleanProperty MemoryMonitor = new BooleanProperty((Properties)((Object)this), "mondrian.util.memoryMonitor.enable", false);
    public final IntegerProperty MemoryMonitorThreshold = new IntegerProperty((Properties)((Object)this), "mondrian.util.memoryMonitor.percentage.threshold", 90);
    public final StringProperty MemoryMonitorClass = new StringProperty((Properties)((Object)this), "mondrian.util.MemoryMonitor.class", null);
    public final StringProperty ExpCompilerClass = new StringProperty((Properties)((Object)this), "mondrian.calc.ExpCompiler.class", null);
    public final IntegerProperty CrossJoinOptimizerSize = new IntegerProperty((Properties)((Object)this), "mondrian.olap.fun.crossjoin.optimizer.size", 0);

    public static synchronized MondrianProperties instance() {
        if (instance == null) {
            instance = new MondrianProperties();
            instance.populate();
        }
        return instance;
    }

    public boolean triggersAreEnabled() {
        return this.EnableTriggers.get();
    }

    public void populate() {
        this.loadIfStale(this.mondrianDotPropertiesSource);
        URL url = null;
        File file = new File(mondrianDotProperties);
        if (file.exists() && file.isFile()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn((Object)("Mondrian: file '" + file.getAbsolutePath() + "' could not be loaded"), (Throwable)e);
            }
        } else {
            url = MondrianProperties.class.getClassLoader().getResource(mondrianDotProperties);
        }
        if (url != null) {
            this.load(new UrlPropertySource(url));
        } else {
            LOGGER.warn((Object)("mondrian.properties can't be found under '" + new File(".").getAbsolutePath() + "' or classloader"));
        }
        int count = 0;
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = System.getProperty(key);
            if (!key.startsWith("mondrian.")) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("populate: key=" + key + ", value=" + value));
            }
            super.setProperty(key, value);
            ++count;
        }
        if (this.populateCount++ == 0) {
            LOGGER.info((Object)("Mondrian: loaded " + count + " system properties"));
        }
    }

    private void loadIfStale(PropertySource source) {
        if (source.isStale()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Mondrian: loading " + source.getDescription()));
            }
            this.load(source);
        }
    }

    private void load(PropertySource source) {
        try {
            this.load(source.openStream());
            if (this.populateCount == 0) {
                LOGGER.info((Object)("Mondrian: properties loaded from '" + source.getDescription() + "'"));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Mondrian: error while loading properties from '" + source.getDescription() + "' (" + e + ")"));
        }
    }

    public List<Property> getPropertyList() {
        Field[] fields = ((Object)((Object)this)).getClass().getFields();
        ArrayList<Property> list = new ArrayList<Property>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || !Property.class.isAssignableFrom(field.getType())) continue;
            try {
                list.add((Property)field.get((Object)this));
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "While accessing property '" + field.getName() + "'");
            }
        }
        return list;
    }

    public Property getPropertyDefinition(String path) {
        List<Property> propertyList = this.getPropertyList();
        for (Property property : propertyList) {
            if (!property.getPath().equals(path)) continue;
            return property;
        }
        return null;
    }

    static class UrlPropertySource
    implements PropertySource {
        private final URL url;
        private long lastModified;

        UrlPropertySource(URL url) {
            this.url = url;
        }

        private URLConnection getConnection() {
            try {
                return this.url.openConnection();
            }
            catch (IOException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.url + "'");
            }
        }

        public InputStream openStream() {
            try {
                URLConnection connection = this.getConnection();
                this.lastModified = connection.getLastModified();
                return connection.getInputStream();
            }
            catch (IOException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.url + "'");
            }
        }

        public boolean isStale() {
            long lastModified = this.getConnection().getLastModified();
            return lastModified > this.lastModified;
        }

        public String getDescription() {
            return this.url.toExternalForm();
        }
    }

    static class FilePropertySource
    implements PropertySource {
        private final File file;
        private long lastModified;

        FilePropertySource(File file) {
            this.file = file;
            this.lastModified = 0L;
        }

        public InputStream openStream() {
            try {
                this.lastModified = this.file.lastModified();
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.file + "'");
            }
        }

        public boolean isStale() {
            return this.file.exists() && this.file.lastModified() > this.lastModified;
        }

        public String getDescription() {
            return "file=" + this.file.getAbsolutePath() + " (exists=" + this.file.exists() + ")";
        }
    }

    public static interface PropertySource {
        public InputStream openStream();

        public boolean isStale();

        public String getDescription();
    }
}

