/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.SearchScope;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchScopeRegistry {
    private static SearchScopeRegistry defaultInstance;
    private static final Logger LOG;
    private final int id;
    private Collection<Reference<SearchScopeRegistry>> extraInstances;
    private SearchScopeChangeHandler scopeChangeHandler;
    private List<ChangeListener> changeListeners;
    private int projectSearchScopesCount;
    private int applicableSearchScopesCount;
    private Map<SearchScope, Boolean> searchScopes = new LinkedHashMap<SearchScope, Boolean>(5);

    public static synchronized SearchScopeRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new SearchScopeRegistry(0);
        }
        return defaultInstance;
    }

    static SearchScopeRegistry getInstance(Lookup lookup, int n) {
        return SearchScopeRegistry.getDefault().getLookupInstance(lookup, n);
    }

    private SearchScopeRegistry(int n) {
        this.id = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchScopeRegistry getLookupInstance(Lookup lookup, int n) {
        Collection<SearchScope> collection;
        SearchScopeRegistry searchScopeRegistry;
        assert (n > 0);
        assert (EventQueue.isDispatchThread());
        assert (this == defaultInstance);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("getLookupInstance(Lookup, " + n + ')');
        }
        Iterator<SearchScope> iterator = this.getLock();
        synchronized (iterator) {
            searchScopeRegistry = new SearchScopeRegistry(n);
            if (this.extraInstances == null) {
                this.extraInstances = new ArrayList<Reference<SearchScopeRegistry>>(4);
            }
            this.extraInstances.add(new WeakReference<SearchScopeRegistry>(searchScopeRegistry));
            collection = this.cloneSearchScopes(defaultInstance);
        }
        for (SearchScope searchScope : collection) {
            searchScopeRegistry.registerSearchScope(searchScope.getContextSensitiveInstance(lookup));
        }
        return searchScopeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSearchScope(SearchScope searchScope) {
        Collection<SearchScopeRegistry> collection;
        Collection<ChangeListener> collection2;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("register search scope " + searchScope);
        }
        Iterator<SearchScopeRegistry> iterator = this.getLock();
        synchronized (iterator) {
            if (this.scopeChangeHandler != null) {
                searchScope.addChangeListener(this.scopeChangeHandler);
                collection2 = this.checkNewState(searchScope, Boolean.TRUE) ? this.cloneChangeListeners() : null;
            } else {
                this.searchScopes.put(searchScope, null);
                collection2 = null;
            }
            if (SearchScopeRegistry.isProjectSearchScope(searchScope)) {
                ++this.projectSearchScopesCount;
            }
            collection = this.cloneLookupInstances();
        }
        if (collection2 != null) {
            this.notifyListeners(collection2);
        }
        if (!collection.isEmpty()) {
            for (SearchScopeRegistry searchScopeRegistry : collection) {
                searchScopeRegistry.registerSearchScope(searchScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSearchScope(SearchScope searchScope) {
        Collection<SearchScopeRegistry> collection;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("unregister search scope " + searchScope);
        }
        Iterator<SearchScopeRegistry> iterator = this.getLock();
        synchronized (iterator) {
            Collection<ChangeListener> collection2;
            if (this.scopeChangeHandler != null) {
                searchScope.removeChangeListener(this.scopeChangeHandler);
                collection2 = this.checkNewState(searchScope, Boolean.FALSE) ? this.cloneChangeListeners() : null;
            } else {
                this.searchScopes.remove(searchScope);
                collection2 = null;
            }
            if (SearchScopeRegistry.isProjectSearchScope(searchScope)) {
                --this.projectSearchScopesCount;
            }
            collection = this.cloneLookupInstances();
        }
        if (!collection.isEmpty()) {
            for (SearchScopeRegistry searchScopeRegistry : collection) {
                searchScopeRegistry.unregisterSearchScope(searchScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        if (LOG.isLoggable(Level.FINER)) {
            this.log("addChangeListener(" + changeListener + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = this.changeListeners == null;
            if (this.changeListeners == null) {
                this.changeListeners = new ArrayList<ChangeListener>(1);
            }
            this.changeListeners.add(changeListener);
            if (bl) {
                assert (this.applicableSearchScopesCount == 0);
                this.applicableSearchScopesCount = 0;
                this.scopeChangeHandler = new SearchScopeChangeHandler();
                for (Map.Entry<SearchScope, Boolean> entry : this.searchScopes.entrySet()) {
                    SearchScope searchScope = entry.getKey();
                    searchScope.addChangeListener(this.scopeChangeHandler);
                    boolean bl3 = searchScope.isApplicable();
                    if (bl3) {
                        ++this.applicableSearchScopesCount;
                    }
                    entry.setValue(bl3);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    this.log(" - initial applicable search scopes count: " + this.applicableSearchScopesCount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        if (LOG.isLoggable(Level.FINER)) {
            this.log("removeChangeListener(" + changeListener + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean bl;
            if (this.changeListeners == null) {
                return;
            }
            boolean bl2 = bl = this.changeListeners.remove(changeListener) && this.changeListeners.isEmpty();
            if (bl) {
                this.changeListeners = null;
                this.applicableSearchScopesCount = 0;
                for (SearchScope searchScope : this.searchScopes.keySet()) {
                    searchScope.removeChangeListener(this.scopeChangeHandler);
                }
                this.scopeChangeHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchScopeStateChanged(SearchScope searchScope) {
        Collection<ChangeListener> collection;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("searchScopeStateChanged(" + searchScope + ')');
        }
        Object object = this.getLock();
        synchronized (object) {
            collection = this.checkNewState(searchScope, null) ? this.cloneChangeListeners() : null;
        }
        if (collection != null) {
            this.notifyListeners(collection);
        }
    }

    private boolean checkNewState(SearchScope searchScope, Boolean bl) {
        boolean bl2;
        boolean bl3;
        assert (Thread.holdsLock(this.getLock()));
        if (LOG.isLoggable(Level.FINER)) {
            this.log("checkNewState(" + searchScope + ')');
        }
        if (bl == null) {
            bl3 = searchScope.isApplicable();
            Boolean bl4 = this.searchScopes.put(searchScope, bl3);
            if (bl4 == null) {
                this.searchScopes.remove(searchScope);
                return false;
            }
            if (bl3 == bl4) {
                return false;
            }
        } else if (bl.booleanValue()) {
            bl3 = searchScope.isApplicable();
            this.searchScopes.put(searchScope, bl3);
        } else {
            bl3 = false;
            this.searchScopes.remove(searchScope);
        }
        if (bl3) {
            ++this.applicableSearchScopesCount;
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - search scope count increased to " + this.applicableSearchScopesCount);
            }
            bl2 = this.applicableSearchScopesCount == 1;
        } else {
            --this.applicableSearchScopesCount;
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - search scope count decreased to " + this.applicableSearchScopesCount);
            }
            bl2 = this.applicableSearchScopesCount == 0;
        }
        return bl2;
    }

    private void notifyListeners(Collection<ChangeListener> collection) {
        assert (collection != null);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : collection) {
            changeListener.stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchScope getNodeSelectionSearchScope() {
        SearchScope searchScope;
        Object object = this.getLock();
        synchronized (object) {
            if (this.searchScopes.isEmpty()) {
                searchScope = null;
            } else {
                searchScope = this.searchScopes.entrySet().iterator().next().getKey();
                assert (searchScope.getClass().getName().startsWith("org.netbeans.modules.search.SearchScopeNodeSelection"));
            }
        }
        return searchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasApplicableSearchScope() {
        if (LOG.isLoggable(Level.FINER)) {
            this.log("hasApplicableSearchScope");
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.changeListeners != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    this.log(" - listening, search scopes count = " + this.applicableSearchScopesCount);
                }
                return this.applicableSearchScopesCount != 0;
            }
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - not listening, going to check...");
            }
            return this.checkIsApplicable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SearchScope, Boolean> getSearchScopes() {
        Collection<SearchScope> collection;
        assert (EventQueue.isDispatchThread());
        Iterator<SearchScope> iterator = this.getLock();
        synchronized (iterator) {
            if (this.changeListeners != null) {
                return new LinkedHashMap<SearchScope, Boolean>(this.searchScopes);
            }
            collection = this.cloneSearchScopes();
        }
        LinkedHashMap<SearchScope, Boolean> linkedHashMap = new LinkedHashMap<SearchScope, Boolean>(collection.size() * 2);
        for (SearchScope searchScope : collection) {
            linkedHashMap.put(searchScope, searchScope.isApplicable());
        }
        return linkedHashMap;
    }

    boolean hasProjectSearchScopes() {
        return this.projectSearchScopesCount > 0;
    }

    static boolean hasProjectSearchScopes(Collection<SearchScope> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        for (SearchScope searchScope : collection) {
            if (!SearchScopeRegistry.isProjectSearchScope(searchScope)) continue;
            return true;
        }
        return false;
    }

    private static boolean isProjectSearchScope(SearchScope searchScope) {
        return searchScope.getClass().getName().startsWith("org.netbeans.modules.search.project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIsApplicable() {
        Collection<SearchScope> collection;
        if (LOG.isLoggable(Level.FINER)) {
            this.log("checkIsApplicable()");
        }
        Iterator<SearchScope> iterator = this.getLock();
        synchronized (iterator) {
            collection = this.cloneSearchScopes();
        }
        for (SearchScope searchScope : collection) {
            if (!searchScope.isApplicable()) continue;
            if (LOG.isLoggable(Level.FINER)) {
                this.log(" - returning true");
            }
            return true;
        }
        if (LOG.isLoggable(Level.FINER)) {
            this.log(" - returning false");
        }
        return false;
    }

    private Object getLock() {
        return this;
    }

    private Collection<SearchScopeRegistry> cloneLookupInstances() {
        List<SearchScopeRegistry> list;
        assert (Thread.holdsLock(this.getLock()));
        if (this.extraInstances != null && !this.extraInstances.isEmpty()) {
            list = new ArrayList(this.extraInstances.size());
            Iterator<Reference<SearchScopeRegistry>> iterator = this.extraInstances.iterator();
            while (iterator.hasNext()) {
                Reference<SearchScopeRegistry> reference = iterator.next();
                SearchScopeRegistry searchScopeRegistry = reference.get();
                if (searchScopeRegistry == null) {
                    iterator.remove();
                    continue;
                }
                list.add(searchScopeRegistry);
            }
            assert (list.size() == this.extraInstances.size());
        } else {
            list = null;
        }
        if (list == null || list.isEmpty()) {
            list = null;
            this.extraInstances = null;
        }
        return list != null ? list : Collections.emptyList();
    }

    private Collection<SearchScope> cloneSearchScopes() {
        return this.cloneSearchScopes(this);
    }

    private Collection<SearchScope> cloneSearchScopes(SearchScopeRegistry searchScopeRegistry) {
        assert (Thread.holdsLock(this.getLock()));
        return new ArrayList<SearchScope>(searchScopeRegistry.searchScopes.keySet());
    }

    private Collection<ChangeListener> cloneChangeListeners() {
        assert (Thread.holdsLock(this.getLock()));
        return this.changeListeners != null ? new ArrayList<ChangeListener>(this.changeListeners) : null;
    }

    private void log(String string) {
        LOG.finer("registry #" + this.id + ": " + string);
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.search.SearchScopeRegistry");
    }

    private final class SearchScopeChangeHandler
    implements ChangeListener {
        private SearchScopeChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            assert (changeEvent.getSource() instanceof SearchScope);
            SearchScopeRegistry.this.searchScopeStateChanged((SearchScope)changeEvent.getSource());
        }
    }
}

