/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.autoupdate;

import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;
import org.netbeans.modules.autoupdate.services.OperationSupportImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationSupport {
    private OperationContainer<OperationSupport> container;

    OperationSupport() {
    }

    public Restarter doOperation(ProgressHandle progressHandle) throws OperationException {
        Boolean bl = OperationSupport.getImpl(this.container.impl.getType()).doOperation(progressHandle, this.container);
        if (bl == null || !bl.booleanValue()) {
            return null;
        }
        return new Restarter();
    }

    public void doCancel() throws OperationException {
        OperationSupport.getImpl(this.container.impl.getType()).doCancel();
    }

    public void doRestart(Restarter restarter, ProgressHandle progressHandle) throws OperationException {
        OperationSupport.getImpl(this.container.impl.getType()).doRestart(restarter, progressHandle);
    }

    public void doRestartLater(Restarter restarter) {
        OperationSupport.getImpl(this.container.impl.getType()).doRestartLater(restarter);
    }

    void setContainer(OperationContainer<OperationSupport> operationContainer) {
        this.container = operationContainer;
    }

    private static OperationSupportImpl getImpl(OperationContainerImpl.OperationType operationType) {
        assert (operationType != null) : "OperationContainerImpl.OperationType cannot be null.";
        OperationSupportImpl operationSupportImpl = null;
        switch (operationType) {
            case INSTALL: {
                operationSupportImpl = OperationSupportImpl.forInstall();
                break;
            }
            case UNINSTALL: {
                operationSupportImpl = OperationSupportImpl.forUninstall();
                break;
            }
            case DIRECT_UNINSTALL: {
                operationSupportImpl = OperationSupportImpl.forDirectUninstall();
                break;
            }
            case UPDATE: {
                operationSupportImpl = OperationSupportImpl.forUpdate();
                break;
            }
            case ENABLE: {
                operationSupportImpl = OperationSupportImpl.forEnable();
                break;
            }
            case DISABLE: {
                operationSupportImpl = OperationSupportImpl.forDisable();
                break;
            }
            case DIRECT_DISABLE: {
                operationSupportImpl = OperationSupportImpl.forDirectDisable();
                break;
            }
            case CUSTOM_INSTALL: {
                operationSupportImpl = OperationSupportImpl.forCustomInstall();
                break;
            }
            default: {
                assert (false) : "Unknown OperationSupport for type " + (Object)((Object)operationType);
                break;
            }
        }
        assert (operationSupportImpl != null) : "OperationSupportImpl cannot be null for operation " + (Object)((Object)operationType);
        return operationSupportImpl;
    }

    public static final class Restarter {
        Restarter() {
        }
    }
}

