/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class CheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private int selectionMode;
    private boolean isSelected = true;
    private String nodeLabel;
    private Icon icon;
    private boolean disabled = false;
    private boolean needsRefresh = false;
    private String tooltip;

    public CheckNode(Object object, String string, Icon icon) {
        super(object, !(object instanceof RefactoringElement));
        RefactoringElement refactoringElement;
        int n;
        this.setSelectionMode(4);
        this.nodeLabel = string;
        this.icon = icon;
        if (object instanceof TreeElement && ((TreeElement)object).getUserObject() instanceof RefactoringElement && ((n = (refactoringElement = (RefactoringElement)((TreeElement)object).getUserObject()).getStatus()) == 2 || n == 3)) {
            this.isSelected = false;
            this.disabled = true;
            this.nodeLabel = "[<font color=#CC0000>" + NbBundle.getMessage(CheckNode.class, (String)(n == 2 ? "LBL_InGuardedBlock" : "LBL_InReadOnlyFile")) + "</font>]" + this.nodeLabel;
        }
    }

    String getLabel() {
        return this.nodeLabel;
    }

    Icon getIcon() {
        return this.icon;
    }

    public void setDisabled() {
        this.disabled = true;
        this.isSelected = false;
        this.removeAllChildren();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    void setNeedsRefresh() {
        this.needsRefresh = true;
        this.setDisabled();
    }

    boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean bl) {
        Enumeration enumeration;
        this.isSelected = bl;
        if (this.userObject instanceof TreeElement && (enumeration = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            ((RefactoringElement)((Object)enumeration)).setEnabled(bl);
        }
        if (this.selectionMode == 4 && this.children != null) {
            enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckNode checkNode = (CheckNode)enumeration.nextElement();
                checkNode.setSelected(bl);
            }
        }
    }

    public boolean isSelected() {
        Object object;
        if (this.userObject instanceof TreeElement && (object = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            return ((RefactoringElement)object).isEnabled() && ((RefactoringElement)object).getStatus() != 2 && ((RefactoringElement)object).getStatus() != 3;
        }
        return this.isSelected;
    }

    public PositionBounds getPosition() {
        Object object;
        if (this.userObject instanceof TreeElement && (object = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            return ((RefactoringElement)object).getPosition();
        }
        return null;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            Object object;
            if (this.userObject instanceof TreeElement && (object = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
                RefactoringElement refactoringElement = (RefactoringElement)object;
                PositionBounds positionBounds = this.getPosition();
                FileObject fileObject = refactoringElement.getParentFile();
                if (positionBounds != null && fileObject != null) {
                    int n;
                    try {
                        n = positionBounds.getBegin().getLine() + 1;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    this.tooltip = fileObject.getPath() + ':' + n;
                }
            }
            return null;
        }
        return this.tooltip;
    }
}

