/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.fold;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;

public final class FoldUtilities {
    private FoldUtilities() {
    }

    public static boolean isRootFold(Fold fold) {
        return fold.isRootFold();
    }

    public static int findFoldStartIndex(Fold fold, int n) {
        return FoldUtilitiesImpl.findFoldStartIndex(fold, n, true);
    }

    public static int findFoldEndIndex(Fold fold, int n) {
        return FoldUtilitiesImpl.findFoldEndIndex(fold, n);
    }

    public static boolean isEmpty(Fold fold) {
        return fold.getStartOffset() == fold.getEndOffset();
    }

    public static void collapseAll(FoldHierarchy foldHierarchy) {
        FoldUtilities.collapse(foldHierarchy, (Collection)null);
    }

    public static void collapse(FoldHierarchy foldHierarchy, FoldType foldType) {
        FoldUtilities.collapse(foldHierarchy, Collections.singleton(foldType));
    }

    public static void collapse(FoldHierarchy foldHierarchy, Collection collection) {
        FoldUtilitiesImpl.collapseOrExpand(foldHierarchy, collection, true);
    }

    public static void expandAll(FoldHierarchy foldHierarchy) {
        FoldUtilities.expand(foldHierarchy, (Collection)null);
    }

    public static void expand(FoldHierarchy foldHierarchy, FoldType foldType) {
        FoldUtilities.expand(foldHierarchy, Collections.singleton(foldType));
    }

    public static void expand(FoldHierarchy foldHierarchy, Collection collection) {
        FoldUtilitiesImpl.collapseOrExpand(foldHierarchy, collection, false);
    }

    public static boolean containsOffset(Fold fold, int n) {
        return n < fold.getEndOffset() && n >= fold.getStartOffset();
    }

    public static Fold[] childrenToArray(Fold fold) {
        return FoldUtilities.childrenToArray(fold, 0, fold.getFoldCount());
    }

    public static Fold[] childrenToArray(Fold fold, int n, int n2) {
        return fold.foldsToArray(n, n2);
    }

    public static List childrenAsList(Fold fold) {
        return FoldUtilities.childrenAsList(fold, 0, fold.getFoldCount());
    }

    public static List childrenAsList(Fold fold, int n, int n2) {
        return FoldUtilitiesImpl.childrenAsList(fold, n, n2);
    }

    public static List find(Fold fold, FoldType foldType) {
        return FoldUtilities.find(fold, Collections.singletonList(foldType));
    }

    public static List find(Fold fold, Collection collection) {
        return FoldUtilitiesImpl.find(fold, collection);
    }

    public static List findRecursive(Fold fold) {
        return FoldUtilities.findRecursive(fold, (Collection)null);
    }

    public static List findRecursive(Fold fold, FoldType foldType) {
        return FoldUtilities.findRecursive(fold, Collections.singletonList(foldType));
    }

    public static List findRecursive(Fold fold, Collection collection) {
        return FoldUtilitiesImpl.findRecursive(null, fold, collection);
    }

    public static Fold findNearestFold(FoldHierarchy foldHierarchy, int n) {
        return FoldUtilitiesImpl.findNearestFold(foldHierarchy, n, Integer.MAX_VALUE);
    }

    public static Fold findOffsetFold(FoldHierarchy foldHierarchy, int n) {
        return FoldUtilitiesImpl.findOffsetFold(foldHierarchy, n);
    }

    public static Fold findCollapsedFold(FoldHierarchy foldHierarchy, int n, int n2) {
        return FoldUtilitiesImpl.findFirstCollapsedFold(foldHierarchy, n, n2);
    }

    public static Iterator collapsedFoldIterator(FoldHierarchy foldHierarchy, int n, int n2) {
        return FoldUtilitiesImpl.collapsedFoldIterator(foldHierarchy, n, n2);
    }
}

