/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.crosstab.undo.CellResizeUndoableEdit;
import com.jaspersoft.ireport.designer.crosstab.widgets.CellSeparatorWidget;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

public class CellSeparatorMoveProvider
implements MoveProvider {
    int startY = 0;
    int startX = 0;
    boolean reversOrder = false;

    public CellSeparatorMoveProvider() {
        this(false);
    }

    public CellSeparatorMoveProvider(boolean reversOrder) {
        this.reversOrder = reversOrder;
    }

    public void movementStarted(Widget w) {
        this.startY = w.getPreferredLocation().y;
        this.startX = w.getPreferredLocation().x;
        w.setForeground(AbstractReportObjectScene.EDITING_DESIGN_LINE_COLOR);
    }

    public void movementFinished(Widget w) {
        int i;
        int index;
        JRCrosstabCell[][] cells;
        JRCrosstabColumnGroup[] groups;
        w.setForeground(new Color(0, 0, 0, 0));
        if (!(w instanceof CellSeparatorWidget)) {
            return;
        }
        CellSeparatorWidget separator = (CellSeparatorWidget)w;
        CrosstabObjectScene scene = (CrosstabObjectScene)w.getScene();
        int delta = 0;
        ArrayList<CellResizeUndoableEdit> undos = new ArrayList<CellResizeUndoableEdit>();
        int currentPosition = 0;
        if (separator.getOrientation() == SeparatorWidget.Orientation.HORIZONTAL) {
            currentPosition = this.startY;
            delta = w.getPreferredLocation().y - this.startY;
            groups = scene.getDesignCrosstab().getColumnGroups();
            if (separator.getIndex() < groups.length) {
                int h = ((JRDesignCrosstabColumnGroup)groups[separator.getIndex()]).getHeight();
                JRDesignCrosstabColumnGroup cell = (JRDesignCrosstabColumnGroup)groups[separator.getIndex()];
                undos.add(new CellResizeUndoableEdit(cell, "Height", Integer.TYPE, h, h + delta));
                cell.setHeight(h + delta);
            } else {
                JRCrosstabColumnGroup[] col_groups = scene.getDesignCrosstab().getColumnGroups();
                JRCrosstabRowGroup[] row_groups = scene.getDesignCrosstab().getRowGroups();
                cells = ModelUtils.normalizeCell(scene.getDesignCrosstab().getCells(), row_groups, col_groups);
                index = separator.getIndex() - groups.length;
                index = cells.length - (index + 1);
                for (i = 0; i < cells[index].length; ++i) {
                    if (cells[index][i] == null) continue;
                    int h = -1;
                    JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells[index][i];
                    if (cell.getHeight() != null) {
                        h = cell.getHeight();
                    } else if (cell.getContents() != null) {
                        h = cell.getContents().getHeight();
                    }
                    if (h < 0) continue;
                    undos.add(new CellResizeUndoableEdit(cell, "Height", Integer.class, h, h + delta));
                    cell.setHeight(Integer.valueOf(h + delta));
                }
            }
        } else {
            currentPosition = this.startX;
            delta = w.getPreferredLocation().x - this.startX;
            groups = scene.getDesignCrosstab().getRowGroups();
            if (separator.getIndex() < groups.length) {
                JRDesignCrosstabRowGroup group = (JRDesignCrosstabRowGroup)groups[separator.getIndex()];
                int width = group.getWidth();
                undos.add(new CellResizeUndoableEdit(group, "Width", Integer.TYPE, width, width + delta));
                group.setWidth(width + delta);
            } else {
                JRCrosstabColumnGroup[] col_groups = scene.getDesignCrosstab().getColumnGroups();
                JRCrosstabRowGroup[] row_groups = scene.getDesignCrosstab().getRowGroups();
                cells = ModelUtils.normalizeCell(scene.getDesignCrosstab().getCells(), row_groups, col_groups);
                index = separator.getIndex() - groups.length;
                index = cells[0].length - (index + 1);
                for (i = 0; i < cells.length; ++i) {
                    JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells[i][index];
                    if (cell == null) continue;
                    int width = -1;
                    if (cell.getWidth() != null) {
                        width = cell.getWidth();
                    } else if (cell.getContents() != null) {
                        width = cell.getContents().getWidth();
                    }
                    if (width < 0) continue;
                    undos.add(new CellResizeUndoableEdit(cell, "Width", Integer.class, width, width + delta));
                    cell.setWidth(Integer.valueOf(width + delta));
                }
            }
        }
        if (delta != 0 && undos.size() > 0) {
            CellResizeUndoableEdit mainUndo = (CellResizeUndoableEdit)undos.get(0);
            mainUndo.setMain(true);
            mainUndo.setCrosstab(scene.getDesignCrosstab());
            for (int i2 = 1; i2 < undos.size(); ++i2) {
                CellResizeUndoableEdit undo = (CellResizeUndoableEdit)undos.get(i2);
                mainUndo.concatenate(undo);
            }
            IReportManager.getInstance().addUndoableEdit(mainUndo, false);
            scene.getDesignCrosstab().preprocess();
            scene.rebuildDocument();
        }
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point newLocation) {
        widget.setPreferredLocation(newLocation);
    }
}

