/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static final Logger LOG = Logger.getLogger(Settings.class.getName());
    private static final boolean LOG_STACTRACES = Boolean.getBoolean(Settings.class.getName() + ".stacktraces");
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static long initializerListsVersion = 0L;
    private static List[] listsOfInitializers = null;
    private static long listsOfInitializersVersion = -1L;
    private static InitializerSorter currentInitializerSorter;
    private static final Filter[] NULL_FILTERS;
    private static final String FILTERS_LOCK;
    private static volatile Filter[] filters;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static volatile int firingEnabled;
    private static final HashMap emptyMaps;
    private static final RequestProcessor PROCESSOR;
    private static final RequestProcessor.Task RESET_TASK;
    private static final Map<MimePath, ChangesTrackingLookupResult<FontColorSettings>> FCS_CACHE;
    private static final Set<String> HIGHLIGHT_COLOR_NAMES;
    private static final Set<String> HIGHLIGHT_COLORING_NAMES;
    private static final Map<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>> KBS_CACHE;
    private static final Map<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>> CTS_CACHE;
    private static final SettingsToMimeLookupBridge S2ML_BRIDGE;

    private Settings() {
    }

    public static void addInitializer(Initializer initializer) {
        Settings.addInitializer(initializer, 1);
        Settings.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitializer(Initializer initializer, int n) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            int n2;
            for (int i = n2 = initializerLists.size(); i <= n; ++i) {
                initializerLists.add(new ArrayList());
            }
            ((List)initializerLists.get(n)).add(initializer);
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitializer(String string) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            Iterator iterator = initializerLists.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    if (!string.equals(((Initializer)iterator2.next()).getName())) continue;
                    iterator2.remove();
                }
            }
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitializerSorter getInitializerSorter() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            return currentInitializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitializerSorter(InitializerSorter initializerSorter) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            currentInitializerSorter = initializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List[] getListsOfInitializers() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            if (listsOfInitializersVersion != initializerListsVersion) {
                List[] listArray = initializerLists.toArray(new List[initializerLists.size()]);
                for (int i = 0; i < listArray.length; ++i) {
                    listArray[i] = Collections.unmodifiableList(new ArrayList(listArray[i]));
                }
                listsOfInitializers = listArray;
                listsOfInitializersVersion = initializerListsVersion;
            }
            return listsOfInitializers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilter(Filter filter) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                filters = new Filter[]{filter};
            } else {
                Filter[] filterArray = new Filter[filters.length + 1];
                System.arraycopy(filters, 0, filterArray, 0, filters.length);
                filterArray[Settings.filters.length] = filter;
                filters = filterArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilter(Filter filter) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                return;
            }
            if (filters.length == 1 && filters[0] == filter) {
                filters = NULL_FILTERS;
            } else {
                int n = -1;
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] != filter) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    Filter[] filterArray = new Filter[filters.length - 1];
                    System.arraycopy(filters, 0, filterArray, 0, n);
                    if (n < filterArray.length) {
                        System.arraycopy(filters, n + 1, filterArray, n, filterArray.length - n);
                    }
                    filters = filterArray;
                }
            }
        }
    }

    public static Object getValue(Class clazz, String string) {
        return Settings.getValue(clazz, string, true);
    }

    public static Object getValue(Class clazz, String string, boolean bl) {
        int n;
        Object object;
        Object object2 = null;
        boolean bl2 = false;
        if (!bl2) {
            if (string != null && HIGHLIGHT_COLOR_NAMES.contains(string)) {
                object2 = Settings.findColor(string, clazz);
                bl2 = true;
            } else if (string != null && HIGHLIGHT_COLORING_NAMES.contains(string)) {
                object2 = Settings.findColoring(string, clazz, false, true);
                bl2 = true;
            } else {
                object = Settings.translateOldTokenColoringName(string);
                if (object != null) {
                    object2 = Settings.findColoring((String)object, clazz, true, true);
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            object = Settings.getAllKitMaps(clazz);
            assert (object.size() % 2 == 0) : "allKitMaps should contain pairs of [kitClass, settingsMap].";
            for (n = 0; n < object.size() / 2; ++n) {
                Class clazz2 = (Class)object.get(2 * n);
                Map map = (Map)object.get(2 * n + 1);
                object2 = map.get(string);
                if (bl && object2 instanceof Evaluator) {
                    object2 = ((Evaluator)object2).getValue(clazz2, string);
                }
                if (object2 != null) break;
            }
        }
        object = filters;
        for (n = 0; n < ((Object)object).length; ++n) {
            object2 = object[n].filterValue(clazz, string, object2);
        }
        return object2;
    }

    public static KitAndValue[] getValueHierarchy(Class clazz, String string) {
        return Settings.getValueHierarchy(clazz, string, true);
    }

    public static KitAndValue[] getValueHierarchy(Class clazz, String string, boolean bl) {
        Filter[] filterArray;
        ArrayList<KitAndValue> arrayList = new ArrayList<KitAndValue>();
        List list = Settings.getAllKitMaps(clazz);
        assert (list.size() % 2 == 0) : "allKitMaps should contain pairs of [kitClass, settingsMap].";
        for (int i = 0; i < list.size() / 2; ++i) {
            filterArray = (Filter[])list.get(2 * i);
            Map map = (Map)list.get(2 * i + 1);
            Object object = map.get(string);
            if (bl && object instanceof Evaluator) {
                object = ((Evaluator)object).getValue((Class)filterArray, string);
            }
            if (object == null) continue;
            arrayList.add(new KitAndValue((Class)filterArray, object));
        }
        KitAndValue[] kitAndValueArray = arrayList.toArray(new KitAndValue[arrayList.size()]);
        filterArray = filters;
        for (int i = 0; i < filterArray.length; ++i) {
            kitAndValueArray = filterArray[i].filterValueHierarchy(clazz, string, kitAndValueArray);
        }
        return kitAndValueArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(Class clazz, String string, Object object) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(clazz, true);
            Object v = map.get(string);
            if (v == null && object == null || v != null && v.equals(object)) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            if (object != null) {
                map.put(string, object);
            } else {
                map.remove(string);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Settings.fireSettingsChange(clazz, string, v, object);
            return;
        }
    }

    public static void touchValue(Class clazz, String string) {
        Settings.fireSettingsChange(clazz, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateValue(Class clazz, String string, Object object) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(clazz, true);
            if (object != null) {
                map.put(string, object);
            } else {
                map.remove(string);
            }
            for (Map.Entry entry : kit2Maps.entrySet()) {
                Class clazz3 = (Class)entry.getKey();
                if (clazz == clazz3 || clazz != null && !clazz.isAssignableFrom(clazz3)) continue;
                ((Map)entry.getValue()).remove(string);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Settings.fireSettingsChange(null, string, null, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void update(Runnable runnable) {
        if (Settings.isAsyncTask(runnable)) {
            PROCESSOR.post(runnable, Settings.getTaskDelay(runnable));
            return;
        }
        boolean bl = false;
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean bl2;
            ++firingEnabled;
            try {
                runnable.run();
                if (--firingEnabled != 0) return;
                bl2 = true;
            }
            catch (Throwable throwable) {
                bl = --firingEnabled == 0;
                throw throwable;
            }
            bl = bl2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!bl) return;
            Settings.fireSettingsChange(null, null, null, null);
            return;
        }
    }

    private static boolean isAsyncTask(Runnable runnable) {
        try {
            Method method = runnable.getClass().getDeclaredMethod("asynchronous", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)runnable, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int getTaskDelay(Runnable runnable) {
        try {
            Method method = runnable.getClass().getDeclaredMethod("delay", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)runnable, new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void reset() {
        RESET_TASK.schedule(1);
    }

    public static String initializersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        List[] listArray = Settings.getListsOfInitializers();
        for (int i = 0; i < listArray.length; ++i) {
            switch (i) {
                case 0: {
                    stringBuffer.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    stringBuffer.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    stringBuffer.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    stringBuffer.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    stringBuffer.append("USER_LEVEL");
                    break;
                }
                default: {
                    stringBuffer.append("level " + i);
                }
            }
            stringBuffer.append(":\n");
            stringBuffer.append(EditorDebug.debugList(listArray[i]));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.add(SettingsChangeListener.class, settingsChangeListener);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.remove(SettingsChangeListener.class, settingsChangeListener);
    }

    private static void fireSettingsChange(Class clazz, String string, Object object, Object object2) {
        if (firingEnabled == 0) {
            SettingsChangeListener[] settingsChangeListenerArray = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent settingsChangeEvent = new SettingsChangeEvent(Settings.class, clazz, string, object, object2);
            for (int i = 0; i < settingsChangeListenerArray.length; ++i) {
                settingsChangeListenerArray[i].settingsChange(settingsChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getKitMap(Class clazz, boolean bl) {
        ++firingEnabled;
        try {
            Map map = Settings.getKitMapWithEvent(clazz, bl);
            return map;
        }
        finally {
            --firingEnabled;
        }
    }

    private static Map getKitMapWithEvent(Class clazz, boolean bl) {
        Map map = (Map)kit2Maps.get(clazz);
        if (map == null) {
            LoggingMap loggingMap = (LoggingMap)emptyMaps.get(clazz);
            if (loggingMap != null) {
                return loggingMap;
            }
            if (loggingMap == null) {
                loggingMap = LOG.isLoggable(Level.FINE) ? new LoggingMap(clazz, Level.FINE) : new HashMap();
                emptyMaps.put(clazz, loggingMap);
            }
            List[] listArray = Settings.getListsOfInitializers();
            for (int i = 0; i < listArray.length; ++i) {
                for (Initializer initializer : listArray[i]) {
                    try {
                        initializer.updateSettingsMap(clazz, loggingMap);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, null, throwable);
                    }
                }
            }
            if (!loggingMap.containsKey("abbrev-map")) {
                loggingMap.put("abbrev-map", S2ML_BRIDGE);
            }
            if (!loggingMap.containsKey("key-bindings")) {
                loggingMap.put("key-bindings", S2ML_BRIDGE);
            }
            map = loggingMap;
            kit2Maps.put(clazz, map);
            emptyMaps.remove(clazz);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getAllKitMaps(Class clazz) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Serializable serializable;
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (serializable = clazz; serializable != null; serializable = ((Class)serializable).getSuperclass()) {
                arrayList.add((Class)serializable);
            }
            serializable = new ArrayList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Class clazz3 = (Class)arrayList.get(i);
                Map map = Settings.getKitMap(clazz3, false);
                if (map == null) continue;
                serializable.add(map);
                serializable.add(clazz3);
            }
            Collections.reverse(serializable);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serializable;
        }
    }

    private static Coloring findColoring(String string, Class clazz, boolean bl, boolean bl2) {
        AttributeSet attributeSet = Settings.findAttribs(string, clazz, bl, bl2);
        return attributeSet == null ? null : Coloring.fromAttributeSet(attributeSet);
    }

    private static Color findColor(String string, Class clazz) {
        AttributeSet attributeSet = Settings.findAttribs(string, clazz, false, true);
        return attributeSet == null ? null : (Color)attributeSet.getAttribute(StyleConstants.Foreground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttributeSet findAttribs(String string, Class clazz, boolean bl, boolean bl2) {
        String string2 = BaseKit.kitsTracker_FindMimeType(clazz);
        Map<MimePath, ChangesTrackingLookupResult<FontColorSettings>> map = FCS_CACHE;
        synchronized (map) {
            FontColorSettings fontColorSettings;
            Object object;
            MimePath mimePath = string2 == null ? MimePath.EMPTY : MimePath.parse((String)string2);
            ChangesTrackingLookupResult<Object> changesTrackingLookupResult = FCS_CACHE.get(mimePath);
            if (changesTrackingLookupResult == null) {
                object = MimeLookup.getLookup((MimePath)mimePath).lookupResult(FontColorSettings.class);
                changesTrackingLookupResult = new ChangesTrackingLookupResult(object, null);
                FCS_CACHE.put(mimePath, changesTrackingLookupResult);
            }
            object = null;
            Collection collection = changesTrackingLookupResult.getLookupResult().allInstances();
            FontColorSettings fontColorSettings2 = fontColorSettings = collection.isEmpty() ? null : (FontColorSettings)collection.iterator().next();
            if (fontColorSettings != null) {
                if (bl && !bl2) {
                    object = fontColorSettings.getTokenFontColors(string);
                } else if (!bl && bl2) {
                    object = fontColorSettings.getFontColors(string);
                } else {
                    object = fontColorSettings.getFontColors(string);
                    if (object == null) {
                        object = fontColorSettings.getTokenFontColors(string);
                    }
                }
            }
            return object;
        }
    }

    private static String translateOldTokenColoringName(String string) {
        String string2 = null;
        if (string != null && string.endsWith("-coloring")) {
            string2 = string.substring(0, string.length() - "-coloring".length());
        }
        if (string != null && string.endsWith("-print-coloring")) {
            string2 = string.substring(0, string.length() - "-print-coloring".length());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MultiKeyBinding> findKeyBindings(Class clazz) {
        String string = BaseKit.kitsTracker_FindMimeType(clazz);
        Map<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>> map = KBS_CACHE;
        synchronized (map) {
            ArrayList<MultiKeyBinding> arrayList;
            MimePath mimePath = string == null ? MimePath.EMPTY : MimePath.parse((String)string);
            ChangesTrackingLookupResult<Object> changesTrackingLookupResult = KBS_CACHE.get(mimePath);
            if (changesTrackingLookupResult == null) {
                arrayList = MimeLookup.getLookup((MimePath)mimePath).lookupResult(KeyBindingSettings.class);
                changesTrackingLookupResult = new ChangesTrackingLookupResult(arrayList, "key-bindings");
                KBS_CACHE.put(mimePath, changesTrackingLookupResult);
            }
            if ((arrayList = (ArrayList<MultiKeyBinding>)changesTrackingLookupResult.getCustomData()) == null) {
                Collection collection = changesTrackingLookupResult.getLookupResult().allInstances();
                KeyBindingSettings keyBindingSettings = collection.isEmpty() ? null : (KeyBindingSettings)collection.iterator().next();
                arrayList = new ArrayList<MultiKeyBinding>();
                if (keyBindingSettings != null) {
                    for (org.netbeans.api.editor.settings.MultiKeyBinding multiKeyBinding : keyBindingSettings.getKeyBindings()) {
                        List list = multiKeyBinding.getKeyStrokeList();
                        arrayList.add(new MultiKeyBinding(list.toArray(new KeyStroke[list.size()]), multiKeyBinding.getActionName()));
                    }
                    changesTrackingLookupResult.setCustomData(arrayList);
                }
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> findCodeTemplates(Class clazz) {
        String string = BaseKit.kitsTracker_FindMimeType(clazz);
        Map<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>> map = CTS_CACHE;
        synchronized (map) {
            HashMap<String, String> hashMap;
            MimePath mimePath = string == null ? MimePath.EMPTY : MimePath.parse((String)string);
            ChangesTrackingLookupResult<Object> changesTrackingLookupResult = CTS_CACHE.get(mimePath);
            if (changesTrackingLookupResult == null) {
                hashMap = MimeLookup.getLookup((MimePath)mimePath).lookupResult(CodeTemplateSettings.class);
                changesTrackingLookupResult = new ChangesTrackingLookupResult(hashMap, "abbrev-map");
                CTS_CACHE.put(mimePath, changesTrackingLookupResult);
            }
            if ((hashMap = (HashMap<String, String>)changesTrackingLookupResult.getCustomData()) == null) {
                Collection collection = changesTrackingLookupResult.getLookupResult().allInstances();
                CodeTemplateSettings codeTemplateSettings = collection.isEmpty() ? null : (CodeTemplateSettings)collection.iterator().next();
                hashMap = new HashMap<String, String>();
                if (codeTemplateSettings != null) {
                    for (CodeTemplateDescription codeTemplateDescription : codeTemplateSettings.getCodeTemplateDescriptions()) {
                        hashMap.put(codeTemplateDescription.getAbbreviation(), codeTemplateDescription.getParametrizedText());
                    }
                    changesTrackingLookupResult.setCustomData(hashMap);
                }
            }
            return hashMap;
        }
    }

    static {
        NULL_FILTERS = new Filter[0];
        FILTERS_LOCK = new String("Settings.FILTERS_LOCK");
        filters = NULL_FILTERS;
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        firingEnabled = 0;
        emptyMaps = new HashMap();
        PROCESSOR = new RequestProcessor("org.netbeans.editor.Settings.PROCESSOR");
        RESET_TASK = PROCESSOR.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<Settings> clazz = Settings.class;
                synchronized (Settings.class) {
                    kit2Maps.clear();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Settings.fireSettingsChange(null, null, null, null);
                    return;
                }
            }
        });
        FCS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<FontColorSettings>>();
        HIGHLIGHT_COLOR_NAMES = new HashSet<String>();
        HIGHLIGHT_COLORING_NAMES = new HashSet<String>();
        HIGHLIGHT_COLOR_NAMES.add("caret-color-insert-mode");
        HIGHLIGHT_COLOR_NAMES.add("caret-color-overwrite-mode");
        HIGHLIGHT_COLOR_NAMES.add("text-limit-line-color");
        HIGHLIGHT_COLORING_NAMES.add("line-number");
        HIGHLIGHT_COLORING_NAMES.add("guarded");
        HIGHLIGHT_COLORING_NAMES.add("code-folding");
        HIGHLIGHT_COLORING_NAMES.add("code-folding-bar");
        HIGHLIGHT_COLORING_NAMES.add("selection");
        HIGHLIGHT_COLORING_NAMES.add("highlight-search");
        HIGHLIGHT_COLORING_NAMES.add("inc-search");
        HIGHLIGHT_COLORING_NAMES.add("block-search");
        HIGHLIGHT_COLORING_NAMES.add("status-bar");
        HIGHLIGHT_COLORING_NAMES.add("status-bar-bold");
        KBS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>>();
        CTS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>>();
        S2ML_BRIDGE = new SettingsToMimeLookupBridge();
    }

    private static final class SettingsToMimeLookupBridge
    implements Evaluator {
        private SettingsToMimeLookupBridge() {
        }

        public Object getValue(Class clazz, String string) {
            if ("abbrev-map".equals(string)) {
                return Settings.findCodeTemplates(clazz);
            }
            if ("key-bindings".equals(string)) {
                return Settings.findKeyBindings(clazz);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangesTrackingLookupResult<T>
    implements LookupListener {
        private final Lookup.Result<T> lookupResult;
        private final String settingName;
        private Object customData = null;

        public ChangesTrackingLookupResult(Lookup.Result<T> result, String string) {
            this.lookupResult = result;
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
            this.settingName = string;
        }

        public Lookup.Result<T> getLookupResult() {
            return this.lookupResult;
        }

        public Object getCustomData() {
            return this.customData;
        }

        public void setCustomData(Object object) {
            this.customData = object;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.customData = null;
            Settings.fireSettingsChange(null, this.settingName, null, null);
        }
    }

    private static final class LoggingMap
    extends HashMap {
        private Class kitClass;
        private Level logLevel;
        private static final Set<String> DEPRECATED_SETTINGS = Collections.synchronizedSet(Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("block-search", "caret-color-insert-mode", "caret-color-overwrite-mode", "code-folding", "coloring-name-list", "-print-coloring", "-coloring", "default", "guarded", "highlight-search", "inc-search", "line-number", "selection", "status-bar-bold", "status-bar", "text-limit-line-color", "key-bindings"))));

        public LoggingMap(Class clazz, Level level) {
            this.kitClass = clazz;
            this.logLevel = level;
        }

        public Object put(Object object, Object object2) {
            if (object != null && (object.equals("rendering-hints") || object.equals("textAntialiasing"))) {
                String string = "Settings map: put('" + object + "' to '" + object2 + "') for kitClass=" + this.kitClass;
                if (LOG_STACTRACES) {
                    LOG.log(this.logLevel, null, new Throwable(string));
                } else {
                    LOG.log(this.logLevel, string);
                }
            }
            this.logDeprecatedKey(object);
            return super.put(object, object2);
        }

        public Object get(Object object) {
            this.logDeprecatedKey(object);
            return super.get(object);
        }

        public boolean containsKey(Object object) {
            this.logDeprecatedKey(object);
            return super.containsKey(object);
        }

        public Object remove(Object object) {
            this.logDeprecatedKey(object);
            return super.remove(object);
        }

        private void logDeprecatedKey(Object object) {
            if (LOG.isLoggable(this.logLevel) && object != null && DEPRECATED_SETTINGS.contains(object)) {
                String string = "The editor setting '" + object + "' is deprecated. Please use Editor Settings API instead.";
                if (LOG_STACTRACES) {
                    LOG.log(this.logLevel, null, new Throwable(string));
                } else {
                    LOG.log(this.logLevel, string);
                }
            }
        }
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter initializerSorter) {
            this.delegate = initializerSorter;
        }

        public void sort(List list) {
            if (this.delegate != null) {
                this.delegate.sort(list);
            }
        }
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class clazz, Object object) {
            this.kitClass = clazz;
            this.value = object;
        }
    }
}

