/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldMultiLineView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.lib.editor.view.GapDocumentView;

class DrawEngineDocView
extends GapDocumentView
implements FoldHierarchyListener,
PropertyChangeListener {
    private static final boolean debugRebuild = Boolean.getBoolean("netbeans.debug.editor.view.rebuild");
    private FoldHierarchy foldHierarchy;
    private EditorUI editorUI;
    private Iterator collapsedFoldIterator;
    private Fold collapsedFold;
    private int collapsedFoldStartOffset;
    private int collapsedFoldEndOffset;
    private boolean collapsedFoldsInPresentViews;
    private boolean estimatedSpanResetInitiated;

    DrawEngineDocView(Element element) {
        super(element);
        this.setEstimatedSpan(true);
    }

    public void setParent(View view) {
        if (view != null) {
            JTextComponent jTextComponent = (JTextComponent)view.getContainer();
            this.foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
            TextUI textUI = jTextComponent.getUI();
            if (textUI instanceof BaseTextUI) {
                this.editorUI = ((BaseTextUI)textUI).getEditorUI();
                if (this.editorUI != null) {
                    this.editorUI.addPropertyChangeListener(this);
                }
            }
        }
        super.setParent(view);
        if (view == null) {
            this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
            this.foldHierarchy = null;
            if (this.editorUI != null) {
                this.editorUI.removePropertyChangeListener(this);
                this.editorUI = null;
            }
        }
    }

    protected void attachListeners() {
        if (this.foldHierarchy != null) {
            // empty if block
        }
    }

    private FoldHierarchy getFoldHierarchy() {
        return this.foldHierarchy;
    }

    protected boolean useCustomReloadChildren() {
        return true;
    }

    protected Fold nextCollapsedFold() {
        Fold fold;
        block3: {
            while (true) {
                Fold fold2 = fold = this.collapsedFoldIterator.hasNext() ? (Fold)this.collapsedFoldIterator.next() : null;
                if (fold == null) break block3;
                this.collapsedFoldStartOffset = fold.getStartOffset();
                this.collapsedFoldEndOffset = fold.getEndOffset();
                if (this.collapsedFoldStartOffset != this.collapsedFoldEndOffset) break;
                if (!debugRebuild) continue;
                System.err.println("GapBoxView.nextCollapsedFold(): ignored empty fold " + fold);
            }
            if (this.collapsedFoldEndOffset > this.getDocument().getLength()) {
                fold = null;
            }
        }
        if (fold != null) {
            this.collapsedFoldsInPresentViews = true;
        }
        return fold;
    }

    protected void initCustomReloadChildren(FoldHierarchy foldHierarchy, int n, int n2) {
        this.collapsedFoldIterator = FoldUtilities.collapsedFoldIterator((FoldHierarchy)foldHierarchy, (int)n, (int)n2);
        this.collapsedFold = this.nextCollapsedFold();
    }

    protected void finishCustomReloadChildren(FoldHierarchy foldHierarchy) {
        this.collapsedFoldIterator = null;
        this.collapsedFold = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customReloadChildren(int n, int n2, int n3, int n4) {
        FoldHierarchy foldHierarchy;
        if (n == 0 && n2 == this.getViewCount()) {
            this.collapsedFoldsInPresentViews = false;
        }
        if ((foldHierarchy = this.getFoldHierarchy()) != null) {
            foldHierarchy.lock();
            try {
                this.initCustomReloadChildren(foldHierarchy, n3, n4);
                super.customReloadChildren(n, n2, n3, n4);
                this.finishCustomReloadChildren(foldHierarchy);
            }
            finally {
                foldHierarchy.unlock();
            }
        }
    }

    protected View createCustomView(ViewFactory viewFactory, int n, int n2, int n3) {
        boolean bl;
        if (n3 == -1) {
            throw new IllegalStateException("Need underlying line element structure");
        }
        View view = null;
        Element element = this.getElement();
        Element element2 = element.getElement(n3);
        boolean bl2 = bl = this.collapsedFold != null;
        if (bl) {
            int n4 = element2.getEndOffset();
            boolean bl3 = bl = this.collapsedFoldStartOffset < n4;
            if (bl) {
                Element element3 = element2;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                do {
                    int n5 = this.collapsedFold.getEndOffset();
                    while (n5 > n4) {
                        element2 = element.getElement(++n3);
                        n4 = element2.getEndOffset();
                    }
                    arrayList.add(this.collapsedFold);
                    arrayList.add(element2);
                    this.collapsedFold = this.nextCollapsedFold();
                } while (this.collapsedFold != null && this.collapsedFoldStartOffset < n4);
                view = new FoldMultiLineView(element3, arrayList);
            }
        }
        if (!bl) {
            view = viewFactory.create(element2);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
        LockView lockView = LockView.get(this);
        lockView.lock();
        try {
            this.layoutLock();
            try {
                FoldHierarchy foldHierarchy = (FoldHierarchy)foldHierarchyEvent.getSource();
                if (foldHierarchy.getComponent().getDocument() != lockView.getDocument()) {
                    return;
                }
                boolean bl = true;
                int n = foldHierarchyEvent.getAffectedStartOffset();
                int n2 = foldHierarchyEvent.getAffectedEndOffset();
                if (!this.collapsedFoldsInPresentViews && FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n2) == null) {
                    bl = false;
                }
                if (bl) {
                    int n3 = this.getDocument().getLength();
                    int n4 = Math.min(n, n3);
                    int n5 = Math.min(n2, n3);
                    this.offsetRebuild(n4, n5);
                }
            }
            finally {
                this.updateLayout();
                this.layoutUnlock();
            }
        }
        finally {
            lockView.unlock();
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        TextUI textUI;
        Container container = this.getContainer();
        if (container instanceof JTextComponent && (textUI = ((JTextComponent)container).getUI()) instanceof BaseTextUI) {
            ((BaseTextUI)textUI).getEditorUI().paint(graphics);
        }
        super.paint(graphics, shape);
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
    }

    protected boolean isChildrenResizeDisabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (jTextComponent == null || propertyChangeEvent == null || !"line-height-changed-prop".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        if (abstractDocument != null) {
            abstractDocument.readLock();
            try {
                LockView lockView = LockView.get(this);
                lockView.lock();
                try {
                    this.rebuild(0, this.getViewCount());
                }
                finally {
                    lockView.unlock();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
            jTextComponent.revalidate();
        }
    }

    public int getYFromPos(int n, Shape shape) {
        int n2 = this.getViewIndex(n);
        if (n2 >= 0) {
            Shape shape2 = this.getChildAllocation(n2, shape);
            return shape2 instanceof Rectangle ? ((Rectangle)shape2).y : (shape2 != null ? shape2.getBounds().y : 0);
        }
        return 0;
    }
}

