/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.palette.DefaultSettings;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    private NodeRenderer nodeRenderer;
    private DefaultSettings settings;
    private static Dimension checkDim;
    static Rectangle checkBounds;
    private Component stringDisplayer = new JLabel(" ");

    public CheckRenderer(DefaultSettings defaultSettings) {
        this.nodeRenderer = new NodeRenderer();
        this.settings = defaultSettings;
        this.setLayout(null);
        this.check = new JCheckBox();
        this.add(this.check);
        Color color = UIManager.getColor("Tree.textBackground");
        if (color == null) {
            color = Color.WHITE;
        }
        this.check.setBackground(color);
        Dimension dimension = this.check.getPreferredSize();
        this.check.setPreferredSize(checkDim);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.stringDisplayer = this.nodeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        TreePath treePath = jTree.getPathForRow(n);
        if (null != treePath && 1 == treePath.getPathCount()) {
            return this.stringDisplayer;
        }
        if (this.stringDisplayer instanceof JComponent) {
            this.setToolTipText(((JComponent)this.stringDisplayer).getToolTipText());
        }
        if (this.stringDisplayer.getBackground() == null) {
            this.stringDisplayer.setBackground(jTree.getBackground());
        }
        if (this.stringDisplayer.getForeground() == null) {
            this.stringDisplayer.setForeground(jTree.getForeground());
        }
        if (this.check != null) {
            Node node = object instanceof Node ? (Node)object : Visualizer.findNode((Object)object);
            this.check.setSelected(null == node || this.settings.isNodeVisible(node));
            this.check.setEnabled(true);
        }
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.check == null ? new Dimension(0, 0) : this.check.getSize();
        Dimension dimension2 = this.stringDisplayer == null ? new Dimension(0, 0) : this.stringDisplayer.getPreferredSize();
        boolean bl = false;
        int n = 0;
        if (dimension.height >= dimension2.height) {
            n = (dimension.height - dimension2.height) / 2;
        }
        if (this.check != null) {
            this.check.setBounds(0, 0, dimension.width, dimension.height);
            this.check.paint(graphics);
        }
        if (this.stringDisplayer != null) {
            int n2 = n - 2;
            this.stringDisplayer.setBounds(dimension.width, n2, dimension2.width, this.getHeight() - 1);
            graphics.translate(dimension.width, n);
            this.stringDisplayer.paint(graphics);
            graphics.translate(-dimension.width, -n);
        }
    }

    public Dimension getPreferredSize() {
        if (this.stringDisplayer != null) {
            this.stringDisplayer.setFont(this.getFont());
        }
        Dimension dimension = this.check == null ? new Dimension(0, CheckRenderer.checkDim.height) : this.check.getPreferredSize();
        Dimension dimension2 = this.stringDisplayer != null ? this.stringDisplayer.getPreferredSize() : new Dimension(0, 0);
        return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
    }

    public void doLayout() {
        Dimension dimension = this.check == null ? new Dimension(0, 0) : this.check.getPreferredSize();
        Dimension dimension2 = this.stringDisplayer == null ? new Dimension(0, 0) : this.stringDisplayer.getPreferredSize();
        int n = 0;
        int n2 = 0;
        if (dimension.height < dimension2.height) {
            n = (dimension2.height - dimension.height) / 2;
        } else {
            n2 = (dimension.height - dimension2.height) / 2;
        }
        if (this.check != null) {
            this.check.setLocation(0, n);
            this.check.setBounds(0, n, dimension.width, dimension.height);
            if (checkBounds == null) {
                checkBounds = this.check.getBounds();
            }
        }
    }

    public static Rectangle getCheckBoxRectangle() {
        return (Rectangle)checkBounds.clone();
    }

    static {
        Dimension dimension = new JCheckBox().getPreferredSize();
        checkDim = new Dimension(dimension.width, dimension.height - 5);
    }
}

