/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.awt.HtmlRenderer;

public final class GtkViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int BUMP_X_PAD = 0;
    private static final int BUMP_WIDTH = 0;
    private static final int TXT_X_PAD = 3;
    private static final int TXT_Y_PAD = 5;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private static JTabbedPane dummyTab;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private GtkViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new GtkViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 19 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 5;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        Color color = jComponent.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paintOverallBorder(graphics, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void paintOverallBorder(Graphics graphics, JComponent jComponent) {
    }

    protected Font getTxtFont() {
        Font font = UIManager.getFont("controlFont");
        if (font != null) {
            return font;
        }
        return super.getTxtFont();
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Serializable serializable;
        --n5;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            serializable = this.getControlButtons();
            if (null != serializable) {
                Dimension dimension = serializable.getPreferredSize();
                n6 = n4 - (dimension.width + 2 + 6);
                serializable.setLocation(n2 + n6 + 6, n3 + (n5 - dimension.height) / 2 + 2);
            }
        } else {
            n6 = n4 - 6;
        }
        this.drawBump(graphics, n, n2 + 4, n3 + 6, 0, n5 - 8);
        serializable = UIManager.getColor("TabbedPane.foreground");
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 3), (int)(n3 + fontMetrics.getAscent() + 5), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)serializable, (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void paintTabBackgroundNative(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n6 = this.isSelected(n) ? 512 : 1024;
        if (dummyTab == null) {
            dummyTab = new JTabbedPane();
        }
        Region region = Region.TABBED_PANE_TAB;
        SynthLookAndFeel synthLookAndFeel = (SynthLookAndFeel)UIManager.getLookAndFeel();
        SynthStyleFactory synthStyleFactory = synthLookAndFeel.getStyleFactory();
        SynthStyle synthStyle = synthStyleFactory.getStyle(dummyTab, region);
        SynthContext synthContext = new SynthContext(dummyTab, region, synthStyle, n6);
        SynthPainter synthPainter = synthStyle.getPainter(synthContext);
        if (n6 == 512) {
            RescaleOp rescaleOp = null;
            if (this.isActive()) {
                rescaleOp = new RescaleOp(1.08f, 0.0f, null);
            } else {
                rescaleOp = new RescaleOp(0.96f, 0.0f, null);
                ++n3;
                --n5;
            }
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setBackground(UIManager.getColor("Panel.background"));
            graphics2D.clearRect(0, 0, n4, n5);
            synthPainter.paintTabbedPaneTabBackground(synthContext, graphics2D, 0, 0, n4, n5, n);
            BufferedImage bufferedImage2 = rescaleOp.filter(bufferedImage, null);
            graphics.drawImage(bufferedImage2, n2, n3, null);
        } else {
            synthPainter.paintTabbedPaneTabBackground(synthContext, graphics, n2, n3 + 2, n4, n5 - 2, n);
        }
    }

    private void drawBump(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_bigclose_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_bigclose_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        GtkViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

