/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExtendedDelete;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DriverExtendedDeleteImpl
implements ExtendedDelete {
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DriverNodeInfo;

    public boolean delete(Node[] nodeArray) throws IOException {
        JDBCDriver[] jDBCDriverArray = DriverExtendedDeleteImpl.getJDBCDrivers(nodeArray);
        if (jDBCDriverArray == null) {
            return false;
        }
        DatabaseConnection databaseConnection = DriverExtendedDeleteImpl.findFirstConnection(jDBCDriverArray);
        if (databaseConnection == null) {
            return false;
        }
        if (!DriverExtendedDeleteImpl.canDeleteDrivers(jDBCDriverArray, databaseConnection)) {
            return true;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                nodeArray[i].destroy();
                continue;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return true;
    }

    private static JDBCDriver[] getJDBCDrivers(Node[] nodeArray) {
        JDBCDriver[] jDBCDriverArray = new JDBCDriver[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            DriverNodeInfo driverNodeInfo = (DriverNodeInfo)nodeArray[i].getLookup().lookup(class$org$netbeans$modules$db$explorer$infos$DriverNodeInfo == null ? DriverExtendedDeleteImpl.class$("org.netbeans.modules.db.explorer.infos.DriverNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DriverNodeInfo);
            if (driverNodeInfo == null) {
                return null;
            }
            jDBCDriverArray[i] = driverNodeInfo.getJDBCDriver();
            if (jDBCDriverArray[i] != null) continue;
            return null;
        }
        return jDBCDriverArray;
    }

    private static DatabaseConnection findFirstConnection(JDBCDriver[] jDBCDriverArray) {
        DatabaseConnection[] databaseConnectionArray = ConnectionList.getDefault().getConnections();
        for (int i = 0; i < jDBCDriverArray.length; ++i) {
            int n;
            for (n = 0; n < databaseConnectionArray.length; ++n) {
                if (!jDBCDriverArray[i].getName().equals(databaseConnectionArray[n].getDriverName())) continue;
                return databaseConnectionArray[n];
            }
            for (n = 0; n < databaseConnectionArray.length; ++n) {
                if (!jDBCDriverArray[i].getClassName().equals(databaseConnectionArray[n].getDriver())) continue;
                return databaseConnectionArray[n];
            }
        }
        return null;
    }

    private static boolean canDeleteDrivers(JDBCDriver[] jDBCDriverArray, DatabaseConnection databaseConnection) {
        String string;
        String string2;
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        if (jDBCDriverArray.length == 1) {
            String string3 = resourceBundle.getString("MSG_ConfirmDeleteDriver");
            string2 = MessageFormat.format(string3, jDBCDriverArray[0].getDisplayName(), databaseConnection.getDatabaseConnection().getDisplayName());
            string = resourceBundle.getString("MSG_ConfirmDeleteDriverTitle");
        } else {
            String string4 = resourceBundle.getString("MSG_ConfirmDeleteDrivers");
            string2 = MessageFormat.format(string4, new Integer(jDBCDriverArray.length));
            string = resourceBundle.getString("MSG_ConfirmDeleteDriversTitle");
        }
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string2, string, 0)) == NotifyDescriptor.YES_OPTION;
    }
}

