/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.MaskDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

public class DialogDatasource
extends AbstractDialogConfirm {
    private boolean editmode;
    private SideNavigator navigator;
    private UoDatasource uoDs;
    private MaskDatasource mDs;
    private JCheckBox cbxConnect;

    public DialogDatasource(SideNavigator navigator, boolean editmode) {
        super((Component)Application.window, "datasource." + (editmode ? "edit" : "new"));
        this.editmode = editmode;
        this.navigator = navigator;
        this.mDs = new MaskDatasource();
        this.getContentPane().add(this.mDs);
        this.cbxConnect = new JCheckBox("connect");
        this.bar.add((Component)this.cbxConnect, 0);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)navigator.getSelectionPath().getLastPathComponent();
        if (editmode) {
            this.uoDs = (UoDatasource)node.getUserObject();
            this.mDs.load(this.uoDs);
        } else {
            this.uoDs = new UoDatasource((UoDriver)node.getUserObject());
            this.mDs.load(this.uoDs);
        }
        this.mDs.setEnabled(!this.uoDs.isConnected());
        this.cbxConnect.setSelected(this.uoDs.isConnected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onConfirm() {
        boolean bContinue = this.mDs.unload(this.uoDs);
        if (bContinue) {
            this.setCursor(new Cursor(3));
            try {
                if (this.cbxConnect.isSelected() && !this.uoDs.isConnected()) {
                    this.uoDs.connect();
                    Application.window.connectionOpened(this.uoDs.getKey());
                } else if (!this.cbxConnect.isSelected() && this.uoDs.isConnected()) {
                    this.uoDs.disconnect();
                    Application.window.connectionClosed(this.uoDs.getKey());
                }
                if (!this.editmode) {
                    this.navigator.add(this.uoDs);
                } else {
                    this.navigator.reloadSelection();
                }
            }
            catch (Exception e) {
                Application.println(e, true);
                bContinue = false;
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
        return bContinue;
    }

    protected void onOpen() {
    }
}

