/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractMetadataExporterParameter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JRXlsAbstractMetadataExporter
extends JRXlsAbstractExporter {
    protected boolean writeHeader;
    protected List<String> columnNames;
    protected Map<String, Integer> columnNamesMap;
    protected int rowIndex;
    boolean hasDefinedColumns;
    Map<String, Object> currentRow;
    Map<String, Object> repeatedValues;

    public JRXlsAbstractMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsAbstractMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void setParameters() {
        super.setParameters();
        this.writeHeader = this.getBooleanParameter(JRXlsAbstractMetadataExporterParameter.WRITE_HEADER, "net.sf.jasperreports.export.xls.write.header", false);
        this.setColumnNames();
        this.currentRow = new HashMap<String, Object>();
        this.repeatedValues = new HashMap<String, Object>();
    }

    protected void setColumnNames() {
        String[] columnNamesArray = this.getStringArrayParameter(JRXlsAbstractMetadataExporterParameter.COLUMN_NAMES, "net.sf.jasperreports.export.xls.column.names");
        this.columnNames = new ArrayList<String>();
        this.columnNamesMap = new HashMap<String, Integer>();
        if (columnNamesArray != null && columnNamesArray.length > 0) {
            for (int i = 0; i < columnNamesArray.length; ++i) {
                if (columnNamesArray[i] == null) {
                    this.columnNames.add(null);
                    continue;
                }
                String[] currentColumnNamesArray = columnNamesArray[i].split(",");
                for (int j = 0; j < currentColumnNamesArray.length; ++j) {
                    String columnName = currentColumnNamesArray[j].trim();
                    this.columnNamesMap.put(columnName, this.columnNames.size());
                    this.columnNames.add(columnName);
                }
            }
            this.hasDefinedColumns = true;
        }
    }

    @Override
    protected void exportReportToStream(OutputStream os) throws JRException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            List<JRPrintPage> pages;
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            this.setExporterHints();
            if (this.getParameter(JRXlsAbstractExporterParameter.SHEET_NAMES) == null || this.getParameterResolver() instanceof JRAbstractExporter.ParameterOverriddenResolver && this.sheetNames != null && this.sheetNames.length > 0) {
                this.sheetNamesIndex = 0;
            }
            if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        JRXlsAbstractExporter.SheetInfo sheetInfo = new JRXlsAbstractExporter.SheetInfo();
                        sheetInfo.sheetName = this.getSheetName(null);
                        this.createSheet(sheetInfo);
                        ++this.sheetIndex;
                        ++this.sheetNamesIndex;
                        this.rowIndex = 0;
                        this.resetAutoFilters();
                        this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                        this.exportPage(page);
                        ++this.pageIndex;
                    }
                } else {
                    JRXlsAbstractExporter.SheetInfo sheetInfo = new JRXlsAbstractExporter.SheetInfo();
                    sheetInfo.sheetName = this.getSheetName(this.jasperPrint.getName());
                    this.createSheet(sheetInfo);
                    ++this.sheetIndex;
                    ++this.sheetNamesIndex;
                    this.resetAutoFilters();
                    this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.exportPage(page);
                        ++this.pageIndex;
                    }
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page) throws JRException {
        List<JRPrintElement> elements = page.getElements();
        this.currentRow = new HashMap<String, Object>();
        this.rowIndex += this.writeHeader ? 1 : 0;
        for (int i = 0; i < elements.size(); ++i) {
            int columnFreezeIndex;
            JRPrintElement element = elements.get(i);
            String sheetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.sheet.name");
            if (sheetName != null) {
                this.setSheetName(sheetName);
            }
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element);
            } else if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element);
            } else if (element instanceof JRPrintEllipse) {
                this.exportRectangle((JRPrintEllipse)element);
            } else if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element);
            } else if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
            } else if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element);
            } else if (element instanceof JRGenericPrintElement) {
                this.exportGenericElement((JRGenericPrintElement)element);
            }
            String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
            String rowFreeze = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(element, "net.sf.jasperreports.export.xls.freeze.row.edge");
            int rowFreezeIndex = rowFreeze == null ? 0 : (EdgeEnum.BOTTOM.getName().equals(rowFreeze) ? this.rowIndex + 1 : this.rowIndex);
            String columnFreeze = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(element, "net.sf.jasperreports.export.xls.freeze.column.edge");
            int n = columnFreeze == null ? 0 : (columnFreezeIndex = EdgeEnum.RIGHT.getName().equals(columnFreeze) ? this.columnNamesMap.get(currentColumnName) + 1 : this.columnNamesMap.get(currentColumnName));
            if (rowFreezeIndex <= 0 && columnFreezeIndex <= 0) continue;
            this.setFreezePane(rowFreezeIndex, columnFreezeIndex, rowFreezeIndex > 0, columnFreezeIndex > 0);
        }
        if (this.columnNames.size() > 0) {
            this.writeCurrentRow(this.currentRow, this.repeatedValues);
        }
        if (this.autoFilterStart != null) {
            this.setAutoFilter(this.autoFilterStart + ":" + (this.autoFilterEnd != null ? this.autoFilterEnd : this.autoFilterStart));
        } else if (this.autoFilterEnd != null) {
            this.setAutoFilter(this.autoFilterEnd + ":" + this.autoFilterEnd);
        }
        this.setRowLevels(null, null);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
        return 0;
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getFullStyledText(this.noneSelector);
    }

    protected static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalAlignEnum horizontalAlignment;
        VerticalAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignmentValue();
                verticalAlignment = textElement.getVerticalAlignmentValue();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    @Override
    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return this.isImageBorderFixEnabled ? 1 : 0;
    }

    private String getSheetName(String sheetName) {
        if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
            sheetName = this.sheetNames[this.sheetNamesIndex];
        }
        if (sheetName == null) {
            return "Page " + (this.sheetIndex + 1);
        }
        int crtIndex = 1;
        String txtIndex = "";
        if (this.sheetNamesMap.containsKey(sheetName)) {
            crtIndex = (Integer)this.sheetNamesMap.get(sheetName) + 1;
            txtIndex = String.valueOf(crtIndex);
        }
        this.sheetNamesMap.put(sheetName, crtIndex);
        String name = sheetName;
        if (txtIndex.length() > 0) {
            name = name + " " + txtIndex;
        }
        if (name.length() > 31) {
            name = (sheetName + " ").substring(0, 31 - txtIndex.length()) + txtIndex;
        }
        return name;
    }

    @Override
    protected boolean isWrapText(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.wrap.text")) {
            return JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(element, "net.sf.jasperreports.export.xls.wrap.text", this.wrapText);
        }
        return this.wrapText;
    }

    @Override
    protected boolean isCellLocked(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.cell.locked")) {
            return JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(element, "net.sf.jasperreports.export.xls.cell.locked", this.cellLocked);
        }
        return this.cellLocked;
    }

    @Override
    protected String getFormula(JRPrintText text) {
        String formula = text.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.formula");
        if (formula != null && (formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        return formula;
    }

    @Override
    protected void setSheetNames() {
        String[] sheetNamesArray = this.getStringArrayParameter(JRXlsAbstractExporterParameter.SHEET_NAMES, "net.sf.jasperreports.export.xls.sheet.names.");
        if (sheetNamesArray != null) {
            ArrayList<String> sheetNamesList = new ArrayList<String>();
            for (int i = 0; i < sheetNamesArray.length; ++i) {
                if (sheetNamesArray[i] == null) {
                    sheetNamesList.add(null);
                    continue;
                }
                String[] currentSheetNamesArray = sheetNamesArray[i].split("/");
                for (int j = 0; j < currentSheetNamesArray.length; ++j) {
                    sheetNamesList.add(currentSheetNamesArray[j]);
                }
            }
            this.sheetNames = sheetNamesList.toArray(new String[sheetNamesList.size()]);
        }
    }

    @Override
    protected boolean isCellHidden(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.cell.hidden")) {
            return JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(element, "net.sf.jasperreports.export.xls.cell.hidden", this.cellHidden);
        }
        return this.cellHidden;
    }

    protected boolean isColumnReadOnTime(Map<String, Object> currentRow, String currentColumnName) {
        int indexOfLastFilledColumn = -1;
        Set<String> currentlyFilledColumns = currentRow.keySet();
        for (String column : currentlyFilledColumns) {
            indexOfLastFilledColumn = Math.max(indexOfLastFilledColumn, this.columnNames.indexOf(column));
        }
        return indexOfLastFilledColumn < this.columnNames.indexOf(currentColumnName);
    }

    @Override
    protected void exportText(JRPrintText text, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    public void exportImage(JRPrintImage image, JRExporterGridCell cell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell cell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected abstract ExporterNature getNature();

    @Override
    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.createSheet(sheetInfo);
    }

    protected abstract void createSheet(JRXlsAbstractExporter.SheetInfo var1);

    @Override
    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected void setColumnWidth(int col, int width) {
        this.setColumnWidth(col, width, false);
    }

    @Override
    protected abstract void setColumnWidth(int var1, int var2, boolean var3);

    protected void setRowHeight(int rowIndex, int lastRowHeight) throws JRException {
        this.setRowHeight(rowIndex, lastRowHeight, null, null);
    }

    @Override
    protected abstract void setRowHeight(int var1, int var2, Cut var3, XlsRowLevelInfo var4) throws JRException;

    protected abstract void exportText(JRPrintText var1) throws JRException;

    public abstract void exportImage(JRPrintImage var1) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1) throws JRException;

    protected abstract void exportLine(JRPrintLine var1) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1) throws JRException;

    protected abstract void writeCurrentRow(Map<String, Object> var1, Map<String, Object> var2) throws JRException;
}

