/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class WritableBinaryObjectInspector
extends AbstractPrimitiveWritableObjectInspector
implements SettableBinaryObjectInspector {
    WritableBinaryObjectInspector() {
        super(PrimitiveObjectInspectorUtils.binaryTypeEntry);
    }

    public BytesWritable copyObject(Object o) {
        if (null == o) {
            return null;
        }
        BytesWritable incoming = (BytesWritable)o;
        byte[] bytes = new byte[incoming.getLength()];
        System.arraycopy(incoming.getBytes(), 0, bytes, 0, incoming.getLength());
        return new BytesWritable(bytes);
    }

    @Override
    public ByteArrayRef getPrimitiveJavaObject(Object o) {
        if (null == o) {
            return null;
        }
        ByteArrayRef ba = new ByteArrayRef();
        ba.setData(((BytesWritable)o).getBytes());
        return ba;
    }

    @Override
    public BytesWritable getPrimitiveWritableObject(Object o) {
        return null == o ? null : (BytesWritable)o;
    }

    public BytesWritable set(Object o, ByteArrayRef bb) {
        BytesWritable incoming = (BytesWritable)o;
        if (bb != null) {
            incoming.set(bb.getData(), 0, bb.getData().length);
        }
        return incoming;
    }

    public BytesWritable set(Object o, BytesWritable bw) {
        BytesWritable incoming = (BytesWritable)o;
        if (bw != null) {
            incoming.set(bw);
        }
        return incoming;
    }

    public BytesWritable create(ByteArrayRef bb) {
        return new BytesWritable(bb.getData());
    }

    public BytesWritable create(BytesWritable bw) {
        BytesWritable newCpy = new BytesWritable();
        if (null != bw) {
            newCpy.set(bw);
        }
        return newCpy;
    }
}

