/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableColumnGroupNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableSectionNode;
import com.jaspersoft.ireport.components.table.undo.DeleteTableColumnUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class DeleteTableColumnAction
extends NodeAction {
    private static DeleteTableColumnAction instance = null;

    public static synchronized DeleteTableColumnAction getInstance() {
        if (instance == null) {
            instance = new DeleteTableColumnAction();
        }
        return instance;
    }

    private DeleteTableColumnAction() {
    }

    public String getName() {
        return NbBundle.getMessage(DeleteTableColumnAction.class, (String)"DeleteTableColumnAction.Name.CTL_DeleteTableColumnAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        StandardTable table = null;
        JasperDesign jd = null;
        BaseColumn column = null;
        Object node = activatedNodes[0];
        if (node instanceof TableNullCellNode) {
            column = ((TableNullCellNode)((Object)node)).getColumn();
            table = ((TableNullCellNode)((Object)node)).getTable();
            jd = (JasperDesign)((TableNullCellNode)((Object)node)).getLookup().lookup(JasperDesign.class);
        } else if (node instanceof TableCellNode) {
            column = ((TableCellNode)activatedNodes[0]).getColumn();
            table = ((TableCellNode)node).getTable();
            jd = ((TableCellNode)node).getJasperDesign();
        } else if (node instanceof TableColumnGroupNode) {
            column = ((TableColumnGroupNode)activatedNodes[0]).getColumnGroup();
            table = ((TableColumnGroupNode)node).getTable();
            jd = ((TableColumnGroupNode)node).getJasperDesign();
        } else {
            for (Node parent = activatedNodes[0].getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof TableCellNode)) continue;
                node = (TableCellNode)parent;
                column = ((TableCellNode)node).getColumn();
                table = ((TableCellNode)node).getTable();
                jd = ((TableCellNode)node).getJasperDesign();
                break;
            }
        }
        if (table == null || column == null || jd == null) {
            return;
        }
        TableMatrix matrix = TableModelUtils.createTableMatrix(table, jd);
        Object columnParent = matrix.getColumnParent(column);
        List oldColumns = TableModelUtils.getColumns(columnParent);
        int position = oldColumns.indexOf(column);
        TableModelUtils.removeColumn(columnParent, column, position);
        DeleteTableColumnUndoableEdit edit = new DeleteTableColumnUndoableEdit(table, jd, column, columnParent, position);
        while (oldColumns.size() == 0 && columnParent instanceof StandardColumnGroup) {
            Object oldParentParent = matrix.getColumnParent((BaseColumn)((StandardColumnGroup)columnParent));
            if (oldParentParent == null) continue;
            if (oldParentParent instanceof StandardTable) {
                position = ((StandardTable)oldParentParent).getColumns().indexOf((StandardColumnGroup)columnParent);
                ((StandardTable)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)columnParent));
                edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(table, jd, (BaseColumn)((StandardColumnGroup)columnParent), oldParentParent, position)));
                oldColumns = ((StandardTable)oldParentParent).getColumns();
                columnParent = oldParentParent;
                continue;
            }
            position = ((StandardColumnGroup)oldParentParent).getColumns().indexOf((StandardColumnGroup)columnParent);
            ((StandardColumnGroup)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)columnParent));
            edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(table, jd, (BaseColumn)((StandardColumnGroup)columnParent), oldParentParent, position)));
            oldColumns = ((StandardColumnGroup)oldParentParent).getColumns();
            columnParent = oldParentParent;
        }
        IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
        TableModelUtils.fixTableLayout(table, jd);
    }

    protected boolean enable(Node[] activatedNodes) {
        Node parent;
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        boolean typeOk = false;
        Object node = activatedNodes[0];
        if (node instanceof TableNullCellNode || node instanceof TableCellNode || node instanceof TableColumnGroupNode) {
            typeOk = true;
        }
        if (!typeOk) {
            for (parent = activatedNodes[0].getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof TableCellNode)) continue;
                node = (TableCellNode)parent;
                typeOk = true;
                break;
            }
        }
        if (!typeOk) {
            return false;
        }
        parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent instanceof TableSectionNode && TableModelUtils.getStandardColumnsCount(((TableSectionNode)parent).getTable().getColumns()) > 1) {
            return true;
        }
        return parent instanceof TableColumnGroupNode && TableModelUtils.getStandardColumnsCount(((TableColumnGroupNode)parent).getTable().getColumns()) > 1;
    }
}

