/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.DimensionTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.metadata.Query;
import rex.metadata.QueryElement;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;

public class EmptyResultTable
extends JPanel
implements LanguageChangedListener {
    JLabel columns;
    JLabel rows;
    JLabel measures;
    DropTarget dtCol;
    DropTarget dtRow;
    DropTarget dtMeasures;
    Query q;
    JTree dimTree;

    public EmptyResultTable(Query _q, JTree _dimTree) {
        this.q = _q;
        this.dimTree = _dimTree;
        this.columns = new DNDJLabel(I18n.getString("label.dropColumns"), 1);
        this.rows = new DNDJLabel(I18n.getString("label.dropRows"), 0);
        this.measures = new DNDJLabel(I18n.getString("label.dropMeasures"), 2);
        Dimension prefSize = new Dimension(200, 20);
        this.columns.setPreferredSize(prefSize);
        this.rows.setPreferredSize(prefSize);
        this.measures.setPreferredSize(prefSize);
        this.columns.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.rows.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.measures.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.setLayout(new GridLayout(2, 2));
        this.setOpaque(false);
        this.add(Box.createRigidArea(prefSize));
        this.add(this.columns);
        this.add(this.rows);
        this.add(this.measures);
        this.dtRow = new DropTarget(this.rows, (DropTargetListener)((Object)this.rows));
        this.dtCol = new DropTarget(this.columns, (DropTargetListener)((Object)this.columns));
        this.dtMeasures = new DropTarget(this.measures, (DropTargetListener)((Object)this.measures));
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void refreshDisplay() {
        this.columns.setText(this.q.getCaptionForColumns());
        this.rows.setText(this.q.getCaptionForRows());
        this.measures.setText(this.q.getCaptionForMeasures());
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.columns.setText(I18n.getString("label.dropColumns"));
        this.rows.setText(I18n.getString("label.dropRows"));
        this.measures.setText(I18n.getString("label.dropMeasures"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    class DNDJLabel
    extends JLabel
    implements DropTargetListener {
        int dndLabelType;

        public DNDJLabel(String s, int _dndLabelType) {
            super(s);
            this.setBackground(Color.WHITE);
            this.dndLabelType = _dndLabelType;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable tr = dtde.getTransferable();
                DataFlavor[] flavors = tr.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    if (!flavors[i].isFlavorSerializedObjectType() || !(tr.getTransferData(flavors[i]) instanceof Integer)) continue;
                    dtde.acceptDrop(1);
                    Integer row = (Integer)tr.getTransferData(flavors[i]);
                    TreePath tp = EmptyResultTable.this.dimTree.getPathForRow(row);
                    DimensionTreeElement droppedElement = (DimensionTreeElement)((TreeElement)tp.getPathComponent(tp.getPathCount() - 1)).getUserObject();
                    if (droppedElement != null) {
                        switch (this.dndLabelType) {
                            case 1: {
                                EmptyResultTable.this.q.addToColumns((QueryElement)((Object)droppedElement));
                                this.setText(EmptyResultTable.this.q.getCaptionForColumns());
                                break;
                            }
                            case 0: {
                                EmptyResultTable.this.q.addToRows((QueryElement)((Object)droppedElement));
                                this.setText(EmptyResultTable.this.q.getCaptionForRows());
                                break;
                            }
                            case 2: {
                                EmptyResultTable.this.q.addToMeasures((QueryElement)((Object)droppedElement));
                                this.setText(EmptyResultTable.this.q.getCaptionForMeasures());
                            }
                        }
                        ((DimensionTreeModel)EmptyResultTable.this.dimTree.getModel()).disableTreeElements((QueryElement)((Object)droppedElement));
                        EmptyResultTable.this.dimTree.repaint();
                    }
                    dtde.dropComplete(true);
                    return;
                }
                System.out.println("Drop failed: " + dtde);
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
            catch (Exception e) {
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
        }
    }

    public static interface DndLabelType {
        public static final int DND_LABEL_TYPE_ROW = 0;
        public static final int DND_LABEL_TYPE_COLUMN = 1;
        public static final int DND_LABEL_TYPE_MEASURE = 2;
    }
}

