/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;

class ASTFeatures {
    private static final ASTFeatures DEFAULT = new ASTFeatures();
    private static Map<String, ASTFeatures> mimeTypeToASTFeatures = new HashMap<String, ASTFeatures>();
    boolean removeEmpty = false;
    boolean removeSimple = false;
    boolean removeEmptyN = true;
    boolean removeSimpleN = true;
    Set<String> empty = new HashSet<String>();
    Set<String> simple = new HashSet<String>();

    ASTFeatures() {
    }

    static ASTFeatures get(Language language) {
        if (language == null) {
            return DEFAULT;
        }
        String string = language.getMimeType();
        ASTFeatures aSTFeatures = mimeTypeToASTFeatures.get(string);
        if (aSTFeatures == null) {
            aSTFeatures = new ASTFeatures();
            mimeTypeToASTFeatures.put(string, aSTFeatures);
            Feature feature = language.getFeatureList().getFeature("AST");
            if (feature != null) {
                StringTokenizer stringTokenizer;
                String string2 = (String)feature.getValue("removeEmpty");
                if (string2 != null) {
                    if (string2.startsWith("!")) {
                        aSTFeatures.removeEmptyN = false;
                        string2 = string2.substring(1);
                    }
                    aSTFeatures.removeEmpty = "true".equals(string2);
                    if (!"false".equals(string2)) {
                        stringTokenizer = new StringTokenizer(string2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            aSTFeatures.empty.add(stringTokenizer.nextToken());
                        }
                    }
                }
                if ((string2 = (String)feature.getValue("removeSimple")) != null) {
                    if (string2.startsWith("!")) {
                        aSTFeatures.removeSimpleN = false;
                        string2 = string2.substring(1);
                    }
                    aSTFeatures.removeSimple = "true".equals(string2);
                    if (!"false".equals(string2)) {
                        stringTokenizer = new StringTokenizer(string2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            aSTFeatures.simple.add(stringTokenizer.nextToken());
                        }
                    }
                }
            }
        }
        return aSTFeatures;
    }
}

