/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jrx.json;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.jrx.json.JsonDataSourceEditor;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JsonDataSource;

public class JsonDataSourceConnection
extends IReportConnection {
    private String name;
    private String filename;
    private String selectExpression;
    private boolean useConnection = false;
    private Locale locale = null;
    private String datePattern = null;
    private String numberPattern = null;
    private TimeZone timeZone = null;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return !this.isUseConnection();
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Filename", Misc.nvl((Object)this.getFilename(), (String)""));
        map.put("SelectExpression", Misc.nvl((Object)this.getSelectExpression(), (String)""));
        map.put("UseConnection", Misc.nvl((Object)("" + this.isUseConnection()), (String)"false"));
        if (this.getLocale() != null) {
            map.put("Locale_language", Misc.nvl((Object)this.getLocale().getLanguage(), (String)""));
            map.put("Locale_country", Misc.nvl((Object)this.getLocale().getCountry(), (String)""));
            map.put("Locale_variant", Misc.nvl((Object)this.getLocale().getVariant(), (String)""));
        }
        map.put("DatePattern", Misc.nvl((Object)this.getDatePattern(), (String)""));
        map.put("NumberPattern", Misc.nvl((Object)this.getNumberPattern(), (String)""));
        if (this.getTimeZone() != null) {
            map.put("timeZone", Misc.nvl((Object)this.getTimeZone().getID(), (String)""));
        }
        return map;
    }

    public void loadProperties(HashMap map) {
        String timezoneId;
        String numberPatternValue;
        String datePatternValue;
        this.setFilename((String)map.get("Filename"));
        this.setSelectExpression((String)map.get("SelectExpression"));
        this.setUseConnection(Boolean.valueOf(Misc.nvl(map.get("UseConnection"), (String)"false")));
        String language = (String)map.get("Locale_language");
        String country = (String)map.get("Locale_country");
        String variant = (String)map.get("Locale_variant");
        if (language != null && language.trim().length() > 0) {
            if (country != null && country.trim().length() > 0) {
                if (variant != null && variant.trim().length() > 0) {
                    this.setLocale(new Locale(language, country, variant));
                } else {
                    this.setLocale(new Locale(language, country));
                }
            } else {
                this.setLocale(new Locale(language));
            }
        }
        if ((datePatternValue = (String)map.get("DatePattern")) != null && datePatternValue.trim().length() > 0) {
            this.setDatePattern(datePatternValue);
        }
        if ((numberPatternValue = (String)map.get("NumberPattern")) != null && numberPatternValue.trim().length() > 0) {
            this.setNumberPattern(numberPatternValue);
        }
        if ((timezoneId = (String)map.get("timeZone")) != null && timezoneId.trim().length() > 0) {
            this.setTimeZone(TimeZone.getTimeZone(timezoneId));
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JRDataSource getJRDataSource() {
        try {
            JsonDataSource ds = new JsonDataSource(this.filename, this.getSelectExpression());
            if (this.getLocale() != null) {
                ds.setLocale(this.getLocale());
            }
            if (this.getTimeZone() != null) {
                ds.setTimeZone(this.getTimeZone());
            }
            if (this.getDatePattern() != null && this.getDatePattern().trim().length() > 0) {
                ds.setDatePattern(this.getDatePattern());
            }
            if (this.getNumberPattern() != null && this.getNumberPattern().trim().length() > 0) {
                ds.setNumberPattern(this.getNumberPattern());
            }
            return ds;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public void setSelectExpression(String selectExpression) {
        this.selectExpression = selectExpression;
    }

    public boolean isUseConnection() {
        return this.useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }

    public Map getSpecialParameters(Map map) throws JRException {
        if (this.isUseConnection()) {
            map.put("net.sf.jasperreports.json.source", this.getFilename());
            if (this.getLocale() != null) {
                map.put("JSON_LOCALE", this.getLocale());
            }
            if (this.getTimeZone() != null) {
                map.put("JSON_TIME_ZONE", this.getTimeZone());
            }
            if (this.getDatePattern() != null && this.getDatePattern().trim().length() > 0) {
                map.put("net.sf.jasperreports.json.date.pattern", this.getDatePattern());
            }
            if (this.getNumberPattern() != null && this.getNumberPattern().trim().length() > 0) {
                map.put("net.sf.jasperreports.json.number.pattern", this.getNumberPattern());
            }
        }
        return map;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getDescription() {
        return "JSON datasource";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JsonDataSourceEditor();
    }

    public void test() throws Exception {
        try {
            File f = new File(this.getFilename());
            if (!f.exists()) {
                throw new Exception("File not found");
            }
            JOptionPane.showMessageDialog(Misc.getMainFrame(), I18n.getString((String)"messages.connectionDialog.connectionTestSuccessful"), "", 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), ex.getMessage(), "Error", 0);
            throw ex;
        }
    }
}

