/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.EnumProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class ImageEvaluationTimeProperty
extends EnumProperty {
    private final JRDesignDataset dataset;
    private final JRDesignImage element;

    public ImageEvaluationTimeProperty(JRDesignImage element, JRDesignDataset dataset) {
        super(EvaluationTimeEnum.class, element);
        this.element = element;
        this.dataset = dataset;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public String getName() {
        return "evaluationTime";
    }

    public String getDisplayName() {
        return I18n.getString("Global.Property.EvaluationTime");
    }

    public String getShortDescription() {
        return I18n.getString("Global.Property.EvaluationTimedetail");
    }

    public Object getDefaultValue() {
        return EvaluationTimeEnum.NOW;
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public List getTagList() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(EvaluationTimeEnum.NOW, I18n.getString("Global.Property.Now")));
        tags.add(new Tag(EvaluationTimeEnum.REPORT, I18n.getString("Global.Property.Report")));
        tags.add(new Tag(EvaluationTimeEnum.PAGE, I18n.getString("Global.Property.Page")));
        tags.add(new Tag(EvaluationTimeEnum.COLUMN, I18n.getString("Global.Property.Column")));
        tags.add(new Tag(EvaluationTimeEnum.GROUP, I18n.getString("Global.Property.Group")));
        tags.add(new Tag(EvaluationTimeEnum.BAND, I18n.getString("Global.Property.Band")));
        tags.add(new Tag(EvaluationTimeEnum.AUTO, I18n.getString("Global.Property.Auto")));
        return tags;
    }

    public void setPropertyValue(Object val) {
        this.element.setEvaluationTime((EvaluationTimeEnum)val);
        if (val == EvaluationTimeEnum.GROUP) {
            JRGroup newGroupValue = (JRGroup)this.dataset.getGroupsList().get(0);
            JRGroup oldGroupValue = this.element.getEvaluationGroup();
            if ((newGroupValue == null || oldGroupValue == null) && newGroupValue != oldGroupValue || oldGroupValue != null && newGroupValue != null && !oldGroupValue.getName().equals(newGroupValue.getName())) {
                ObjectPropertyUndoableEdit urobGroup = new ObjectPropertyUndoableEdit(this.element, "EvaluationGroupName", String.class, oldGroupValue, newGroupValue);
                this.element.setEvaluationGroup(newGroupValue);
                IReportManager.getInstance().addUndoableEdit(urobGroup, true);
            }
        }
    }

    public Object getPropertyValue() {
        return this.element.getEvaluationTimeValue();
    }

    public Object getOwnPropertyValue() {
        return this.getPropertyValue();
    }

    public void validate(Object value) {
        if (value == EvaluationTimeEnum.GROUP && this.dataset.getGroupsList().isEmpty()) {
            IllegalArgumentException iae = this.annotateException(I18n.getString("Global.Property.NogroupsTextFielddetail"));
            throw iae;
        }
    }
}

