/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.errorhandler;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ModelChangeListener;
import com.jaspersoft.ireport.designer.errorhandler.ErrorHandlerTopComponent;
import com.jaspersoft.ireport.designer.errorhandler.ProblemItem;
import java.util.Collection;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DesignVerifyerThread
implements Runnable,
ModelChangeListener {
    private boolean reportChanged = true;
    private Thread thisThread = null;
    private boolean stop = false;
    private JrxmlVisualView jrxmlVisualView = null;

    public DesignVerifyerThread(JrxmlVisualView view) {
        this.jrxmlVisualView = view;
        view.addModelChangeListener(this);
        this.thisThread = new Thread(this);
    }

    public void start() {
        this.thisThread.start();
    }

    public void stop() {
        this.setStop(true);
    }

    public void run() {
        while (!this.isStop()) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isReportChanged()) continue;
            this.setReportChanged(false);
            this.verifyDesign();
        }
    }

    public boolean isReportChanged() {
        return this.reportChanged;
    }

    public void setReportChanged(boolean reportChanged) {
        this.reportChanged = reportChanged;
    }

    public void modelChanged(JrxmlVisualView view) {
        if (this.getJrxmlVisualView() == view) {
            this.setReportChanged(true);
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void verifyDesign() {
        for (int i = 0; i < this.getJrxmlVisualView().getReportProblems().size(); ++i) {
            ProblemItem pii = this.getJrxmlVisualView().getReportProblems().get(i);
            if (pii.getProblemType() != 1 && pii.getProblemType() != 0) continue;
            this.getJrxmlVisualView().getReportProblems().remove(i);
            --i;
        }
        try {
            Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
            if (this.getJrxmlVisualView().getModel() != null && this.getJrxmlVisualView().getModel().getJasperDesign() != null) {
                JasperDesign design = this.getJrxmlVisualView().getModel().getJasperDesign();
                Collection ls = JasperCompileManager.verifyDesign((JasperDesign)design);
                for (JRValidationFault fault : ls) {
                    String s = fault.getMessage();
                    this.getJrxmlVisualView().getReportProblems().add(new ProblemItem(1, fault));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.getJrxmlVisualView().getReportProblems().add(new ProblemItem(1, ex.getMessage(), null, null));
        }
        Runnable runner = new Runnable(){

            public void run() {
                ErrorHandlerTopComponent.getDefault().refreshErrors();
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public JrxmlVisualView getJrxmlVisualView() {
        return this.jrxmlVisualView;
    }

    public void setJrxmlVisualView(JrxmlVisualView jrxmlVisualView) {
        this.jrxmlVisualView = jrxmlVisualView;
    }
}

