/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.CustomHTTPAuthenticator;
import com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXBusyLabel;
import rex.graphics.datasourcetree.elements.CatalogElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;

public class XMLADataSourceConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private DataSourceTreeElement[] cachedDataSources = null;
    private JButton jButtonGetXMLAMetadata;
    private JCheckBox jCheckBoxSavePassword1;
    private JComboBox jComboBoxXMLACatalog;
    private JComboBox jComboBoxXMLACube;
    private JComboBox jComboBoxXMLADatasource;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabelAttention;
    private JLabel jLabelBusy;
    private JLabel jLabelXMLACatalog;
    private JLabel jLabelXMLACube;
    private JLabel jLabelXMLADatasource;
    private JLabel jLabelXMLAUrl;
    private JPanel jPanel1;
    private JPanel jPanel16;
    private JPanel jPanelXMLA;
    private JSeparator jSeparator10;
    private JSeparator jSeparator8;
    private JPasswordField jTextFieldPassword1;
    private JTextField jTextFieldUsername1;
    private JTextField jTextFieldXMLAUrl;

    public XMLADataSourceConnectionEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanelXMLA = new JPanel();
        this.jLabelXMLAUrl = new JLabel();
        this.jTextFieldXMLAUrl = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabelBusy = new JXBusyLabel();
        this.jButtonGetXMLAMetadata = new JButton();
        this.jLabelXMLADatasource = new JLabel();
        this.jComboBoxXMLADatasource = new JComboBox();
        this.jLabelXMLACatalog = new JLabel();
        this.jComboBoxXMLACatalog = new JComboBox();
        this.jSeparator8 = new JSeparator();
        this.jLabelXMLACube = new JLabel();
        this.jComboBoxXMLACube = new JComboBox();
        this.jSeparator10 = new JSeparator();
        this.jPanel16 = new JPanel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jTextFieldUsername1 = new JTextField();
        this.jTextFieldPassword1 = new JPasswordField();
        this.jCheckBoxSavePassword1 = new JCheckBox();
        this.jLabelAttention = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelXMLA.setLayout(new GridBagLayout());
        this.jLabelXMLAUrl.setText("Url of XML/A server");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLAUrl, gridBagConstraints);
        this.jTextFieldXMLAUrl.setText("http://localhost:8080/mondrian/xmla");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jTextFieldXMLAUrl, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelBusy.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelBusy, gridBagConstraints);
        this.jButtonGetXMLAMetadata.setText("Get metadata");
        this.jButtonGetXMLAMetadata.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLADataSourceConnectionEditor.this.jButtonGetXMLAMetadataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonGetXMLAMetadata, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanelXMLA.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelXMLADatasource.setText("Datasource");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLADatasource, gridBagConstraints);
        this.jComboBoxXMLADatasource.setMinimumSize(new Dimension(23, 22));
        this.jComboBoxXMLADatasource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLADataSourceConnectionEditor.this.jComboBoxXMLADatasourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jComboBoxXMLADatasource, gridBagConstraints);
        this.jLabelXMLACatalog.setText("Catalog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLACatalog, gridBagConstraints);
        this.jComboBoxXMLACatalog.setMinimumSize(new Dimension(23, 22));
        this.jComboBoxXMLACatalog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLADataSourceConnectionEditor.this.jComboBoxXMLACatalogActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jComboBoxXMLACatalog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jSeparator8, gridBagConstraints);
        this.jLabelXMLACube.setText("Cube");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelXMLA.add((Component)this.jLabelXMLACube, gridBagConstraints);
        this.jComboBoxXMLACube.setMinimumSize(new Dimension(23, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jComboBoxXMLACube, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelXMLA.add((Component)this.jSeparator10, gridBagConstraints);
        this.jPanel16.setLayout(new GridBagLayout());
        this.jLabel26.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jLabel27, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jTextFieldUsername1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel16.add((Component)this.jTextFieldPassword1, gridBagConstraints);
        this.jCheckBoxSavePassword1.setText("Save password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanel16.add((Component)this.jCheckBoxSavePassword1, gridBagConstraints);
        this.jLabelAttention.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/connection/gui/warning.png")));
        this.jLabelAttention.setText("<html>ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it.");
        this.jLabelAttention.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel16.add((Component)this.jLabelAttention, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelXMLA.add((Component)this.jPanel16, gridBagConstraints);
        this.add((Component)this.jPanelXMLA, "North");
    }

    private void jComboBoxXMLACatalogActionPerformed(ActionEvent evt) {
        if (this.init || this.cachedDataSources == null) {
            return;
        }
        this.jComboBoxXMLACube.removeAllItems();
        if (this.jComboBoxXMLACatalog.getSelectedItem() == null) {
            return;
        }
        if (this.jComboBoxXMLACatalog.getSelectedItem() instanceof String) {
            return;
        }
        CatalogElement catalog = (CatalogElement)this.jComboBoxXMLACatalog.getSelectedItem();
        if (catalog.getChildren() != null) {
            for (DataSourceTreeElement cube : catalog.getChildren()) {
                this.jComboBoxXMLACube.addItem(cube);
            }
        }
    }

    private void jComboBoxXMLADatasourceActionPerformed(ActionEvent evt) {
        if (this.init || this.cachedDataSources == null) {
            return;
        }
        int dsIndex = this.jComboBoxXMLADatasource.getSelectedIndex();
        this.init = true;
        this.jComboBoxXMLACatalog.removeAllItems();
        this.jComboBoxXMLACube.removeAllItems();
        if (dsIndex >= 0 && this.cachedDataSources != null && dsIndex < this.cachedDataSources.length) {
            DataSourceTreeElement[] catalogs = this.cachedDataSources[dsIndex].getChildren();
            this.init = true;
            for (DataSourceTreeElement catalog : catalogs) {
                this.jComboBoxXMLACatalog.addItem(catalog);
            }
        } else {
            this.jComboBoxXMLACatalog.removeAllItems();
            this.jComboBoxXMLACube.removeAllItems();
        }
        this.init = false;
        if (this.jComboBoxXMLACatalog.getItemCount() > 0) {
            this.jComboBoxXMLACatalog.setSelectedIndex(0);
        }
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JRXMLADataSourceConnection) {
            JRXMLADataSourceConnection con = (JRXMLADataSourceConnection)this.iReportConnection;
            this.jTextFieldXMLAUrl.setText(con.getUrl());
            this.jComboBoxXMLADatasource.removeAllItems();
            this.jComboBoxXMLADatasource.addItem(con.getDatasource());
            this.jComboBoxXMLACatalog.removeAllItems();
            this.jComboBoxXMLACatalog.addItem(con.getCatalog());
            this.jComboBoxXMLACube.removeAllItems();
            this.jComboBoxXMLACube.addItem(con.getCube());
            this.jTextFieldUsername1.setText(con.getUsername());
            if (con.isSavePassword()) {
                this.jTextFieldPassword1.setText(con.getPassword());
            } else {
                this.jTextFieldPassword1.setText("");
            }
            this.jCheckBoxSavePassword1.setSelected(con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        JRXMLADataSourceConnection irConn = new JRXMLADataSourceConnection();
        if (this.jTextFieldXMLAUrl.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Label.Url"), I18n.getString("XMLADataSourceConnectionEditor.Label.InvalidProperty"), 2);
            return null;
        }
        irConn.setUrl(this.jTextFieldXMLAUrl.getText().trim());
        if (this.jComboBoxXMLADatasource.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Label.Datasource"), I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"), 2);
            return null;
        }
        irConn.setDatasource(((String)this.jComboBoxXMLADatasource.getSelectedItem()).trim());
        if (this.jComboBoxXMLACatalog.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.Catalog"), I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"), 2);
            return null;
        }
        irConn.setCatalog(("" + this.jComboBoxXMLACatalog.getSelectedItem()).trim());
        if (this.jComboBoxXMLACube.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.Cube"), I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"), 2);
            return null;
        }
        irConn.setCube(("" + this.jComboBoxXMLACube.getSelectedItem()).trim());
        irConn.setUsername(this.jTextFieldUsername1.getText().trim());
        if (this.jCheckBoxSavePassword1.isSelected()) {
            irConn.setPassword(new String(this.jTextFieldPassword1.getPassword()));
        } else {
            irConn.setPassword("");
        }
        irConn.setSavePassword(this.jCheckBoxSavePassword1.isSelected());
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    private void jButtonGetXMLAMetadataActionPerformed(ActionEvent evt) {
        final String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        Authenticator.setDefault(new CustomHTTPAuthenticator(this.jTextFieldUsername1.getText(), new String(this.jTextFieldPassword1.getPassword())));
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServerMetadata smd;
                block5: {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                XMLADataSourceConnectionEditor.this.getBusyLabel().setBusy(true);
                                XMLADataSourceConnectionEditor.this.jButtonGetXMLAMetadata.setEnabled(false);
                            }
                        });
                        smd = new ServerMetadata(urlstr, (Component)XMLADataSourceConnectionEditor.this);
                        if (smd.isValidUrl()) break block5;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(XMLADataSourceConnectionEditor.this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"), "", 1);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                XMLADataSourceConnectionEditor.this.getBusyLabel().setBusy(false);
                                XMLADataSourceConnectionEditor.this.jButtonGetXMLAMetadata.setEnabled(true);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    XMLADataSourceConnectionEditor.access$402(XMLADataSourceConnectionEditor.this, smd.discoverDataSources());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            XMLADataSourceConnectionEditor.this.refreshDataSources();
                        }
                    });
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(XMLADataSourceConnectionEditor.this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"), "", 1);
                        }
                    });
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        t.start();
    }

    public void refreshDataSources() {
        this.init = true;
        this.jComboBoxXMLADatasource.removeAllItems();
        this.jComboBoxXMLACatalog.removeAllItems();
        this.jComboBoxXMLACube.removeAllItems();
        if (this.cachedDataSources == null || this.cachedDataSources.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("XMLADataSourceConnectionEditor.Message.NoDatasources"), "", 1);
            return;
        }
        for (int i = 0; i < this.cachedDataSources.length; ++i) {
            this.jComboBoxXMLADatasource.addItem(this.cachedDataSources[i].getDataSourceInfo());
        }
        this.init = false;
        if (this.jComboBoxXMLADatasource.getItemCount() > 0) {
            this.jComboBoxXMLADatasource.setSelectedIndex(0);
        }
    }

    public JXBusyLabel getBusyLabel() {
        return (JXBusyLabel)this.jLabelBusy;
    }

    static /* synthetic */ DataSourceTreeElement[] access$402(XMLADataSourceConnectionEditor x0, DataSourceTreeElement[] x1) {
        x0.cachedDataSources = x1;
        return x1;
    }
}

