/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JDBCNBConnection;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;

public class JDBCNBConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private JComboBox jComboBoxJDBCDriver;
    private JLabel jLabel2;
    private JPanel jPanelJDBC;

    public JDBCNBConnectionEditor() {
        this.initComponents();
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        Vector<Tag> items = new Vector<Tag>();
        for (int i = 0; i < connections.length; ++i) {
            Tag tag = new Tag(connections[i].getName(), connections[i].getDisplayName());
            items.add(tag);
        }
        this.jComboBoxJDBCDriver.setModel(new DefaultComboBoxModel(items));
        if (items.size() > 0) {
            this.jComboBoxJDBCDriver.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jPanelJDBC = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxJDBCDriver = new JComboBox();
        this.setLayout(new BorderLayout());
        this.jPanelJDBC.setLayout(new GridBagLayout());
        this.jLabel2.setText(I18n.getString("JDBCNBConnectionEditor.Label.Connection"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBoxJDBCDriver.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jComboBoxJDBCDriver, gridBagConstraints);
        this.add((Component)this.jPanelJDBC, "Center");
    }

    public void setIReportConnection(IReportConnection c) {
        if (c instanceof JDBCNBConnection) {
            Misc.setComboboxSelectedTagValue(this.jComboBoxJDBCDriver, ((JDBCNBConnection)c).getUrl());
        }
    }

    public IReportConnection getIReportConnection() {
        if (this.jComboBoxJDBCDriver.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("JDBCNBConnectionEditor.Message.SelectConn"), I18n.getString("JDBCNBConnectionEditor.Message.InvalidConn"), 2);
            return null;
        }
        if (this.jComboBoxJDBCDriver.getSelectedItem() != null && this.jComboBoxJDBCDriver.getSelectedItem() instanceof Tag) {
            JDBCNBConnection c = new JDBCNBConnection();
            c.setUrl(((Tag)this.jComboBoxJDBCDriver.getSelectedItem()).getValue() + "");
            return c;
        }
        return null;
    }
}

