/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.wizards;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.QualityLabel;
import com.jaspersoft.ireport.jasperserver.ui.ResourceChooser;
import com.jaspersoft.ireport.jasperserver.ui.resources.DataSourceDialog;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardDescriptor;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardPanel3;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openide.awt.Mnemonics;

public final class ReportUnitVisualPanel3
extends JPanel {
    ReportUnitWizardPanel3 wizardPanel = null;
    private ResourceDescriptor dataSourceDescriptor = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonEditLocalDataSource;
    private JButton jButtonPickResource;
    private JComboBox jComboBoxDatasources;
    private JLabel jLabelResourceFile1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonLocal;
    private JRadioButton jRadioButtonNoDataSource;
    private JRadioButton jRadioButtonRepo;

    public ReportUnitVisualPanel3(ReportUnitWizardPanel3 wizardPanel) {
        this.initComponents();
        this.wizardPanel = wizardPanel;
        if (!JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            this.jPanel2.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(8, 4, 30, 4);
            QualityLabel jlabel = new QualityLabel();
            jlabel.setText("<html><b>" + JasperServerManager.getString("reportUnitDialog.useDefaultDatasource", "This server uses a default data source to run the reports and execute queries") + "</b></html>");
            this.jPanel2.add((Component)jlabel, gridBagConstraints);
        }
        this.jComboBoxDatasources.removeAllItems();
        List datasources = wizardPanel.getWizardDescriptor().getDatasources();
        for (int i = 0; i < datasources.size(); ++i) {
            Object datasource = datasources.get(i);
            if (datasource instanceof String) {
                this.jComboBoxDatasources.addItem(datasource);
                continue;
            }
            if (!(datasource instanceof ResourceDescriptor)) continue;
            this.jComboBoxDatasources.addItem(((ResourceDescriptor)datasource).getUriString());
        }
        if (this.jComboBoxDatasources.getItemCount() > 0) {
            this.jComboBoxDatasources.setSelectedIndex(0);
        }
    }

    public JServer getServer() {
        return this.wizardPanel.getWizardDescriptor().getServer();
    }

    public String getParentFolder() {
        return this.wizardPanel.getWizardDescriptor().getParentFolder();
    }

    public String getName() {
        return JasperServerManager.getString("newReportUnitWizard.step.datasource", "Locate Data Source");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jLabelResourceFile1 = new JLabel();
        this.jRadioButtonRepo = new JRadioButton();
        this.jComboBoxDatasources = new JComboBox();
        this.jButtonPickResource = new JButton();
        this.jRadioButtonLocal = new JRadioButton();
        this.jButtonEditLocalDataSource = new JButton();
        this.jRadioButtonNoDataSource = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelResourceFile1, (String)"Locate the Data Source");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 20, 4);
        this.jPanel2.add((Component)this.jLabelResourceFile1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonRepo);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonRepo, (String)"From the repository");
        this.jRadioButtonRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel3.this.jRadioButtonRepo1jRadioButtonRepoActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel2.add((Component)this.jRadioButtonRepo, gridBagConstraints);
        this.jComboBoxDatasources.setEditable(true);
        this.jComboBoxDatasources.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 4, 2);
        this.jPanel2.add((Component)this.jComboBoxDatasources, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonPickResource, (String)"Browse");
        this.jButtonPickResource.setEnabled(false);
        this.jButtonPickResource.setMinimumSize(new Dimension(73, 21));
        this.jButtonPickResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel3.this.jButtonPickResourcejButtonPickJrxmljButton1ActionPerformed121(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.jPanel2.add((Component)this.jButtonPickResource, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonLocal);
        this.jRadioButtonLocal.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonLocal, (String)"Locally Defined");
        this.jRadioButtonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel3.this.jRadioButtonLocal1jRadioButtonLocalActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel2.add((Component)this.jRadioButtonLocal, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEditLocalDataSource, (String)"Edit local datasource");
        this.jButtonEditLocalDataSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel3.this.jButtonEditLocalDataSourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel2.add((Component)this.jButtonEditLocalDataSource, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonNoDataSource);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonNoDataSource, (String)"Don't use any data source");
        this.jRadioButtonNoDataSource.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonNoDataSource.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonNoDataSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel3.this.jRadioButtonNoDataSourcejRadioButtonLocalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 4, 4);
        this.jPanel2.add((Component)this.jRadioButtonNoDataSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jRadioButtonRepo1jRadioButtonRepoActionPerformed11(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonPickResourcejButtonPickJrxmljButton1ActionPerformed121(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (!RepositoryFolder.isDataSource(rd)) {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getString("newReportUnitWizard.selectDatasource", "Please choose a DataSource resource"), "", 2);
                return;
            }
            if (rd == null || rd.getUriString() == null) {
                this.jComboBoxDatasources.setSelectedItem("");
            } else {
                this.jComboBoxDatasources.setSelectedItem(rd.getUriString());
            }
            if (this.wizardPanel != null) {
                this.wizardPanel.fireChangeEvent();
            }
        }
    }

    private void jRadioButtonLocal1jRadioButtonLocalActionPerformed11(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonEditLocalDataSourceActionPerformed(ActionEvent evt) {
        DataSourceDialog dtd = new DataSourceDialog(Misc.getMainFrame(), true);
        dtd.setServer(this.getServer());
        dtd.setParentFolder(this.getParentFolder() + "/<dataSource>");
        dtd.setDoNotStore(true);
        if (this.getDataSourceDescriptor() != null) {
            dtd.setResource(this.getDataSourceDescriptor());
        }
        dtd.setVisible(true);
        if (dtd.getDialogResult() == 0) {
            this.setDataSourceDescriptor(dtd.getNewResourceDescriptor());
        }
        if (this.wizardPanel != null) {
            this.wizardPanel.fireChangeEvent();
        }
    }

    private void jRadioButtonNoDataSourcejRadioButtonLocalActionPerformed1(ActionEvent evt) {
        this.updateResourceFromType();
    }

    void storeSettings(ReportUnitWizardDescriptor wizardDescriptor) {
        if (!JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            return;
        }
        wizardDescriptor.putProperty("datasource_present", !this.jRadioButtonNoDataSource.isSelected() + "");
        wizardDescriptor.putProperty("datasource_is_local", this.jRadioButtonLocal.isSelected() + "");
        if (this.jRadioButtonLocal.isSelected()) {
            wizardDescriptor.putProperty("datasource_descriptor", this.dataSourceDescriptor);
        } else {
            wizardDescriptor.putProperty("datasource_uri", this.jComboBoxDatasources.getSelectedItem());
        }
    }

    public void validateForm() throws Exception {
        if (!JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            return;
        }
        if (this.jRadioButtonRepo.isSelected() && (this.jComboBoxDatasources.getSelectedItem() == null || this.jComboBoxDatasources.getSelectedItem().toString().trim().length() == 0)) {
            throw new Exception("No datasource selected.");
        }
        if (this.jRadioButtonLocal.isSelected() && this.dataSourceDescriptor == null) {
            throw new Exception(JasperServerManager.getString("newReportUnitWizard.message.datasourceNotDefined", "The local datasource is not correctly defined.\nPress the button \"Edit local datasource\" to fix the problem."));
        }
    }

    public void updateResourceFromType() {
        this.jComboBoxDatasources.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonPickResource.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonEditLocalDataSource.setEnabled(this.jRadioButtonLocal.isSelected());
        if (this.wizardPanel != null) {
            this.wizardPanel.fireChangeEvent();
        }
    }

    public ResourceDescriptor getDataSourceDescriptor() {
        return this.dataSourceDescriptor;
    }

    public void setDataSourceDescriptor(ResourceDescriptor dataSourceDescriptor) {
        this.dataSourceDescriptor = dataSourceDescriptor;
    }
}

