/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.ResourceChooser;
import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualDatasourceItemDialog
extends JDialog {
    private ResourceDescriptor resourceDescriptor = null;
    private JServer server = null;
    private Pattern subDsIdInvalidChars = Pattern.compile("\\W");
    private String oldName = "";
    private Map<String, ResourceDescriptor> existingResourceDescriptors = null;
    private int dialogResult = 2;
    private JButton jButtonBrowse;
    private JButton jButtonClose;
    private JButton jButtonSave;
    private JLabel jLabelName;
    private JLabel jLabelUri;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUri;

    public VirtualDatasourceItemDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                VirtualDatasourceItemDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString((String)"Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString((String)"Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void setResourceDescriptor(ResourceDescriptor rd) {
        this.resourceDescriptor = rd;
        this.oldName = rd.getResourcePropertyValue("PROP_DATASOURCE_SUB_DS_ID");
        this.jTextFieldName.setText(rd.getResourcePropertyValue("PROP_DATASOURCE_SUB_DS_ID"));
        this.jTextFieldUri.setText(rd.getResourcePropertyValue("PROP_REFERENCE_URI"));
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelUri = new JLabel();
        this.jTextFieldUri = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(500, 200));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelName.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jLabelName.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jTextFieldName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabelUri.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jLabelUri.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabelUri, gridBagConstraints);
        this.jTextFieldUri.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jTextFieldUri.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jTextFieldUri, gridBagConstraints);
        this.jButtonBrowse.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jButtonBrowse.text"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualDatasourceItemDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.jButtonBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(500, 30));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jButtonSave.text"));
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualDatasourceItemDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText(NbBundle.getMessage(VirtualDatasourceItemDialog.class, (String)"VirtualDatasourceItemDialog.jButtonClose.text"));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualDatasourceItemDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            if (this.jTextFieldName.getText().length() == 0) {
                this.jTextFieldName.requestFocus();
                throw new IllegalArgumentException("Please specify a valid ID for this datasource item");
            }
            if (this.subDsIdInvalidChars.matcher(this.jTextFieldName.getText()).find()) {
                this.jTextFieldName.requestFocus();
                throw new IllegalArgumentException("Only letters, digits and underscore allowed in ID");
            }
            if (!this.jTextFieldName.getText().equals(this.oldName) && this.existingResourceDescriptors.containsKey(this.jTextFieldName.getText())) {
                this.jTextFieldName.requestFocus();
                throw new IllegalArgumentException("This name is already used by another datasource item,\nplease specify a different one.");
            }
            if (this.jTextFieldUri.getText().length() == 0) {
                this.jTextFieldUri.requestFocus();
                throw new IllegalArgumentException("Please specify a valid URI");
            }
            if (this.resourceDescriptor == null) {
                this.resourceDescriptor = new ResourceDescriptor();
                this.resourceDescriptor.setName("");
                this.resourceDescriptor.setLabel("");
                this.resourceDescriptor.setWsType("datasource");
                this.resourceDescriptor.setUriString("");
            }
            this.resourceDescriptor.setResourceProperty("PROP_DATASOURCE_SUB_DS_ID", this.jTextFieldName.getText());
            this.resourceDescriptor.setResourceProperty("PROP_REFERENCE_URI", this.jTextFieldUri.getText());
            this.setDialogResult(0);
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (!rd.getWsType().equals("jdbc") && !rd.getWsType().equals("jndi")) {
                JOptionPane.showMessageDialog(this, "Please select a datasource of type JDBC or JNDI");
                return;
            }
            if (rd == null || rd.getUriString() == null) {
                this.jTextFieldUri.setText("");
            } else {
                this.jTextFieldUri.setText(rd.getUriString());
                String baseName = rd.getLabel();
                baseName = baseName.replace(" ", "_");
                String newName = baseName = JRStringUtil.getJavaIdentifier((String)baseName);
                int k = 0;
                while (!this.oldName.equals(newName) && this.existingResourceDescriptors.containsKey(newName)) {
                    newName = baseName + "_" + ++k;
                }
                this.jTextFieldName.setText(newName);
            }
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Map<String, ResourceDescriptor> getExistingResourceDescriptors() {
        return this.existingResourceDescriptors;
    }

    public void setExistingResourceDescriptors(Map<String, ResourceDescriptor> existingResourceDescriptors) {
        this.existingResourceDescriptors = existingResourceDescriptors;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }
}

