/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.refactoring.api.AccessorImpl;
import org.netbeans.modules.refactoring.api.Context;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.ProgressSupport;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.ProgressProvider;
import org.netbeans.modules.refactoring.spi.ReadOnlyFilesHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.netbeans.modules.refactoring.spi.impl.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.InstanceContent;

public abstract class AbstractRefactoring {
    public static final int INIT = 0;
    public static final int PRE_CHECK = 1;
    public static final int PARAMETERS_CHECK = 2;
    public static final int PREPARE = 3;
    private int currentState = 0;
    private static final int PLUGIN_STEPS = 30;
    private ArrayList plugins;
    ArrayList pluginsWithProgress;
    private ArrayList gbHandlers;
    private ProgressL progressListener = new ProgressL();
    private ProgressSupport progressSupport;
    Lookup refactoringSource;
    private Context scope;
    private volatile boolean cancel;

    protected AbstractRefactoring(Lookup lookup) {
        this.refactoringSource = lookup;
    }

    private Collection getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(RefactoringPluginFactory.class));
            for (RefactoringPluginFactory refactoringPluginFactory : result.allInstances()) {
                RefactoringPlugin refactoringPlugin = refactoringPluginFactory.createInstance(this);
                if (refactoringPlugin == null) continue;
                RefactoringPlugin refactoringPlugin2 = this.getContext().lookup(RefactoringPlugin.class);
                AbstractRefactoring abstractRefactoring = this.getContext().lookup(AbstractRefactoring.class);
                if (abstractRefactoring != null && !refactoringPluginFactory.getClass().getClassLoader().equals(refactoringPlugin2.getClass().getClassLoader()) && refactoringPluginFactory.createInstance(abstractRefactoring) != null) continue;
                this.plugins.add(refactoringPlugin);
            }
        }
        return this.plugins;
    }

    Collection getGBHandlers() {
        if (this.gbHandlers == null) {
            this.gbHandlers = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(GuardedBlockHandlerFactory.class));
            Iterator iterator = result.allInstances().iterator();
            while (iterator.hasNext()) {
                GuardedBlockHandler guardedBlockHandler = ((GuardedBlockHandlerFactory)iterator.next()).createInstance(this);
                if (guardedBlockHandler == null) continue;
                this.gbHandlers.add(guardedBlockHandler);
            }
        }
        return this.gbHandlers;
    }

    public final Problem preCheck() {
        this.currentState = 1;
        return this.pluginsPreCheck(null);
    }

    public final Problem prepare(RefactoringSession refactoringSession) {
        long l = System.currentTimeMillis();
        Problem problem = null;
        boolean bl = false;
        if (this.currentState < 2) {
            problem = this.checkParameters();
            bl = true;
        }
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        problem = this.pluginsPrepare(bl ? problem : null, refactoringSession);
        Logger logger = Logger.getLogger("TIMER.RefactoringPrepare");
        if (logger.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis() - l;
            logger.log(Level.FINE, "refactoring.prepare", new Object[]{this, l});
        }
        return problem;
    }

    public final Problem checkParameters() {
        Problem problem = this.fastCheckParameters();
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        this.currentState = 2;
        return this.pluginsCheckParams(problem);
    }

    public final Problem fastCheckParameters() {
        Problem problem = null;
        if (this.currentState < 1) {
            problem = this.preCheck();
        }
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        return this.pluginsFastCheckParams(problem);
    }

    public final synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(progressListener);
        if (this.pluginsWithProgress == null) {
            this.pluginsWithProgress = new ArrayList();
            for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
                if (!(refactoringPlugin instanceof ProgressProvider)) continue;
                ((ProgressProvider)((Object)refactoringPlugin)).addProgressListener(this.progressListener);
                this.pluginsWithProgress.add(refactoringPlugin);
            }
        }
    }

    public final synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(progressListener);
        }
        if (this.pluginsWithProgress != null) {
            for (ProgressProvider progressProvider : this.pluginsWithProgress) {
                progressProvider.removeProgressListener(this.progressListener);
            }
            this.pluginsWithProgress.clear();
            this.pluginsWithProgress = null;
        }
    }

    public final Context getContext() {
        if (this.scope == null) {
            this.scope = new Context(new InstanceContent());
        }
        return this.scope;
    }

    public final Lookup getRefactoringSource() {
        return this.refactoringSource;
    }

    public final void cancelRequest() {
        this.cancel = true;
        for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
            refactoringPlugin.cancelRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem pluginsPreCheck(Problem problem) {
        try {
            Object object;
            this.progressListener.start();
            Iterator iterator = this.getPlugins().iterator();
            while (iterator.hasNext()) {
                if (this.cancel) {
                    object = null;
                    return object;
                }
                object = (RefactoringPlugin)iterator.next();
                try {
                    problem = AbstractRefactoring.chainProblems(object.preCheck(), problem);
                }
                catch (Throwable throwable) {
                    problem = this.createProblemAndLog(problem, throwable, object.getClass());
                }
                if (problem == null || !problem.isFatal()) continue;
                Problem problem2 = problem;
                return problem2;
            }
            object = problem;
            return object;
        }
        finally {
            this.progressListener.stop();
        }
    }

    private String getModuleName(Class clazz) {
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!moduleInfo.owns(clazz)) continue;
            return moduleInfo.getDisplayName();
        }
        return "Unknown";
    }

    private String createMessage(Class clazz, Throwable throwable) {
        return NbBundle.getMessage(RefactoringPanel.class, (String)"ERR_ExceptionInModule", (Object)this.getModuleName(clazz), (Object)throwable.toString());
    }

    private Problem createProblemAndLog(Problem problem, Throwable throwable, Class clazz) {
        Problem problem2;
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null && (throwable2.getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException") || throwable2.getCause() != null && throwable2.getCause().getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException"))) {
            problem2 = new Problem(true, NbBundle.getMessage(Util.class, (String)"ERR_OutOfMemory"));
            Logger.global.log(Level.INFO, "There is not enough memory to complete this task.", throwable);
        } else {
            problem2 = new Problem(false, this.createMessage(clazz, throwable));
            Exceptions.printStackTrace((Throwable)throwable);
        }
        return AbstractRefactoring.chainProblems(problem2, problem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem pluginsPrepare(Problem problem, RefactoringSession refactoringSession) {
        try {
            this.progressListener.start();
            Problem problem2 = this.pluginsPrepare2(problem, refactoringSession);
            return problem2;
        }
        finally {
            this.progressListener.stop();
        }
    }

    private Problem pluginsPrepare2(Problem problem, RefactoringSession refactoringSession) {
        Object object;
        RefactoringElementsBag refactoringElementsBag = refactoringSession.getElementsBag();
        Iterator iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            if (this.cancel) {
                return null;
            }
            object = (RefactoringPlugin)iterator.next();
            try {
                problem = AbstractRefactoring.chainProblems(object.prepare(refactoringElementsBag), problem);
            }
            catch (Throwable throwable) {
                problem = this.createProblemAndLog(problem, throwable, object.getClass());
            }
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        if (!(this instanceof WhereUsedQuery) && (object = this.getROHandler()) != null) {
            Collection collection = SPIAccessor.DEFAULT.getReadOnlyFiles(refactoringElementsBag);
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (FileObject fileObject : collection) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    for (FileObject fileObject2 : dataObject.files()) {
                        if (SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fileObject2)) != 1) continue;
                        hashSet.add(fileObject2);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    hashSet.add(fileObject);
                }
            }
            problem = AbstractRefactoring.chainProblems(object.createProblem(refactoringSession, hashSet), problem);
        }
        return problem;
    }

    private ReadOnlyFilesHandler getROHandler() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ReadOnlyFilesHandler.class));
        List list = (List)result.allInstances();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of ReadOnlyFilesHandler found in Lookup; only using first one: " + list);
        }
        return (ReadOnlyFilesHandler)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem pluginsCheckParams(Problem problem) {
        try {
            Object object;
            this.progressListener.start();
            Iterator iterator = this.getPlugins().iterator();
            while (iterator.hasNext()) {
                if (this.cancel) {
                    object = null;
                    return object;
                }
                object = (RefactoringPlugin)iterator.next();
                try {
                    problem = AbstractRefactoring.chainProblems(object.checkParameters(), problem);
                }
                catch (Throwable throwable) {
                    problem = this.createProblemAndLog(problem, throwable, object.getClass());
                }
                if (problem == null || !problem.isFatal()) continue;
                Problem problem2 = problem;
                return problem2;
            }
            object = problem;
            return object;
        }
        finally {
            this.progressListener.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem pluginsFastCheckParams(Problem problem) {
        try {
            Object object;
            this.progressListener.start();
            Iterator iterator = this.getPlugins().iterator();
            while (iterator.hasNext()) {
                if (this.cancel) {
                    object = null;
                    return object;
                }
                object = (RefactoringPlugin)iterator.next();
                try {
                    problem = AbstractRefactoring.chainProblems(object.fastCheckParameters(), problem);
                }
                catch (Throwable throwable) {
                    problem = this.createProblemAndLog(problem, throwable, object.getClass());
                }
                if (problem == null || !problem.isFatal()) continue;
                Problem problem2 = problem;
                return problem2;
            }
            object = problem;
            return object;
        }
        finally {
            this.progressListener.stop();
        }
    }

    static Problem chainProblems(Problem problem, Problem problem2) {
        if (problem == null) {
            return problem2;
        }
        if (problem2 == null) {
            return problem;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    static {
        APIAccessor.DEFAULT = new AccessorImpl();
    }

    private class ProgressL
    implements ProgressListener {
        private float progressStep;
        private float current;
        private boolean startCalledByPlugin = false;

        private ProgressL() {
        }

        public void start(ProgressEvent progressEvent) {
            this.progressStep = 30.0f / (float)progressEvent.getCount();
            this.startCalledByPlugin |= true;
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) == 0) {
                this.current = 0.0f;
                if (progressEvent.getCount() == -1) {
                    this.fireProgressListenerStart(progressEvent.getOperationType(), -1);
                } else {
                    this.fireProgressListenerStart(progressEvent.getOperationType(), 30 * AbstractRefactoring.this.pluginsWithProgress.size());
                }
            } else {
                this.current = AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) * 30;
                this.fireProgressListenerStep((int)this.current);
            }
        }

        public void step(ProgressEvent progressEvent) {
            this.current += this.progressStep;
            this.fireProgressListenerStep((int)this.current);
        }

        public void stop(ProgressEvent progressEvent) {
        }

        void start() {
            this.startCalledByPlugin = false;
        }

        void stop() {
            if (this.startCalledByPlugin) {
                this.fireProgressListenerStop();
            }
        }

        private void fireProgressListenerStart(int n, int n2) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStart(this, n, n2);
            }
        }

        private void fireProgressListenerStep() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this);
            }
        }

        private void fireProgressListenerStep(int n) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this, n);
            }
        }

        private void fireProgressListenerStop() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStop(this);
            }
        }
    }
}

