/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.hadoop.hive.connection;

import com.jaspersoft.hadoop.hive.connection.HiveConnectionManager;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.hadoop.hive.Installer;
import com.jaspersoft.ireport.hadoop.hive.connection.HiveConnectionEditor;
import com.jaspersoft.ireport.hadoop.hive.designer.HiveFieldsProvider;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.openide.util.NbBundle;

public class HiveConnection
extends JDBCConnection
implements WizardFieldsProvider {
    private static final String URL = "HiveURL";
    private String url;
    private com.jaspersoft.hadoop.hive.connection.HiveConnection currentConnection;

    public HiveConnection() {
        this.setName(NbBundle.getMessage(HiveConnection.class, (String)"connectionName"));
    }

    public String getDescription() {
        return NbBundle.getMessage(HiveConnection.class, (String)"connectionType");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new HiveConnectionEditor();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public Connection getConnection() {
        try {
            return this.createConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private com.jaspersoft.hadoop.hive.connection.HiveConnection createConnection() throws Exception {
        HiveConnectionManager connectionManager = Installer.getConnectionManager();
        if (this.currentConnection != null) {
            connectionManager.returnConnection(this.currentConnection);
        }
        connectionManager.setJdbcURL(this.url);
        return connectionManager.borrowConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        com.jaspersoft.hadoop.hive.connection.HiveConnection connection = null;
        String errorMessage = "";
        try {
            connection = this.createConnection();
            if (connection != null) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), connection.test(), "", 1);
                return;
            }
            errorMessage = "A connection could not be created. Please review the IDE log";
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMessage = String.valueOf(e);
        }
        finally {
            if (connection != null) {
                Installer.getConnectionManager().returnConnection(connection);
            }
        }
        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error: " + String.valueOf(errorMessage), "", 0);
    }

    public String designQuery(String query) {
        return query;
    }

    public String getQueryLanguage() {
        return "HiveQL";
    }

    public boolean supportsDesign() {
        return false;
    }

    public boolean isJDBCConnection() {
        return true;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public void loadProperties(HashMap map) {
        this.setUrl((String)map.get(URL));
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(URL, this.getUrl());
        return map;
    }

    public List<JRDesignField> readFields(String query) throws Exception {
        HiveFieldsProvider provider = new HiveFieldsProvider();
        ArrayList<JRDesignField> result = new ArrayList<JRDesignField>();
        JRDesignDataset dataset = new JRDesignDataset(true);
        JRDesignQuery designQuery = new JRDesignQuery();
        designQuery.setLanguage("HiveQL");
        designQuery.setText(query);
        dataset.setQuery(designQuery);
        JRField[] fields = provider.getFields((IReportConnection)this, (JRDataset)dataset, new HashMap());
        for (int i = 0; i < fields.length; ++i) {
            result.add((JRDesignField)fields[i]);
        }
        return result;
    }
}

