/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import org.openide.nodes.PropertySupport;
import org.openide.util.WeakListeners;

public final class EvaluationGroupProperty
extends PropertySupport
implements PropertyChangeListener {
    private final JRDesignDataset dataset;
    private final JRDesignImage element;
    private ComboBoxPropertyEditor editor;

    public EvaluationGroupProperty(JRDesignImage element, JRDesignDataset dataset) {
        super("evaluationGroup", JRGroup.class, "Evaluation group", "Evaluate the image expression when the specified group changes", true, true);
        this.element = element;
        this.dataset = dataset;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
        dataset.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataset.getEventSupport()));
    }

    public boolean canWrite() {
        return this.element.getEvaluationTimeValue() == EvaluationTimeEnum.GROUP;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(false, this.getListOfTags());
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getEvaluationGroup() == null ? "" : this.element.getEvaluationGroup();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val instanceof JRGroup) {
            JRGroup oldValue = this.element.getEvaluationGroup();
            JRGroup newValue = (JRGroup)val;
            this.element.setEvaluationGroup(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "EvaluationGroup", JRGroup.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.editor == null) {
            return;
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("name")) {
            this.editor.setTagValues(this.getListOfTags());
        }
    }

    private ArrayList getListOfTags() {
        ArrayList<Tag> l = new ArrayList<Tag>();
        List groups = this.dataset.getGroupsList();
        for (int i = 0; i < groups.size(); ++i) {
            JRDesignGroup group = (JRDesignGroup)groups.get(i);
            l.add(new Tag(group, group.getName()));
            group.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group.getEventSupport()));
        }
        return l;
    }
}

