/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.menu.preview;

import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public abstract class AbstractPreviewAction
extends CallableSystemAction
implements PreferenceChangeListener,
ItemListener {
    private JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.getName());
    private boolean updating = false;

    public abstract String getPreviewType();

    public AbstractPreviewAction() {
        IReportManager.getPreferences().addPreferenceChangeListener(this);
        this.preferenceChange(null);
        this.item.addItemListener(this);
    }

    public void performAction() {
    }

    public JMenuItem getMenuPresenter() {
        return this.item;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        String fmt = IReportManager.getPreferences().get("output_format", "");
        if (this.getPreviewType().equals(fmt) != this.item.isSelected()) {
            this.setUpdating(true);
            this.item.setSelected(!this.item.isSelected());
            this.setUpdating(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.isUpdating()) {
            return;
        }
        if (e.getStateChange() == 2) {
            IReportManager.getPreferences().remove("output_format");
        } else if (this.getPreviewType().length() > 0) {
            IReportManager.getPreferences().put("output_format", this.getPreviewType());
        } else {
            IReportManager.getPreferences().remove("output_format");
        }
        this.performAction();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }
}

