/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.InputValidationException;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.BasicInputControlUI;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.DateInputControlUI;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.DateTimeInputControlUI;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.InputControlUI;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import net.sf.jasperreports.types.date.InvalidDateRangeExpressionException;

public class BasicInputControl {
    public static Map valueHistories = new HashMap();
    protected ResourceDescriptor inputControl = null;
    private ResourceDescriptor dataType = null;
    private InputControlUI inputControlUI;
    private Object defaultValue = null;

    public void addActionListener(ActionListener listener) {
        this.getInputControlUI().addActionListener(listener);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.getInputControlUI().setValue(defaultValue);
    }

    public BasicInputControl() {
        this.setInputControlUI(new BasicInputControlUI());
    }

    public JComponent getUI() {
        return (JComponent)((Object)this.getInputControlUI());
    }

    public Object getValue() throws InputValidationException {
        return this.validate();
    }

    public ResourceDescriptor getInputControl() {
        return this.inputControl;
    }

    public void setInputControl(ResourceDescriptor inputControl, List values) {
        this.setInputControl(inputControl, (ResourceDescriptor)null);
    }

    public void setInputControl(ResourceDescriptor inputControl) {
        this.setInputControl(inputControl, (ResourceDescriptor)null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setInputControl(ResourceDescriptor inputControl, ResourceDescriptor dataType) {
        block7: {
            block8: {
                block6: {
                    this.inputControl = inputControl;
                    this.dataType = dataType;
                    if (dataType == null) ** GOTO lbl-1000
                    if (dataType.getDataType() == 3) {
                        this.setInputControlUI(new DateInputControlUI());
                    } else if (dataType != null && dataType.getDataType() == 4) {
                        this.setInputControlUI(new DateTimeInputControlUI());
                    }
                    label = inputControl.getLabel() + (inputControl.isMandatory() != false ? "*" : "");
                    this.getInputControlUI().setLabel(label);
                    this.getInputControlUI().setReadOnly(inputControl.isReadOnly());
                    history = this.getHistory(inputControl.getUriString());
                    revisedHistory /* !! */  = new ArrayList<E>();
                    if (dataType == null) break block6;
                    if (dataType.getDataType() == 3) break block7;
                }
                if (dataType == null) break block8;
                if (dataType.getDataType() == 4) break block7;
            }
            revisedHistory /* !! */  = history;
        }
        this.getInputControlUI().setHistory(revisedHistory /* !! */ );
    }

    public void addHistoryValue(String controlUri, Object value) {
        if (controlUri == null) {
            return;
        }
        List list = this.getHistory(controlUri);
        if (list.contains(value)) {
            list.remove(value);
        }
        list.add(0, value);
    }

    public List getHistory(String controlUri) {
        if (controlUri == null) {
            return null;
        }
        ArrayList list = null;
        if (valueHistories.get(controlUri) == null) {
            list = new ArrayList();
            valueHistories.put(controlUri, list);
            return list;
        }
        return (List)valueHistories.get(controlUri);
    }

    public InputControlUI getInputControlUI() {
        return this.inputControlUI;
    }

    public void setInputControlUI(InputControlUI inputControlUI) {
        this.inputControlUI = inputControlUI;
    }

    public Object validate() throws InputValidationException {
        Object val = this.getInputControlUI().getValue();
        if (this.getInputControl().getControlType() == 2 && this.getDataType() != null) {
            if (val == null) {
                return null;
            }
            String strVal = "" + val;
            switch (this.getDataType().getDataType()) {
                case 1: {
                    if (this.getDataType().getPattern() != null && this.getDataType().getPattern().trim().length() > 0 && !Pattern.matches(this.getDataType().getPattern(), strVal)) {
                        throw new InputValidationException(JasperServerManager.getFormattedString("basicInputControl.patternError", "{0} does not match the pattern ({1})", new Object[]{this.getInputControl().getLabel(), this.getDataType().getPattern()}));
                    }
                    val = strVal;
                    break;
                }
                case 2: {
                    try {
                        if (strVal.trim().length() == 0) {
                            return null;
                        }
                        val = new BigDecimal(strVal);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new InputValidationException(JasperServerManager.getFormattedString("basicInputControl.invalidNumber", "Invalid number set for {0}", new Object[]{this.getInputControl().getLabel()}));
                    }
                }
                case 4: {
                    if (!(val instanceof String)) break;
                    if (strVal.trim().length() == 0) {
                        return null;
                    }
                    SimpleDateFormat format = new SimpleDateFormat(IReportManager.getInstance().getProperty("timeformat", "d/M/y H:m:s"));
                    ParseException pe = null;
                    try {
                        val = format.parse(strVal);
                    }
                    catch (ParseException e) {
                        pe = e;
                    }
                    if (pe == null) break;
                    boolean validDate = false;
                    if (IReportManager.getPreferences().getBoolean("jasperserver.useRelativeDateExpressions", true)) {
                        DateRangeBuilder drb = new DateRangeBuilder(strVal);
                        try {
                            drb.set(Timestamp.class).toDateRange();
                            validDate = true;
                        }
                        catch (InvalidDateRangeExpressionException ex) {
                            // empty catch block
                        }
                    }
                    if (validDate) break;
                    throw new InputValidationException(JasperServerManager.getFormattedString("basicInputControl.invalidDatetime", "Invalid value set for {0} is not a valid datetime in the form {1} or a date range expression.", new Object[]{this.getInputControl().getLabel(), IReportManager.getInstance().getProperty("timeformat", "d/M/y H:m:s")}));
                }
                case 3: {
                    if (!(val instanceof String)) break;
                    if (strVal.trim().length() == 0) {
                        return null;
                    }
                    SimpleDateFormat format = new SimpleDateFormat(IReportManager.getInstance().getProperty("dateformat", "d/M/y"));
                    ParseException pe = null;
                    try {
                        val = format.parse(strVal);
                    }
                    catch (ParseException e) {
                        pe = e;
                    }
                    if (pe == null) break;
                    boolean validDate = false;
                    if (IReportManager.getPreferences().getBoolean("jasperserver.useRelativeDateExpressions", true)) {
                        DateRangeBuilder drb = new DateRangeBuilder(strVal);
                        try {
                            drb.toDateRange();
                            validDate = true;
                        }
                        catch (InvalidDateRangeExpressionException ex) {
                            // empty catch block
                        }
                    }
                    if (validDate) break;
                    throw new InputValidationException(JasperServerManager.getFormattedString("basicInputControl.invalidDate", "Invalid value set for {0} is not a valid date in the form {1} or a valid date range expression.", new Object[]{this.getInputControl().getLabel(), IReportManager.getInstance().getProperty("dateformat", "d/M/y")}));
                }
            }
        }
        return val;
    }

    public ResourceDescriptor getDataType() {
        return this.dataType;
    }

    public void setDataType(ResourceDescriptor dataType) {
        this.dataType = dataType;
    }
}

