/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class MapElementImageProvider {
    public static JRPrintImage getImage(JRGenericPrintElement element) throws JRException {
        return MapElementImageProvider.getImage(DefaultJasperReportsContext.getInstance(), element);
    }

    public static JRPrintImage getImage(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws JRException {
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapPrintElement.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapPrintElement.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapPrintElement.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        String mapScale = (String)element.getParameterValue("mapScale");
        String mapFormat = (String)element.getParameterValue("imageType");
        String language = (String)element.getParameterValue("language");
        String markers = "";
        List markerList = (List)element.getParameterValue("markers");
        if (markerList != null && !markerList.isEmpty()) {
            for (Map map : markerList) {
                markers = markers.length() == 0 ? markers + "&markers=" : markers + "%7C";
                markers = markers + map.get("latitude");
                markers = markers + ",";
                markers = markers + map.get("longitude");
            }
        }
        String imageLocation = "http://maps.google.com/maps/api/staticmap?center=" + latitude + "," + longitude + "&size=" + element.getWidth() + "x" + element.getHeight() + "&zoom=" + zoom + (mapType == null ? "" : "&maptype=" + mapType) + (mapFormat == null ? "" : "&format=" + mapFormat) + (mapScale == null ? "" : "&scale=" + mapScale) + markers + "&sensor=false" + (language == null ? "" : "&language=" + language);
        JRBasePrintImage printImage = new JRBasePrintImage(element.getDefaultStyleProvider());
        printImage.setUUID(element.getUUID());
        printImage.setX(element.getX());
        printImage.setY(element.getY());
        printImage.setWidth(element.getWidth());
        printImage.setHeight(element.getHeight());
        printImage.setStyle(element.getStyle());
        printImage.setMode(element.getModeValue());
        printImage.setBackcolor(element.getBackcolor());
        printImage.setForecolor(element.getForecolor());
        printImage.setLazy(false);
        printImage.setScaleImage(ScaleImageEnum.CLIP);
        printImage.setHorizontalAlignment(HorizontalAlignEnum.LEFT);
        printImage.setVerticalAlignment(VerticalAlignEnum.TOP);
        Renderable cacheRenderer = (Renderable)element.getParameterValue("cacheRenderer");
        if (cacheRenderer == null) {
            cacheRenderer = RenderableUtil.getInstance(jasperReportsContext).getRenderable(imageLocation, OnErrorTypeEnum.ERROR, false);
            cacheRenderer.getImageData(jasperReportsContext);
            element.setParameterValue("cacheRenderer", cacheRenderer);
        }
        printImage.setRenderable(cacheRenderer);
        return printImage;
    }
}

