/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.datatype.CustomDatatype;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.AttributeRef;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.impl.SchemaGeneratorUtil;
import org.netbeans.modules.xml.axi.impl.SchemaUpdate;
import org.netbeans.modules.xml.axi.visitor.AXINonCyclicVisitor;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexContentDefinition;
import org.netbeans.modules.xml.schema.model.ComplexContentRestriction;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.ComplexTypeDefinition;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.Extension;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalAttributeContainer;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.NameableSchemaComponent;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleContentDefinition;
import org.netbeans.modules.xml.schema.model.SimpleContentRestriction;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultSchemaGenerator
extends SchemaGenerator {
    protected AXIModel am;
    protected SchemaModel sm;
    protected SchemaGenerator.UniqueId id;
    protected SchemaGenerator.PrimitiveCart pc;
    List<AXIComponent> path = new ArrayList<AXIComponent>();
    protected SchemaComponent sc;
    protected SchemaComponent scParent;
    protected SchemaComponent datatypeParent;
    protected SortedMap<Integer, List<Object>> fixNamesMap = null;
    protected List<SchemaComponent> createGlobals = null;
    protected HashMap<SchemaComponent, SchemaComponent> refMap = null;
    protected HashMap<Class, HashMap<String, SchemaComponent>> namesMap = null;
    protected List<Element> elementReuseList = null;
    protected SchemaGeneratorHelper sgh;
    private int fgeCount = 0;
    public static final int commitRange = Integer.getInteger("schematools.axi.adp", 0);

    public DefaultSchemaGenerator(SchemaGenerator.Mode mode) {
        super(mode);
        this.id = this.createUniqueId();
        this.pc = this.createPrimitiveCart();
        this.fixNamesMap = new TreeMap<Integer, List<Object>>();
        this.createGlobals = new ArrayList<SchemaComponent>();
        this.refMap = new HashMap();
        this.namesMap = new HashMap();
        this.elementReuseList = new ArrayList<Element>();
    }

    @Override
    public void updateSchema(SchemaModel schemaModel) throws IOException {
        assert (this.getMode() == SchemaGenerator.Mode.UPDATE);
        this.sgh = new UpdateHelper();
        this.sgh.execute(schemaModel);
    }

    @Override
    public void transformSchema(SchemaModel schemaModel) throws IOException {
        assert (this.getMode() == SchemaGenerator.Mode.TRANSFORM);
        this.sgh = new TransformHelper();
        this.sgh.execute(schemaModel);
    }

    @Override
    public void visit(Element element) {
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM && element instanceof ElementRef) {
            this.prepareElementRef((ElementRef)element);
        } else {
            this.prepareLocalElement(element);
        }
    }

    @Override
    public void visit(Attribute attribute) {
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM && attribute instanceof AttributeRef) {
            this.prepareAttributeRef((AttributeRef)attribute);
        } else {
            this.prepareLocalAttribute(attribute);
        }
    }

    public void visit(AXIType aXIType) {
        if (aXIType instanceof Datatype) {
            ((Datatype)aXIType).accept(this);
        }
    }

    @Override
    public void visit(Datatype datatype) {
        SchemaGeneratorUtil.createInlineSimpleType(datatype, this.sm, this.datatypeParent, this.pc);
    }

    @Override
    public void visit(ContentModel contentModel) {
        if (this.scParent instanceof Schema) {
            GlobalComplexType globalComplexType = SchemaGeneratorUtil.createGlobalComplexType(this.sm);
            assert (globalComplexType != null);
            globalComplexType.setName(contentModel.getName());
            SchemaGeneratorUtil.populateContentModel((SchemaComponent)globalComplexType, contentModel);
            if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                contentModel.setPeer((SchemaComponent)globalComplexType);
                int n = contentModel.getIndex(false);
                SchemaGeneratorUtil.addChildComponent(this.sm, (SchemaComponent)this.sm.getSchema(), (SchemaComponent)globalComplexType, n);
            } else {
                this.scParent = globalComplexType;
            }
            this.scParent = globalComplexType;
            for (AXIComponent aXIComponent : contentModel.getChildren()) {
                aXIComponent.accept(this);
            }
        }
    }

    @Override
    public void visit(Compositor compositor) {
        int n = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            n = compositor.getIndex(false);
        }
        switch (compositor.getType()) {
            case SEQUENCE: {
                Sequence sequence = null;
                if (this.scParent instanceof ComplexType) {
                    if (this.scParent instanceof LocalComplexType) {
                        LocalComplexType localComplexType = (LocalComplexType)this.scParent;
                        if (localComplexType.getDefinition() != null) {
                            ComplexTypeDefinition complexTypeDefinition = localComplexType.getDefinition();
                            if (complexTypeDefinition instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, complexTypeDefinition);
                                sequence = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)localComplexType);
                            } else {
                                sequence = SchemaGeneratorUtil.createSequence(this.sm, complexTypeDefinition, n);
                            }
                        } else {
                            sequence = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)((LocalComplexType)this.scParent));
                        }
                    } else if (this.scParent instanceof GlobalComplexType) {
                        GlobalComplexType globalComplexType = (GlobalComplexType)this.scParent;
                        if (globalComplexType.getDefinition() != null) {
                            ComplexTypeDefinition complexTypeDefinition = globalComplexType.getDefinition();
                            if (complexTypeDefinition instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, complexTypeDefinition);
                                sequence = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)globalComplexType);
                            } else {
                                sequence = SchemaGeneratorUtil.createSequence(this.sm, complexTypeDefinition, n);
                            }
                        } else {
                            sequence = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)((GlobalComplexType)this.scParent));
                        }
                    }
                } else if (this.scParent instanceof ComplexContentDefinition) {
                    ComplexContentDefinition complexContentDefinition = (ComplexContentDefinition)this.scParent;
                    sequence = complexContentDefinition instanceof ComplexContentRestriction && ((ComplexContentRestriction)complexContentDefinition).getDefinition() != null ? SchemaGeneratorUtil.createSequence(this.sm, ((ComplexContentRestriction)complexContentDefinition).getDefinition(), n) : SchemaGeneratorUtil.createSequence(this.sm, (ComplexContentDefinition)this.scParent);
                } else if (this.scParent instanceof Sequence) {
                    sequence = SchemaGeneratorUtil.createSequence(this.sm, (ComplexTypeDefinition)((Sequence)this.scParent), n);
                } else if (this.scParent instanceof Choice) {
                    sequence = SchemaGeneratorUtil.createSequence(this.sm, (ComplexTypeDefinition)((Choice)this.scParent), n);
                }
                SchemaGeneratorUtil.populateCompositor(sequence, compositor);
                if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                    compositor.setPeer((SchemaComponent)sequence);
                    break;
                }
                this.scParent = sequence;
                break;
            }
            case CHOICE: {
                Choice choice = null;
                if (this.scParent instanceof ComplexType) {
                    ComplexTypeDefinition complexTypeDefinition;
                    LocalComplexType localComplexType;
                    if (this.scParent instanceof LocalComplexType) {
                        localComplexType = (LocalComplexType)this.scParent;
                        if (localComplexType.getDefinition() != null) {
                            complexTypeDefinition = localComplexType.getDefinition();
                            if (complexTypeDefinition instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, complexTypeDefinition);
                                choice = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)localComplexType);
                            } else {
                                choice = SchemaGeneratorUtil.createChoice(this.sm, complexTypeDefinition, n);
                            }
                        } else {
                            choice = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)((LocalComplexType)this.scParent));
                        }
                    }
                    if (this.scParent instanceof GlobalComplexType) {
                        localComplexType = (GlobalComplexType)this.scParent;
                        if (localComplexType.getDefinition() != null) {
                            complexTypeDefinition = localComplexType.getDefinition();
                            if (complexTypeDefinition instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, complexTypeDefinition);
                                choice = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)localComplexType);
                            } else {
                                choice = SchemaGeneratorUtil.createChoice(this.sm, complexTypeDefinition, n);
                            }
                        } else {
                            choice = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)((GlobalComplexType)this.scParent));
                        }
                    }
                } else if (this.scParent instanceof ComplexContentDefinition) {
                    ComplexContentDefinition complexContentDefinition = (ComplexContentDefinition)this.scParent;
                    choice = complexContentDefinition instanceof ComplexContentRestriction && ((ComplexContentRestriction)complexContentDefinition).getDefinition() != null ? SchemaGeneratorUtil.createChoice(this.sm, ((ComplexContentRestriction)complexContentDefinition).getDefinition(), n) : SchemaGeneratorUtil.createChoice(this.sm, (ComplexContentDefinition)this.scParent);
                } else if (this.scParent instanceof Choice) {
                    choice = SchemaGeneratorUtil.createChoice(this.sm, (ComplexTypeDefinition)((Choice)this.scParent), n);
                } else if (this.scParent instanceof Sequence) {
                    choice = SchemaGeneratorUtil.createChoice(this.sm, (ComplexTypeDefinition)((Sequence)this.scParent), n);
                }
                SchemaGeneratorUtil.populateCompositor(choice, compositor);
                if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                    compositor.setPeer((SchemaComponent)choice);
                    break;
                }
                this.scParent = choice;
                break;
            }
            case ALL: {
                All all = null;
                if (this.scParent instanceof ComplexType) {
                    all = SchemaGeneratorUtil.createAll(this.sm, (ComplexType)this.scParent);
                } else if (this.scParent instanceof ComplexContentDefinition) {
                    ComplexContentDefinition complexContentDefinition = (ComplexContentDefinition)this.scParent;
                    all = complexContentDefinition instanceof ComplexContentRestriction && ((ComplexContentRestriction)complexContentDefinition).getDefinition() != null ? (All)((ComplexContentRestriction)complexContentDefinition).getDefinition() : SchemaGeneratorUtil.createAll(this.sm, (ComplexContentDefinition)this.scParent);
                }
                SchemaGeneratorUtil.populateCompositor((ComplexTypeDefinition)all, compositor);
                if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                    compositor.setPeer((SchemaComponent)all);
                    break;
                }
                this.scParent = all;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private ComplexType transformToComplexContent(Compositor compositor, ComplexTypeDefinition complexTypeDefinition) {
        AXIComponent aXIComponent = (AXIComponent)compositor.getParent();
        ComplexType complexType = null;
        if (complexTypeDefinition instanceof SimpleContent) {
            NamedComponentReference namedComponentReference;
            complexType = (ComplexType)complexTypeDefinition.getParent();
            if (complexTypeDefinition.getChildren().get(0) instanceof SimpleExtension && (namedComponentReference = ((SimpleExtension)complexTypeDefinition.getChildren().get(0)).getBase()).get() instanceof GlobalSimpleType) {
                SimpleContent simpleContent = (SimpleContent)complexTypeDefinition;
                this.copyAttribute(aXIComponent, (LocalAttributeContainer)complexType, (SchemaComponent)simpleContent);
                this.copyAttribute(aXIComponent, (LocalAttributeContainer)complexType, (SchemaComponent)simpleContent.getLocalDefinition());
            }
        }
        return complexType;
    }

    private void copyAttribute(AXIComponent aXIComponent, LocalAttributeContainer localAttributeContainer, SchemaComponent schemaComponent) {
        for (SchemaComponent schemaComponent2 : schemaComponent.getChildren()) {
            if (!(schemaComponent2 instanceof org.netbeans.modules.xml.schema.model.Attribute)) continue;
            LocalAttribute localAttribute = (LocalAttribute)((org.netbeans.modules.xml.schema.model.Attribute)schemaComponent2).copy((Component)localAttributeContainer);
            localAttributeContainer.addLocalAttribute(localAttribute);
            for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
                if (aXIComponent2.getPeer() != schemaComponent2) continue;
                aXIComponent2.setPeer((SchemaComponent)localAttribute);
            }
        }
    }

    public void visit(AXIComponent aXIComponent) {
        throw new IllegalArgumentException("No action taken on this component: " + aXIComponent.toString());
    }

    protected abstract SchemaGenerator.Pattern getSchemaDesignPattern();

    protected void prepareGlobalElement(Element element) {
        GlobalElement globalElement = null;
        ElementReference elementReference = null;
        int n = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            n = element.getIndex(false);
        }
        if (this.scParent instanceof Schema) {
            globalElement = this.createGlobalElement(element);
            this.sgh.addElement(globalElement, n);
            this.prepareFixGlobalElementNames(element, globalElement, null);
        } else if (this.scParent instanceof ComplexTypeDefinition) {
            HashMap<String, SchemaComponent> hashMap;
            String string = element.getName();
            boolean bl = false;
            if ((SchemaGeneratorUtil.isSimpleElement(element) || SchemaGeneratorUtil.hasProxyChild(element)) && (hashMap = this.namesMap.get(GlobalElement.class)) != null && hashMap.get(string) != null) {
                GlobalElement globalElement2 = (GlobalElement)hashMap.get(string);
                GlobalElement globalElement3 = SchemaGeneratorUtil.createGlobalElement(this.sm);
                globalElement3.setName(element.getName());
                SchemaGeneratorUtil.populateElement((org.netbeans.modules.xml.schema.model.Element)globalElement3, element);
                this.datatypeParent = globalElement3;
                if (element.getType() instanceof Datatype) {
                    element.getType().accept(this);
                } else if (element.getType() instanceof ContentModel) {
                    SchemaGeneratorUtil.setType((org.netbeans.modules.xml.schema.model.Element)globalElement3, (GlobalComplexType)((ContentModel)element.getType()).getPeer());
                }
                if (SchemaGeneratorUtil.isIdentical((SchemaComponent)globalElement2, (SchemaComponent)globalElement3)) {
                    bl = true;
                    globalElement = globalElement2;
                    if (!this.elementReuseList.contains(element)) {
                        this.elementReuseList.add(element);
                    }
                }
            }
            if (!bl) {
                globalElement = this.createGlobalElement(element);
                this.sgh.addElement(globalElement, -1);
            }
            elementReference = SchemaGeneratorUtil.createElementReference(this.sm, this.scParent, globalElement, n);
            this.addRef((SchemaComponent)elementReference, (SchemaComponent)globalElement);
            this.prepareFixGlobalElementNames(element, globalElement, elementReference);
        }
        assert (globalElement != null);
        this.sc = globalElement;
        SchemaGeneratorUtil.populateElement((org.netbeans.modules.xml.schema.model.Element)globalElement, element);
        if (elementReference != null) {
            SchemaGeneratorUtil.populateElement(elementReference, element);
        }
        this.datatypeParent = globalElement;
        if (element.getType() instanceof Datatype) {
            element.getType().accept(this);
        }
        this.setPeer(element, (org.netbeans.modules.xml.schema.model.Element)globalElement, elementReference);
    }

    protected void prepareElementRef(ElementRef elementRef) {
        int n = elementRef.getIndex();
        ElementReference elementReference = SchemaGeneratorUtil.createElementReference(this.sm, (SchemaComponent)((ComplexTypeDefinition)this.scParent), (GlobalElement)elementRef.getReferent().getPeer(), n);
        this.setPeer(elementRef, null, elementReference);
    }

    protected void prepareLocalElement(Element element) {
        GlobalElement globalElement = null;
        int n = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            n = element.getIndex(false);
        }
        if (this.scParent instanceof Schema) {
            globalElement = this.createGlobalElement(element);
            this.sgh.addElement(globalElement, n);
            this.prepareFixGlobalElementNames(element, globalElement, null);
        } else if (this.scParent instanceof ComplexTypeDefinition) {
            globalElement = SchemaGeneratorUtil.createLocalElement(this.sm, (ComplexTypeDefinition)this.scParent, element.getName(), n);
        }
        assert (globalElement != null);
        this.sc = globalElement;
        SchemaGeneratorUtil.populateElement((org.netbeans.modules.xml.schema.model.Element)globalElement, element);
        this.datatypeParent = globalElement;
        if (element.getType() instanceof Datatype) {
            element.getType().accept(this);
        }
        this.setPeer(element, (org.netbeans.modules.xml.schema.model.Element)globalElement, null);
    }

    protected void prepareAttributeRef(AttributeRef attributeRef) {
        int n = attributeRef.getIndex();
        AttributeReference attributeReference = SchemaGeneratorUtil.createAttributeReference(this.sm, this.scParent, (GlobalAttribute)attributeRef.getReferent().getPeer(), n);
        this.setPeer(attributeRef, null, attributeReference);
    }

    protected void prepareLocalAttribute(Attribute attribute) {
        assert (this.scParent != null);
        int n = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            n = attribute.getIndex();
        }
        LocalAttribute localAttribute = null;
        if (this.scParent instanceof ComplexType && ((ComplexType)this.scParent).getDefinition() instanceof ComplexTypeDefinition) {
            if (((ComplexType)this.scParent).getDefinition() instanceof SimpleContent) {
                SimpleContentDefinition simpleContentDefinition = ((SimpleContent)((ComplexType)this.scParent).getDefinition()).getLocalDefinition();
                if (simpleContentDefinition instanceof SimpleContentRestriction) {
                    localAttribute = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((SimpleContentRestriction)simpleContentDefinition), n);
                } else if (simpleContentDefinition instanceof Extension) {
                    localAttribute = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((Extension)simpleContentDefinition), n);
                }
            } else if (((ComplexType)this.scParent).getDefinition() instanceof ComplexContent) {
                ComplexContentDefinition complexContentDefinition = ((ComplexContent)((ComplexType)this.scParent).getDefinition()).getLocalDefinition();
                if (complexContentDefinition instanceof ComplexContentRestriction) {
                    localAttribute = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((ComplexContentRestriction)complexContentDefinition), n);
                } else if (complexContentDefinition instanceof Extension) {
                    localAttribute = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((Extension)complexContentDefinition), n);
                }
            } else {
                localAttribute = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), this.scParent, n);
            }
        } else {
            localAttribute = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), this.scParent, n);
        }
        assert (localAttribute != null);
        SchemaGeneratorUtil.populateAttribute((org.netbeans.modules.xml.schema.model.Attribute)localAttribute, attribute);
        this.datatypeParent = localAttribute;
        if (attribute.getType() instanceof Datatype) {
            attribute.getType().accept(this);
        }
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            attribute.setPeer((SchemaComponent)localAttribute);
        }
    }

    protected GlobalElement createGlobalElement(Element element) {
        GlobalElement globalElement = SchemaGeneratorUtil.createGlobalElement(this.sm);
        String string = this.findUniqueGlobalName(GlobalElement.class, (NameableSchemaComponent)globalElement, element.getName());
        globalElement.setName(string);
        return globalElement;
    }

    protected GlobalComplexType createGlobalComplexType(String string) {
        GlobalComplexType globalComplexType = SchemaGeneratorUtil.createGlobalComplexType(this.sm);
        String string2 = this.findUniqueGlobalName(GlobalComplexType.class, (NameableSchemaComponent)globalComplexType, string);
        globalComplexType.setName(string2);
        return globalComplexType;
    }

    public void createGlobalSimpleType(Datatype datatype, SchemaModel schemaModel, SchemaComponent schemaComponent, SchemaGenerator.UniqueId uniqueId, SchemaGenerator.PrimitiveCart primitiveCart) {
        if (datatype != null) {
            NamedComponentReference namedComponentReference = null;
            if (SchemaGeneratorUtil.isPrimitiveType(datatype)) {
                namedComponentReference = SchemaGeneratorUtil.createPrimitiveType(datatype, schemaComponent, primitiveCart);
            } else {
                GlobalSimpleType globalSimpleType = SchemaGeneratorUtil.createGlobalSimpleType(schemaModel);
                String string = datatype.getName();
                string = this.findUniqueGlobalName(GlobalSimpleType.class, (NameableSchemaComponent)globalSimpleType, "New" + string.substring(0, 1).toUpperCase() + string.substring(1) + "Type" + String.valueOf(uniqueId.nextId()));
                globalSimpleType.setName(string);
                this.sgh.addSimpleType(globalSimpleType, -1);
                if (datatype instanceof CustomDatatype) {
                    SchemaGeneratorUtil.populateSimpleType(((CustomDatatype)datatype).getBase(), schemaModel, (SchemaComponent)globalSimpleType, primitiveCart);
                } else {
                    SchemaGeneratorUtil.populateSimpleType(datatype, schemaModel, (SchemaComponent)globalSimpleType, primitiveCart);
                }
                namedComponentReference = schemaComponent.createReferenceTo((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class);
            }
            SchemaGeneratorUtil.setSimpleType(schemaComponent, namedComponentReference);
        }
    }

    protected GlobalType createPeerGlobalComplexType(Element element) {
        org.netbeans.modules.xml.schema.model.Element element2 = (org.netbeans.modules.xml.schema.model.Element)element.getPeer();
        if (element2 instanceof ElementReference) {
            element2 = (GlobalElement)this.getRef((SchemaComponent)element2);
        }
        GlobalComplexType globalComplexType = this.createGlobalComplexType(element.getName() + "Type");
        assert (globalComplexType != null);
        this.sgh.addComplexType(globalComplexType, -1);
        SchemaGeneratorUtil.setType(element2, globalComplexType);
        return globalComplexType;
    }

    protected void prepareFixGlobalElementNames(Element element, GlobalElement globalElement, ElementReference elementReference) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(element);
        arrayList.add((Element)globalElement);
        arrayList.add((Element)elementReference);
        this.fixNamesMap.put(new Integer(this.fgeCount++), arrayList);
    }

    protected void fixGlobalElementNames() {
        List<Object> list;
        Object object;
        Object object2;
        GlobalElement globalElement;
        Map.Entry<Integer, List<Object>> entry2;
        this.namesMap.clear();
        HashMap hashMap = new HashMap();
        for (Map.Entry<Integer, List<Object>> entry2 : this.fixNamesMap.entrySet()) {
            globalElement = entry2.getValue();
            if (globalElement == null || globalElement.size() <= 1) continue;
            object2 = (GlobalElement)globalElement.get(1);
            object = (ElementReference)globalElement.get(2);
            list = (List)hashMap.get(object2);
            if (list == null) {
                list = new ArrayList<ElementReference>();
                hashMap.put(object2, list);
            }
            if (object == null || list.contains(object)) continue;
            list.add(object);
        }
        int n = 0;
        entry2 = hashMap.keySet().iterator();
        while (entry2.hasNext()) {
            if (commitRange > 0 && n++ % commitRange == 0) {
                this.sm.endTransaction();
                this.sm.startTransaction();
            }
            globalElement = (GlobalElement)entry2.next();
            object2 = (List)hashMap.get(globalElement);
            object = this.findUniqueGlobalName(GlobalElement.class, (NameableSchemaComponent)globalElement, globalElement.getName());
            globalElement.setName((String)object);
            list = object2.iterator();
            while (list.hasNext()) {
                ElementReference elementReference = (ElementReference)list.next();
                elementReference.setRef(elementReference.createReferenceTo((ReferenceableSchemaComponent)globalElement, GlobalElement.class));
            }
        }
        hashMap.clear();
        hashMap = null;
        this.fixNamesMap.clear();
    }

    <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> clazz, NameableSchemaComponent nameableSchemaComponent, String string) {
        return this.sgh.findUniqueGlobalName(clazz, nameableSchemaComponent, string);
    }

    protected SchemaComponent getParent(AXIComponent aXIComponent) throws IllegalArgumentException {
        return this.sgh.getParent(aXIComponent);
    }

    protected void setPeer(Element element, org.netbeans.modules.xml.schema.model.Element element2, ElementReference elementReference) {
        this.sgh.setPeer(element, element2, elementReference);
    }

    protected void setPeer(Attribute attribute, org.netbeans.modules.xml.schema.model.Attribute attribute2, AttributeReference attributeReference) {
        this.sgh.setPeer(attribute, attribute2, attributeReference);
    }

    private SchemaGenerator.UniqueId createUniqueId() {
        return new SchemaGenerator.UniqueId(){
            private int lastId = -1;

            public int nextId() {
                return ++this.lastId;
            }
        };
    }

    private SchemaGenerator.PrimitiveCart createPrimitiveCart() {
        return new SchemaGenerator.PrimitiveCart(){
            private Map<SchemaComponent, Datatype> pc = new HashMap<SchemaComponent, Datatype>();
            private Map<String, GlobalSimpleType> ptypes = new HashMap<String, GlobalSimpleType>();
            private GlobalSimpleType def = null;

            @Override
            public void add(Datatype datatype, SchemaComponent schemaComponent) {
                this.pc.put(schemaComponent, datatype);
            }

            @Override
            public Set<Map.Entry<SchemaComponent, Datatype>> getEntries() {
                return this.pc.entrySet();
            }

            @Override
            public GlobalSimpleType getDefaultPrimitive() {
                if (this.def == null) {
                    this.def = this.getPrimitiveType("string");
                }
                return this.def;
            }

            @Override
            public GlobalSimpleType getPrimitiveType(String string) {
                if (this.ptypes.isEmpty()) {
                    SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
                    Collection collection = schemaModel.getSchema().getSimpleTypes();
                    for (GlobalSimpleType globalSimpleType : collection) {
                        this.ptypes.put(globalSimpleType.getName(), globalSimpleType);
                    }
                }
                return this.ptypes.get(string);
            }
        };
    }

    protected void addRef(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        this.sgh.addRef(schemaComponent, schemaComponent2);
    }

    protected SchemaComponent getRef(SchemaComponent schemaComponent) {
        return this.sgh.getRef(schemaComponent);
    }

    protected void addToGlobal(SchemaComponent schemaComponent) {
        this.createGlobals.add(schemaComponent);
    }

    private void fixPrimitiveTypes() {
        for (Map.Entry<SchemaComponent, Datatype> entry : this.pc.getEntries()) {
            Datatype datatype = entry.getValue();
            SchemaComponent schemaComponent = entry.getKey();
            String string = datatype.getName();
            if (datatype instanceof CustomDatatype) {
                string = ((CustomDatatype)datatype).getBase().getName();
            }
            GlobalSimpleType globalSimpleType = this.pc.getPrimitiveType(string);
            NamedComponentReference namedComponentReference = schemaComponent.createReferenceTo((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class);
            SchemaGeneratorUtil.setSimpleType(schemaComponent, (NamedComponentReference<GlobalSimpleType>)namedComponentReference);
        }
    }

    protected void clear() {
        this.path.clear();
        this.path = null;
        this.createGlobals.clear();
        this.createGlobals = null;
        this.fixNamesMap.clear();
        this.fixNamesMap = null;
        this.refMap.clear();
        this.refMap = null;
        this.namesMap.clear();
        this.namesMap = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransformHelper
    implements SchemaGeneratorHelper {
        TransformHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(SchemaModel schemaModel) throws IOException {
            DefaultSchemaGenerator.this.sm = schemaModel;
            DefaultSchemaGenerator.this.am = AXIModelFactory.getDefault().getModel(schemaModel);
            Schema schema = schemaModel.getSchema();
            assert (schema != null);
            try {
                HashMap<Class, Map<String, SchemaComponent>> hashMap = new HashMap<Class, Map<String, SchemaComponent>>();
                List<Element> list = this.preTransform(schema, hashMap);
                ((AXIModelImpl)DefaultSchemaGenerator.this.am).disableAutoSync();
                schemaModel.startTransaction();
                for (Element element : list) {
                    ArrayList<AXIComponent> arrayList = new ArrayList<AXIComponent>();
                    arrayList.add(element);
                    this.transformChildren(element, (SchemaComponent)schema, arrayList);
                }
                this.postTransform(schema, hashMap);
            }
            finally {
                this.clear();
                try {
                    schemaModel.endTransaction();
                }
                finally {
                    ((AXIModelImpl)DefaultSchemaGenerator.this.am).enableAutoSync();
                    DefaultSchemaGenerator.this.am.sync();
                }
            }
        }

        @Override
        public SchemaComponent getParent(AXIComponent aXIComponent) throws IllegalArgumentException {
            throw new IllegalArgumentException("should not call this api during transform");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void transformChildren(AXIComponent aXIComponent, SchemaComponent schemaComponent, List<AXIComponent> list) {
            if (!SchemaGeneratorUtil.fromSameSchemaModel(aXIComponent.getPeer(), DefaultSchemaGenerator.this.sm)) {
                return;
            }
            assert (schemaComponent != null);
            DefaultSchemaGenerator.this.scParent = schemaComponent;
            aXIComponent.accept(DefaultSchemaGenerator.this);
            if (DefaultSchemaGenerator.this.elementReuseList.contains(aXIComponent)) {
                return;
            }
            SchemaComponent schemaComponent2 = DefaultSchemaGenerator.this.sc;
            if (aXIComponent instanceof Element) {
                Object object = (Element)aXIComponent;
                if (((Element)object).isReference()) {
                    object = SchemaGeneratorUtil.findOriginalElement((Element)object);
                }
                if (DefaultSchemaGenerator.this.path.size() > 0 && DefaultSchemaGenerator.this.path.contains(object)) {
                    return;
                }
                DefaultSchemaGenerator.this.path.add((AXIComponent)object);
            }
            try {
                if (aXIComponent.getChildren().size() > 0) {
                    schemaComponent = DefaultSchemaGenerator.this.scParent;
                }
                assert (schemaComponent != null);
                if (aXIComponent instanceof AbstractElement) {
                    for (AbstractAttribute aXIComponent2 : ((AbstractElement)aXIComponent).getAttributes()) {
                        if (!SchemaGeneratorUtil.fromSameSchemaModel(aXIComponent2.getPeer(), DefaultSchemaGenerator.this.sm)) continue;
                        DefaultSchemaGenerator.this.scParent = schemaComponent;
                        aXIComponent2.accept(DefaultSchemaGenerator.this);
                    }
                }
                for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
                    if (aXIComponent2 instanceof AbstractAttribute || list.contains(aXIComponent2.getOriginal())) continue;
                    list.add(aXIComponent2.getOriginal());
                    this.transformChildren(aXIComponent2, schemaComponent, list);
                }
            }
            finally {
                if (aXIComponent instanceof Element) {
                    DefaultSchemaGenerator.this.path.remove(DefaultSchemaGenerator.this.path.size() - 1);
                }
            }
        }

        protected List<Element> preTransform(Schema schema, Map<Class, Map<String, SchemaComponent>> map) {
            Object object5;
            Object object22;
            Object object32;
            Object object42;
            List<Element> list = SchemaGeneratorUtil.findMasterGlobalElements(DefaultSchemaGenerator.this.am);
            AXINonCyclicVisitor aXINonCyclicVisitor = new AXINonCyclicVisitor(DefaultSchemaGenerator.this.am);
            aXINonCyclicVisitor.expand(list);
            TreeMap<String, GlobalGroup> treeMap = new TreeMap<String, GlobalGroup>();
            map.put(GlobalGroup.class, treeMap);
            for (Object object42 : schema.getGroups()) {
                treeMap.put(object42.getName(), (GlobalGroup)object42);
            }
            TreeMap treeMap2 = new TreeMap();
            map.put(GlobalComplexType.class, treeMap2);
            for (Object object32 : schema.getComplexTypes()) {
                treeMap2.put(object32.getName(), object32);
            }
            object42 = new TreeMap();
            map.put(GlobalAttributeGroup.class, (Map<String, SchemaComponent>)object42);
            for (Object object22 : schema.getAttributeGroups()) {
                object42.put(object22.getName(), object22);
            }
            object32 = new TreeMap();
            map.put(GlobalSimpleType.class, (Map<String, SchemaComponent>)object32);
            for (Object object5 : schema.getSimpleTypes()) {
                object32.put(object5.getName(), object5);
            }
            object22 = new TreeMap();
            map.put(GlobalElement.class, (Map<String, SchemaComponent>)object22);
            for (Object object6 : schema.getElements()) {
                object22.put(object6.getName(), object6);
            }
            object5 = new TreeMap();
            map.put(GlobalAttribute.class, (Map<String, SchemaComponent>)object5);
            for (GlobalAttribute globalAttribute : schema.getAttributes()) {
                object5.put(globalAttribute.getName(), globalAttribute);
            }
            return list;
        }

        protected void postTransform(Schema schema, HashMap<Class, Map<String, SchemaComponent>> hashMap) {
            this.removeAllGlobals(schema, hashMap);
            this.addAllGlobals(schema, DefaultSchemaGenerator.this.createGlobals);
            DefaultSchemaGenerator.this.fixGlobalElementNames();
            DefaultSchemaGenerator.this.fixPrimitiveTypes();
        }

        private void removeAllGlobals(Schema schema, HashMap<Class, Map<String, SchemaComponent>> hashMap) {
            this.removeGlobalSchemaComponent(GlobalSimpleType.class, hashMap, schema);
            this.removeGlobalSchemaComponent(GlobalAttribute.class, hashMap, schema);
            this.removeGlobalSchemaComponent(GlobalAttributeGroup.class, hashMap, schema);
            this.removeGlobalSchemaComponent(GlobalComplexType.class, hashMap, schema);
            this.removeGlobalSchemaComponent(GlobalGroup.class, hashMap, schema);
            this.removeGlobalSchemaComponent(GlobalElement.class, hashMap, schema);
        }

        private void removeGlobalSchemaComponent(Class clazz, HashMap<Class, Map<String, SchemaComponent>> hashMap, Schema schema) {
            Map<String, SchemaComponent> map = hashMap.get(clazz);
            if (map == null) {
                return;
            }
            int n = 0;
            for (Map.Entry<String, SchemaComponent> entry : map.entrySet()) {
                SchemaComponent schemaComponent = entry.getValue();
                this.commitTransaction(n);
                if (schemaComponent instanceof GlobalSimpleType) {
                    schema.removeSimpleType((GlobalSimpleType)schemaComponent);
                    continue;
                }
                if (schemaComponent instanceof GlobalAttribute) {
                    schema.removeAttribute((GlobalAttribute)schemaComponent);
                    continue;
                }
                if (schemaComponent instanceof GlobalAttributeGroup) {
                    schema.removeAttributeGroup((GlobalAttributeGroup)schemaComponent);
                    continue;
                }
                if (schemaComponent instanceof GlobalComplexType) {
                    schema.removeComplexType((GlobalComplexType)schemaComponent);
                    continue;
                }
                if (schemaComponent instanceof GlobalGroup) {
                    schema.removeGroup((GlobalGroup)schemaComponent);
                    continue;
                }
                if (!(schemaComponent instanceof GlobalElement)) continue;
                schema.removeElement((GlobalElement)schemaComponent);
            }
        }

        private void commitTransaction(int n) {
            if (commitRange > 0 && n++ % commitRange == 0) {
                DefaultSchemaGenerator.this.sm.endTransaction();
                DefaultSchemaGenerator.this.sm.startTransaction();
            }
        }

        @Override
        public <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> clazz, NameableSchemaComponent nameableSchemaComponent, String string) {
            String string2;
            HashMap<String, Object> hashMap = DefaultSchemaGenerator.this.namesMap.get(clazz);
            if (hashMap == null) {
                hashMap = new HashMap();
                DefaultSchemaGenerator.this.namesMap.put(clazz, hashMap);
            }
            int n = 0;
            boolean bl = true;
            while (bl) {
                bl = false;
                string2 = (SchemaComponent)hashMap.get(n > 0 ? string + String.valueOf(n) : string);
                if (string2 == null) continue;
                ++n;
                bl = true;
            }
            string2 = n > 0 ? string + String.valueOf(n) : string;
            hashMap.put(string2, nameableSchemaComponent);
            return string2;
        }

        @Override
        public void setPeer(Element element, org.netbeans.modules.xml.schema.model.Element element2, ElementReference elementReference) {
            if (element.getChildren().size() > 0) {
                LocalType localType = SchemaGeneratorUtil.getLocalComplexType((SchemaComponent)element2);
                if (localType == null) {
                    localType = SchemaGeneratorUtil.findTypeFromOtherModel(element2, element, DefaultSchemaGenerator.this.sm);
                    if (localType == null) {
                        localType = SchemaGeneratorUtil.createLocalComplexType(DefaultSchemaGenerator.this.sm, (SchemaComponent)element2);
                    }
                    assert (localType != null);
                    DefaultSchemaGenerator.this.scParent = localType;
                }
            } else {
                DefaultSchemaGenerator.this.scParent = element2;
            }
        }

        @Override
        public void setPeer(Attribute attribute, org.netbeans.modules.xml.schema.model.Attribute attribute2, AttributeReference attributeReference) {
        }

        @Override
        public void addElement(GlobalElement globalElement, int n) {
            DefaultSchemaGenerator.this.addToGlobal((SchemaComponent)globalElement);
        }

        @Override
        public void addComplexType(GlobalComplexType globalComplexType, int n) {
            DefaultSchemaGenerator.this.addToGlobal((SchemaComponent)globalComplexType);
        }

        @Override
        public void addSimpleType(GlobalSimpleType globalSimpleType, int n) {
            DefaultSchemaGenerator.this.addToGlobal((SchemaComponent)globalSimpleType);
        }

        protected void addAllGlobals(Schema schema, List<SchemaComponent> list) {
            for (int i = 0; i < list.size(); ++i) {
                SchemaComponent schemaComponent = list.get(i);
                if (commitRange > 0 && i % commitRange == 0) {
                    DefaultSchemaGenerator.this.sm.endTransaction();
                    DefaultSchemaGenerator.this.sm.startTransaction();
                }
                if (schemaComponent instanceof GlobalElement) {
                    DefaultSchemaGenerator.this.sm.getSchema().addElement((GlobalElement)schemaComponent);
                } else if (schemaComponent instanceof GlobalComplexType) {
                    DefaultSchemaGenerator.this.sm.getSchema().addComplexType((GlobalComplexType)schemaComponent);
                }
                if (schemaComponent instanceof GlobalSimpleType) {
                    DefaultSchemaGenerator.this.sm.getSchema().addSimpleType((GlobalSimpleType)schemaComponent);
                    continue;
                }
                if (schemaComponent instanceof GlobalGroup) {
                    DefaultSchemaGenerator.this.sm.getSchema().addGroup((GlobalGroup)schemaComponent);
                    continue;
                }
                if (!(schemaComponent instanceof GlobalAttributeGroup)) continue;
                DefaultSchemaGenerator.this.sm.getSchema().addAttributeGroup((GlobalAttributeGroup)schemaComponent);
            }
        }

        @Override
        public void addRef(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
            DefaultSchemaGenerator.this.refMap.put(schemaComponent, schemaComponent2);
        }

        @Override
        public SchemaComponent getRef(SchemaComponent schemaComponent) {
            return DefaultSchemaGenerator.this.refMap.get(schemaComponent);
        }

        protected void clear() {
            DefaultSchemaGenerator.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpdateHelper
    implements SchemaGeneratorHelper {
        UpdateHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(SchemaModel schemaModel) throws IOException {
            DefaultSchemaGenerator.this.sm = schemaModel;
            DefaultSchemaGenerator.this.am = AXIModelFactory.getDefault().getModel(schemaModel);
            SchemaUpdate schemaUpdate = SchemaGeneratorUtil.getSchemaUpdate(DefaultSchemaGenerator.this.am);
            Collection<SchemaUpdate.UpdateUnit> collection = schemaUpdate.getUpdateUnits();
            try {
                ((AXIModelImpl)DefaultSchemaGenerator.this.am).disableAutoSync();
                schemaModel.startTransaction();
                for (SchemaUpdate.UpdateUnit updateUnit : collection) {
                    AXIComponent aXIComponent = updateUnit.getSource();
                    if (aXIComponent.getModel() != DefaultSchemaGenerator.this.am) continue;
                    SchemaUpdate.UpdateUnit.Type type = updateUnit.getType();
                    if (type == SchemaUpdate.UpdateUnit.Type.CHILD_ADDED) {
                        this.addSchemaComponent(aXIComponent, updateUnit);
                        continue;
                    }
                    if (type == SchemaUpdate.UpdateUnit.Type.CHILD_DELETED) {
                        SchemaGeneratorUtil.removeSchemaComponent(aXIComponent, updateUnit, schemaModel);
                        continue;
                    }
                    if (type != SchemaUpdate.UpdateUnit.Type.CHILD_MODIFIED) continue;
                    SchemaGeneratorUtil.modifySchemaComponent(aXIComponent, updateUnit, schemaModel, DefaultSchemaGenerator.this.pc);
                }
            }
            finally {
                this.clear();
                schemaModel.endTransaction();
                ((AXIModelImpl)DefaultSchemaGenerator.this.am).enableAutoSync();
            }
        }

        protected void addSchemaComponent(AXIComponent aXIComponent, SchemaUpdate.UpdateUnit updateUnit) {
            assert (updateUnit.getNewValue() != null);
            DefaultSchemaGenerator.this.scParent = DefaultSchemaGenerator.this.getParent((AXIComponent)((AXIComponent)updateUnit.getNewValue()).getParent());
            assert (DefaultSchemaGenerator.this.scParent != null);
            ((AXIComponent)updateUnit.getNewValue()).accept(DefaultSchemaGenerator.this);
        }

        @Override
        public <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> clazz, NameableSchemaComponent nameableSchemaComponent, String string) {
            return SchemaGeneratorUtil.findUniqueGlobalName(clazz, string, DefaultSchemaGenerator.this.sm);
        }

        @Override
        public SchemaComponent getParent(AXIComponent aXIComponent) throws IllegalArgumentException {
            Schema schema = null;
            if (aXIComponent instanceof AXIDocument) {
                schema = DefaultSchemaGenerator.this.sm.getSchema();
            } else if (aXIComponent instanceof Element) {
                SchemaComponent schemaComponent = aXIComponent.getPeer();
                if (schemaComponent instanceof ElementReference) {
                    schemaComponent = this.getRef(aXIComponent.getPeer());
                }
                assert (schemaComponent != null);
                LocalType localType = SchemaGeneratorUtil.getLocalComplexType(schemaComponent);
                if (localType == null && (localType = SchemaGeneratorUtil.getGlobalComplexType(schemaComponent)) == null) {
                    if (schemaComponent instanceof GlobalElement && ((GlobalElement)schemaComponent).getType() != null && ((GlobalElement)schemaComponent).getType().get() instanceof GlobalSimpleType || schemaComponent instanceof LocalElement && ((LocalElement)schemaComponent).getType() != null && ((LocalElement)schemaComponent).getType().get() instanceof GlobalSimpleType) {
                        SimpleContent simpleContent = DefaultSchemaGenerator.this.sm.getFactory().createSimpleContent();
                        SimpleExtension simpleExtension = DefaultSchemaGenerator.this.sm.getFactory().createSimpleExtension();
                        simpleContent.setLocalDefinition((SimpleContentDefinition)simpleExtension);
                        GlobalType globalType = null;
                        if (schemaComponent instanceof GlobalElement) {
                            globalType = (GlobalType)((GlobalElement)schemaComponent).getType().get();
                        } else if (schemaComponent instanceof LocalElement) {
                            globalType = (GlobalType)((LocalElement)schemaComponent).getType().get();
                        }
                        if (globalType != null) {
                            simpleExtension.setBase(simpleExtension.createReferenceTo((ReferenceableSchemaComponent)globalType, GlobalType.class));
                        }
                        localType = SchemaGeneratorUtil.createLocalComplexType(DefaultSchemaGenerator.this.sm, schemaComponent);
                        ((LocalComplexType)localType).setDefinition((ComplexTypeDefinition)simpleContent);
                    } else {
                        localType = SchemaGeneratorUtil.createLocalComplexType(DefaultSchemaGenerator.this.sm, schemaComponent);
                    }
                }
                assert (localType != null);
                schema = localType;
            } else if (aXIComponent instanceof ContentModel) {
                schema = aXIComponent.getPeer();
            } else if (aXIComponent instanceof Compositor) {
                schema = aXIComponent.getPeer();
            }
            return schema;
        }

        @Override
        public void setPeer(Element element, org.netbeans.modules.xml.schema.model.Element element2, ElementReference elementReference) {
            if (elementReference != null) {
                element.setPeer((SchemaComponent)elementReference);
            } else {
                element.setPeer((SchemaComponent)element2);
            }
        }

        @Override
        public void setPeer(Attribute attribute, org.netbeans.modules.xml.schema.model.Attribute attribute2, AttributeReference attributeReference) {
            if (attributeReference != null) {
                attribute.setPeer((SchemaComponent)attributeReference);
            } else {
                attribute.setPeer((SchemaComponent)attribute2);
            }
        }

        @Override
        public void addElement(GlobalElement globalElement, int n) {
            if (n != -1) {
                SchemaGeneratorUtil.addChildComponent(DefaultSchemaGenerator.this.sm, (SchemaComponent)DefaultSchemaGenerator.this.sm.getSchema(), (SchemaComponent)globalElement, n);
            } else {
                DefaultSchemaGenerator.this.sm.getSchema().addElement(globalElement);
            }
        }

        @Override
        public void addComplexType(GlobalComplexType globalComplexType, int n) {
            if (n != -1) {
                SchemaGeneratorUtil.addChildComponent(DefaultSchemaGenerator.this.sm, (SchemaComponent)DefaultSchemaGenerator.this.sm.getSchema(), (SchemaComponent)globalComplexType, n);
            } else {
                DefaultSchemaGenerator.this.sm.getSchema().addComplexType(globalComplexType);
            }
        }

        @Override
        public void addSimpleType(GlobalSimpleType globalSimpleType, int n) {
            if (n != -1) {
                SchemaGeneratorUtil.addChildComponent(DefaultSchemaGenerator.this.sm, (SchemaComponent)DefaultSchemaGenerator.this.sm.getSchema(), (SchemaComponent)globalSimpleType, n);
            } else {
                DefaultSchemaGenerator.this.sm.getSchema().addSimpleType(globalSimpleType);
            }
        }

        @Override
        public void addRef(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        }

        @Override
        public SchemaComponent getRef(SchemaComponent schemaComponent) {
            if (schemaComponent instanceof ElementReference) {
                return (SchemaComponent)((ElementReference)schemaComponent).getRef().get();
            }
            if (schemaComponent instanceof org.netbeans.modules.xml.schema.model.Element) {
                if (schemaComponent instanceof GlobalElement && ((GlobalElement)schemaComponent).getType() != null && ((GlobalElement)schemaComponent).getType().get() instanceof GlobalComplexType) {
                    return (SchemaComponent)((GlobalElement)schemaComponent).getType().get();
                }
                if (schemaComponent instanceof LocalElement && ((LocalElement)schemaComponent).getType() != null && ((LocalElement)schemaComponent).getType().get() instanceof GlobalComplexType) {
                    return (SchemaComponent)((LocalElement)schemaComponent).getType().get();
                }
            }
            return null;
        }

        protected void clear() {
            DefaultSchemaGenerator.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface SchemaGeneratorHelper {
        public void execute(SchemaModel var1) throws IOException;

        public SchemaComponent getParent(AXIComponent var1) throws IllegalArgumentException;

        public <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> var1, NameableSchemaComponent var2, String var3);

        public void setPeer(Element var1, org.netbeans.modules.xml.schema.model.Element var2, ElementReference var3);

        public void setPeer(Attribute var1, org.netbeans.modules.xml.schema.model.Attribute var2, AttributeReference var3);

        public void addRef(SchemaComponent var1, SchemaComponent var2);

        public SchemaComponent getRef(SchemaComponent var1);

        public void addElement(GlobalElement var1, int var2);

        public void addComplexType(GlobalComplexType var1, int var2);

        public void addSimpleType(GlobalSimpleType var1, int var2);
    }
}

