/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.FeatureList;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.NBSLanguageReader;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageImpl
extends Language {
    public static final String IMPORT_FEATURE = "IMPORT";
    private NBSLanguageReader reader;
    private String mimeType;
    private Parser parser;
    private LLSyntaxAnalyser analyser;
    private FeatureList featureList = new FeatureList();
    private EventListenerList listenerList = new EventListenerList();
    private Map<String, Integer> tokenTypeToID;
    private Map<Integer, String> idToTokenType;
    private int tokenTypeCount = 0;
    private Map<String, Integer> ntToNTID;
    private Map<Integer, String> ntidToNt;
    private Feature preprocessorImport;
    private Map<String, Feature> tokenImports = new HashMap<String, Feature>();
    private List<Language> importedLangauges = new ArrayList<Language>();
    private Object INIT_LOCK = new Object();

    public LanguageImpl(String string, NBSLanguageReader nBSLanguageReader) {
        this.mimeType = string;
        this.reader = nBSLanguageReader;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public LLSyntaxAnalyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = LLSyntaxAnalyser.createEmpty(this);
        }
        return this.analyser;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    @Override
    public int getTokenID(String string) {
        if (!this.tokenTypeToID.containsKey(string)) {
            return -1;
        }
        return this.tokenTypeToID.get(string);
    }

    @Override
    public int getTokenTypeCount() {
        return this.tokenTypeCount;
    }

    @Override
    public String getTokenType(int n) {
        if (this.idToTokenType == null) {
            return null;
        }
        return this.idToTokenType.get(n);
    }

    @Override
    public int getNTID(String string) {
        if (this.ntidToNt == null) {
            this.ntidToNt = new HashMap<Integer, String>();
        }
        if (this.ntToNTID == null) {
            this.ntToNTID = new HashMap<String, Integer>();
        }
        if (!this.ntToNTID.containsKey(string)) {
            int n = this.ntToNTID.size();
            this.ntToNTID.put(string, n);
            this.ntidToNt.put(n, string);
        }
        return this.ntToNTID.get(string);
    }

    @Override
    public int getNTCount() {
        if (this.ntToNTID == null) {
            return 0;
        }
        return this.ntToNTID.size();
    }

    @Override
    public String getNT(int n) {
        return this.ntidToNt.get(n);
    }

    @Override
    public Feature getPreprocessorImport() {
        return this.preprocessorImport;
    }

    @Override
    public Map<String, Feature> getTokenImports() {
        return this.tokenImports;
    }

    @Override
    public List<Language> getImportedLanguages() {
        return this.importedLangauges;
    }

    void importLanguage(Feature feature) {
        String string = (String)feature.getValue("mimeType");
        if (feature.getPattern("start") != null) {
            assert (this.preprocessorImport == null);
            this.preprocessorImport = feature;
            try {
                this.importedLangauges.add(LanguagesManager.getDefault().getLanguage(string));
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                this.importedLangauges.add(Language.create(string));
            }
            return;
        }
        if (feature.getValue("state") == null) {
            String string2 = feature.getSelector().getAsString();
            assert (!this.tokenImports.containsKey(string2));
            this.tokenImports.put(string2, feature);
            try {
                this.importedLangauges.add(LanguagesManager.getDefault().getLanguage(string));
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                this.importedLangauges.add(Language.create(string));
            }
            return;
        }
        try {
            Language language = LanguagesManager.getDefault().getLanguage(string);
            String string3 = (String)feature.getValue("state");
            String string4 = feature.getSelector().getAsString();
            if (language.getAnalyser() != null) {
                try {
                    this.analyser = LLSyntaxAnalyser.create(this, language.getAnalyser().getRules(), language.getAnalyser().getSkipTokenTypes());
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            this.featureList.importFeatures(language.getFeatureList());
            this.importedLangauges.addAll(language.getImportedLanguages());
            this.tokenImports.putAll(language.getTokenImports());
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            Utils.notify("Editors/" + string + "/language.nbs:", languageDefinitionNotFoundException);
        }
    }

    public void read(NBSLanguageReader nBSLanguageReader) throws ParseException, IOException {
        this.reader = nBSLanguageReader;
        this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASTNode parse(InputStream inputStream) throws IOException, ParseException {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            if (this.tokenTypeToID == null) {
                try {
                    this.INIT_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.parse(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws ParseException, IOException {
        try {
            Object object222;
            Object object3;
            this.tokenTypeToID = new HashMap<String, Integer>();
            this.idToTokenType = new HashMap<Integer, String>();
            this.featureList = new FeatureList();
            if (!this.reader.containsTokens()) {
                object3 = org.netbeans.api.lexer.Language.find((String)this.getMimeType());
                if (object3 != null) {
                    for (Object object222 : object3.tokenIds()) {
                        int n = object222.ordinal();
                        String object4 = object222.name();
                        this.idToTokenType.put(n, object4);
                        this.tokenTypeToID.put(object4, n);
                        this.tokenTypeCount = Math.max(this.tokenTypeCount, n + 1);
                    }
                } else {
                    this.initLexicalStuff(this.reader.getTokenTypes());
                }
            } else {
                this.initLexicalStuff(this.reader.getTokenTypes());
            }
            object3 = this.reader.getFeatures();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object222 = (Feature)iterator.next();
                if (((Feature)object222).getFeatureName().equals(IMPORT_FEATURE)) {
                    this.importLanguage((Feature)object222);
                }
                this.featureList.add((Feature)object222);
            }
            object222 = new HashSet();
            for (Feature feature : this.featureList.getFeatures("SKIP")) {
                if (!feature.getFeatureName().equals("SKIP")) continue;
                object222.add(this.tokenTypeToID.get(feature.getSelector().toString()));
            }
            List<Rule> list = this.reader.getRules(this);
            this.analyser = LLSyntaxAnalyser.create(this, list, (Set<Integer>)object222);
            this.fire();
            Object object = this.INIT_LOCK;
            synchronized (object) {
                this.INIT_LOCK.notifyAll();
            }
        }
        finally {
            this.reader = null;
        }
    }

    private void initLexicalStuff(List<TokenType> list) {
        for (TokenType tokenType : list) {
            int n = tokenType.getTypeID();
            String string = tokenType.getType();
            this.idToTokenType.put(n, string);
            this.tokenTypeToID.put(string, n);
            this.tokenTypeCount = Math.max(this.tokenTypeCount, n + 1);
        }
        this.parser = Parser.create(list);
    }

    protected void fire() {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        PropertyChangeEvent propertyChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
            }
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public String toString() {
        return "LanguageImpl " + this.mimeType + " (" + this.hashCode() + ")";
    }
}

