/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsUtilities;
import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsVisualPanel1PlatformSelection;
import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsWizardPanel1PlatformSelection;
import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsWizardPanel2Result;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class ImportSettingsAction
extends CallableSystemAction {
    private WizardDescriptor.Panel[] panels;

    public void performAction() {
        boolean cancelled;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"CTL_ImportSettingsAction"));
        wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            File dir = null;
            String selectedOption = (String)wizardDescriptor.getProperty("selectedOption");
            if (selectedOption == null || selectedOption.equals("0")) {
                String selectedVersion = (String)wizardDescriptor.getProperty("version");
                if (selectedVersion != null) {
                    dir = new File(System.getProperty("netbeans.user"));
                    dir = new File(dir.getParent(), selectedVersion);
                }
            } else {
                String selectedPath = (String)wizardDescriptor.getProperty("path");
                dir = new File(selectedPath);
            }
            try {
                ImportSettingsUtilities.importSettings(dir);
                JOptionPane.showMessageDialog(Misc.getMainFrame(), NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsAction.success"));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsAction.error", (Object)ex.getMessage()));
            }
        }
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new ImportSettingsWizardPanel1PlatformSelection(), new ImportSettingsWizardPanel2Result()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String getName() {
        return NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"CTL_ImportSettingsAction");
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

