/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.ResultStyleException;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class SumFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Sum", "Sum(<Set>[, <Numeric Expression>])", "Returns the sum of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, SumFunDef.class);

    public SumFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        for (ResultStyle r : compiler.getAcceptableResultStyles()) {
            switch (r) {
                case ITERABLE: 
                case ANY: {
                    Calc calc = this.compileCall(call, compiler, ResultStyle.ITERABLE);
                    if (calc == null) break;
                    return calc;
                }
                case MUTABLE_LIST: {
                    Calc calc = this.compileCall(call, compiler, ResultStyle.MUTABLE_LIST);
                    if (calc == null) break;
                    return calc;
                }
                case LIST: {
                    Calc calc = this.compileCall(call, compiler, ResultStyle.LIST);
                    if (calc == null) break;
                    return calc;
                }
            }
        }
        throw ResultStyleException.generate(ResultStyle.ITERABLE_LIST_MUTABLELIST_ANY, compiler.getAcceptableResultStyles());
    }

    protected Calc compileCall(ResolvedFunCall call, ExpCompiler compiler, ResultStyle resultStyle) {
        ValueCalc calc;
        IterCalc ncalc = compiler.compileIter(call.getArg(0));
        if (ncalc == null) {
            return null;
        }
        Calc calc2 = calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        if (ncalc instanceof ListCalc) {
            return this.genListCalc(call, ncalc, calc);
        }
        return this.genIterCalc(call, ncalc, calc);
    }

    protected Calc genIterCalc(ResolvedFunCall call, final Calc ncalc, final Calc calc) {
        return new AbstractDoubleCalc(call, new Calc[]{ncalc, calc}){

            public double evaluateDouble(Evaluator evaluator) {
                IterCalc iterCalc = (IterCalc)ncalc;
                Iterable iterable = SumFunDef.this.evaluateCurrentIterable(iterCalc, evaluator);
                return FunUtil.sumDouble(evaluator.push(), iterable, calc);
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }

    protected Calc genListCalc(ResolvedFunCall call, final Calc ncalc, final Calc calc) {
        return new AbstractDoubleCalc(call, new Calc[]{ncalc, calc}){

            public double evaluateDouble(Evaluator evaluator) {
                ListCalc listCalc = (ListCalc)ncalc;
                List memberList = AbstractAggregateFunDef.evaluateCurrentList(listCalc, evaluator);
                return FunUtil.sumDouble(evaluator.push(false), memberList, calc);
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 2.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

