/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;

public class CreateDetailTextFieldsForFieldsAction
extends CreateTextFieldAction {
    public JRDesignElement[] createElements(JasperDesign jd, boolean labels) {
        List fields = (List)this.getPaletteItem().getData();
        ArrayList<JRDesignTextField> elements = new ArrayList<JRDesignTextField>();
        int w = jd.getPageWidth() - jd.getLeftMargin() - jd.getRightMargin();
        w /= fields.size();
        for (JRDesignField field : fields) {
            JRDesignTextField element = null;
            if (!labels) {
                element = new JRDesignTextField((JRDefaultStyleProvider)jd);
                JRDesignExpression exp = new JRDesignExpression();
                exp.setText("$F{" + field.getName() + "}");
                exp.setValueClassName(field.getValueClassName());
                element.setExpression((JRExpression)exp);
                CreateDetailTextFieldsForFieldsAction.setMatchingClassExpression((JRDesignExpression)element.getExpression(), field.getValueClassName(), true);
                element.setExpression((JRExpression)exp);
            } else {
                element = new JRDesignStaticText((JRDefaultStyleProvider)jd);
                if (field.getDescription() != null && field.getDescription().trim().length() > 0) {
                    ((JRDesignStaticText)element).setText(field.getDescription());
                } else {
                    ((JRDesignStaticText)element).setText(field.getName());
                }
            }
            element.setWidth(w);
            element.setHeight(20);
            elements.add(element);
        }
        return elements.toArray(new JRDesignElement[elements.size()]);
    }

    public void drop(DropTargetDropEvent dtde) {
        JRDesignElement[] elements = this.createElements(this.getJasperDesign(), false);
        if (elements == null || elements.length == 0) {
            return;
        }
        this.dropElementsAt(this.getScene(), this.getJasperDesign(), elements, dtde.getLocation());
        if (this.getJasperDesign().getColumnHeader() != null && this.getJasperDesign().getColumnHeader().getHeight() >= 20 && IReportManager.getPreferences().getBoolean("createLabelForField", true)) {
            int y = ModelUtils.getBandLocation(this.getJasperDesign().getColumnHeader(), this.getJasperDesign());
            Point labelLocation = this.getScene().convertSceneToView(new Point(this.getJasperDesign().getLeftMargin() + 1, y + 1));
            this.dropElementsAt(this.getScene(), this.getJasperDesign(), this.createElements(this.getJasperDesign(), true), labelLocation);
        }
    }

    public void adjustElement(JRDesignElement[] elements, int index, Scene theScene, JasperDesign jasperDesign, Object parent, Point dropLocation) {
        if (index == 0 && elements.length == 1) {
            return;
        }
        int newx = index == 0 ? 0 : elements[index - 1].getX() + elements[index - 1].getWidth();
        elements[index].setX(newx);
        elements[index].setY(0);
        super.adjustElement(elements, index, theScene, jasperDesign, parent, dropLocation);
    }
}

