/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.designer.menu.EditQueryAction;
import com.jaspersoft.ireport.designer.outline.nodes.DatasetChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.JRPropertiesMapProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.EnumProperty;
import com.jaspersoft.ireport.designer.sheet.properties.FilterExpressionProperty;
import com.jaspersoft.ireport.designer.undo.DeleteDatasetUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import org.openide.actions.CopyAction;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class DatasetNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    JRDesignDataset dataset = null;

    public DatasetNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)new DatasetChildren(jd, dataset, doLkp), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.singleton((Object)jd)}));
        this.jd = jd;
        this.dataset = dataset;
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/dataset-16.png");
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public String getDisplayName() {
        return this.dataset.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set datasetPropertySet = Sheet.createPropertiesSet();
        datasetPropertySet.setName("DATASET_PROPERTIES");
        datasetPropertySet.setDisplayName("Dataset properties");
        DatasetNode.fillDatasetPropertySet(datasetPropertySet, this.dataset, this.jd);
        sheet.put(datasetPropertySet);
        return sheet;
    }

    public static Sheet.Set fillDatasetPropertySet(Sheet.Set datasetPropertySet, JRDesignDataset dataset, JasperDesign jasperDesign) {
        if (!dataset.isMainDataset()) {
            datasetPropertySet.put((Node.Property)new NameProperty(dataset, jasperDesign));
        }
        datasetPropertySet.put((Node.Property)new ScriptletProperty(dataset));
        datasetPropertySet.put((Node.Property)new ResourceBundleProperty(dataset));
        datasetPropertySet.put((Node.Property)new WhenResourceMissingTypeProperty(dataset));
        datasetPropertySet.put((Node.Property)new QueryTextProperty(dataset));
        datasetPropertySet.put((Node.Property)new QueryLanguageProperty(dataset));
        datasetPropertySet.put((Node.Property)new FilterExpressionProperty(dataset));
        datasetPropertySet.put((Node.Property)new JRPropertiesMapProperty((JRPropertiesHolder)dataset));
        return datasetPropertySet;
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Action> myactions = new ArrayList<Action>();
        for (int i = 0; i < actions.length; ++i) {
            myactions.add(actions[i]);
        }
        myactions.add((Action)SystemAction.get(EditQueryAction.class));
        myactions.add(null);
        myactions.add((Action)SystemAction.get(CopyAction.class));
        myactions.add((Action)SystemAction.get(DeleteAction.class));
        return myactions.toArray(new Action[myactions.size()]);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (DatasetNode.acceptProperty(evt)) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            if (evt.getPropertyName().equals("name")) {
                this.fireDisplayNameChange(null, null);
            }
        }
        if (evt.getPropertyName().equals("query")) {
            this.firePropertyChange("text", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("language", evt.getOldValue(), evt.getNewValue());
        }
    }

    public static boolean acceptProperty(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return false;
        }
        return evt.getPropertyName().equals("name") || evt.getPropertyName().equals("resourceBundle") || evt.getPropertyName().equals("scriptletClass") || evt.getPropertyName().equals("filterExpression") || evt.getPropertyName().equals("WhenNoDataType") || evt.getPropertyName().equals("text") || evt.getPropertyName().equals("language");
    }

    public void destroy() throws IOException {
        int index = this.jd.getDatasetsList().indexOf(this.dataset);
        this.jd.removeDataset((JRDataset)this.dataset);
        DeleteDatasetUndoableEdit edit = new DeleteDatasetUndoableEdit(this.dataset, this.jd, index);
        IReportManager.getInstance().addUndoableEdit(edit, true);
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    private static final class QueryTextProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;

        public QueryTextProperty(JRDesignDataset dataset) {
            super("text", String.class, I18n.getString("DatasetNode.Property.QueryText"), I18n.getString("DatasetNode.Property.QueryTextdetail"), true, true);
            this.dataset = dataset;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.dataset.getQuery() != null && this.dataset.getQuery().getText() != null) {
                return this.dataset.getQuery().getText();
            }
            return "";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JRDesignQuery oldValue = (JRDesignQuery)this.dataset.getQuery();
            String text = val == null ? "" : val + "";
            JRDesignQuery newValue = new JRDesignQuery();
            if (oldValue != null && oldValue.getLanguage() != null) {
                newValue.setLanguage(oldValue.getLanguage());
            } else {
                newValue.setLanguage("SQL");
            }
            newValue.setText(text);
            this.dataset.setQuery(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "Query", JRDesignQuery.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class QueryLanguageProperty
    extends PropertySupport
    implements PreferenceChangeListener {
        private final JRDesignDataset dataset;
        private ComboBoxPropertyEditor editor;

        public QueryLanguageProperty(JRDesignDataset dataset) {
            super("queryLanguage", String.class, I18n.getString("DatasetNode.Property.Query"), I18n.getString("DatasetNode.Property.Query"), true, true);
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("oneline", Boolean.TRUE);
            this.setValue("canEditAsText", Boolean.TRUE);
            IReportManager.getPreferences().addPreferenceChangeListener(this);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(true, new ArrayList());
                this.updateLanguages();
            }
            return this.editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateLanguages() {
            ArrayList<Tag> list = new ArrayList<Tag>();
            ArrayList<QueryExecuterDef> quxecuters = IReportManager.getInstance().getQueryExecuters();
            QueryLanguageProperty queryLanguageProperty = this;
            synchronized (queryLanguageProperty) {
                for (int i = 0; i < quxecuters.size(); ++i) {
                    QueryExecuterDef qe = (QueryExecuterDef)quxecuters.get(i);
                    String s = I18n.getString("language." + qe.getLanguage());
                    if (s == null || s.equals("language." + qe.getLanguage())) {
                        s = qe.getLanguage();
                    }
                    list.add(new Tag(qe.getLanguage(), s));
                }
            }
            ArrayList<QueryExecuterDef> queryExecuters = IReportManager.getInstance().getQueryExecuters();
            QueryLanguageProperty queryLanguageProperty2 = this;
            synchronized (queryLanguageProperty2) {
                for (int k = 0; k < queryExecuters.size(); ++k) {
                    QueryExecuterDef qe = (QueryExecuterDef)quxecuters.get(k);
                    String s = qe.getLanguage();
                    boolean found = false;
                    for (int i = 0; i < list.size(); ++i) {
                        Tag t = (Tag)list.get(i);
                        if (!s.toLowerCase().equals((t.getValue() + "").toLowerCase())) continue;
                        found = true;
                    }
                    if (found) continue;
                    list.add(new Tag(qe.getLanguage()));
                }
            }
            if (this.editor != null) {
                this.editor.setTagValues(list);
            }
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.dataset.getQuery() != null && this.dataset.getQuery().getLanguage() != null) {
                return this.dataset.getQuery().getLanguage();
            }
            return "SQL";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String lang;
            JRDesignQuery oldValue = (JRDesignQuery)this.dataset.getQuery();
            String string = lang = val == null ? "SQL" : val + "";
            if (lang.trim().length() == 0) {
                lang = "SQL";
            }
            JRDesignQuery newValue = new JRDesignQuery();
            if (oldValue != null && oldValue.getText() != null) {
                newValue.setText(oldValue.getText());
            }
            newValue.setLanguage(lang);
            this.dataset.setQuery(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "Query", JRDesignQuery.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public void preferenceChange(PreferenceChangeEvent evt) {
            try {
                this.updateLanguages();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static final class WhenResourceMissingTypeProperty
    extends EnumProperty {
        private final JRDesignDataset dataset;

        public WhenResourceMissingTypeProperty(JRDesignDataset dataset) {
            super(WhenResourceMissingTypeEnum.class, dataset);
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getName() {
            return "whenResourceMissingType";
        }

        public String getDisplayName() {
            return I18n.getString("DatasetNode.Property.ResourceMissig");
        }

        public String getShortDescription() {
            return I18n.getString("DatasetNode.Property.ResourceMissigdetail");
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(WhenResourceMissingTypeEnum.EMPTY, I18n.getString("DatasetNode.Property.Empty")));
            tags.add(new Tag(WhenResourceMissingTypeEnum.ERROR, I18n.getString("DatasetNode.Property.Error")));
            tags.add(new Tag(WhenResourceMissingTypeEnum.KEY, I18n.getString("DatasetNode.Property.Key")));
            tags.add(new Tag(WhenResourceMissingTypeEnum.NULL, I18n.getString("DatasetNode.Property.Null")));
            return tags;
        }

        public Object getPropertyValue() {
            return this.dataset.getWhenResourceMissingTypeValue();
        }

        public Object getOwnPropertyValue() {
            return this.getPropertyValue();
        }

        public Object getDefaultValue() {
            return WhenResourceMissingTypeEnum.NULL;
        }

        public void setPropertyValue(Object val) {
            this.dataset.setWhenResourceMissingType((WhenResourceMissingTypeEnum)val);
        }
    }

    private static final class ResourceBundleProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;

        public ResourceBundleProperty(JRDesignDataset dataset) {
            super("resourceBundle", String.class, "Resource bundle", "The base name of the resource bundle used to localize the report", true, true);
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dataset.getResourceBundle() == null ? "" : this.dataset.getResourceBundle();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.dataset.getResourceBundle();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.dataset.setResourceBundle(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "ResourceBundle", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class ScriptletProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;

        public ScriptletProperty(JRDesignDataset dataset) {
            super("scriptletClass", String.class, "Scriptlet class", "The scriptlet class to use with the dataset", true, true);
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dataset.getScriptletClass() == null ? "" : this.dataset.getScriptletClass();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.dataset.getScriptletClass();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.dataset.setScriptletClass(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "ScriptletClass", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
                this.dataset.getEventSupport().firePropertyChange("scriptlets", 0, 0);
            }
        }
    }

    private static final class NameProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;
        private final JasperDesign jd;

        public NameProperty(JRDesignDataset dataset, JasperDesign jd) {
            super("name", String.class, "Dataset name", "The name of this dataset", true, true);
            this.dataset = dataset;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dataset.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.dataset.getName();
                String newValue = (String)val;
                this.dataset.setName(newValue);
                if (!this.dataset.isMainDataset()) {
                    this.jd.getDatasetMap().remove(oldValue);
                    this.jd.getDatasetMap().put(newValue, this.dataset);
                }
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "Name", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }
}

