/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compiler.prompt;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import net.sf.jasperreports.types.date.DateRangeBuilder;

public class DateRangeFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final Logger logger = Logger.getLogger(DateRangeFormatter.class.getName());
    private DateFormat[] _formats = null;
    private int _formatIndex = 0;
    private String dateRangeExpression = null;

    public DateRangeFormatter() {
        this._formats = new DateFormat[3];
        String format = UIManager.getString("JXDatePicker.longFormat");
        if (format == null) {
            format = "EEE MM/dd/yyyy";
        }
        this._formats[0] = new SimpleDateFormat(format);
        format = UIManager.getString("JXDatePicker.mediumFormat");
        if (format == null) {
            format = "MM/dd/yyyy";
        }
        this._formats[1] = new SimpleDateFormat(format);
        format = UIManager.getString("JXDatePicker.shortFormat");
        if (format == null) {
            format = "MM/dd";
        }
        this._formats[2] = new SimpleDateFormat(format);
    }

    public DateRangeFormatter(DateFormat[] formats) {
        this._formats = formats;
    }

    public DateFormat[] getFormats() {
        return this._formats;
    }

    public Object stringToValue(String text) throws ParseException {
        String s = text;
        Date result = null;
        ParseException pex = null;
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < this._formats.length; ++i) {
            try {
                result = this._formats[i].parse(text);
                this._formatIndex = i;
                this.dateRangeExpression = null;
                pex = null;
                break;
            }
            catch (ParseException ex) {
                pex = ex;
                continue;
            }
        }
        if (pex != null) {
            try {
                text = text.replaceAll(" ", "");
                DateRangeBuilder b = new DateRangeBuilder(text);
                Date dt = b.toDateRange().getStart();
                this.dateRangeExpression = text;
                pex = null;
                return text;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (pex != null) {
            throw pex;
        }
        return result;
    }

    public String valueToString(Object value) throws ParseException {
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            return this._formats[this._formatIndex].format(value);
        }
        return null;
    }
}

