/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets.wizards;

import com.jaspersoft.ireport.designer.charts.datasets.wizards.ChartCompletedWizardPanel;
import com.jaspersoft.ireport.designer.charts.datasets.wizards.PieWizardPanel1;
import com.jaspersoft.ireport.designer.charts.datasets.wizards.PieWizardPanel2;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import javax.swing.JComponent;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class PieWizardAction
extends CallableSystemAction {
    public void performAction() {
    }

    public void configureChart(JRDesignPieDataset dataset) {
        boolean cancelled;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle("Pie/Pie3D Wizard");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            JRDesignDataset ds = (JRDesignDataset)wizardDescriptor.getProperty("dataset");
            if (ds == null) {
                return;
            }
            if (!ds.isMainDataset()) {
                JRDesignDatasetRun dr = new JRDesignDatasetRun();
                dr.setDatasetName(ds.getName());
                dataset.setDatasetRun((JRDatasetRun)dr);
            } else {
                dataset.setDatasetRun(null);
            }
            if (wizardDescriptor.getProperty("keyExpression") != null && wizardDescriptor.getProperty("valueExpression") != null) {
                JRDesignPieSeries series = new JRDesignPieSeries();
                series.setKeyExpression((JRExpression)Misc.createExpression("java.lang.Object", (String)wizardDescriptor.getProperty("keyExpression")));
                series.setValueExpression((JRExpression)Misc.createExpression("java.lang.Number", (String)wizardDescriptor.getProperty("valueExpression")));
                while (dataset.getSeriesList().size() > 0) {
                    dataset.removePieSeries((JRPieSeries)dataset.getSeriesList().get(0));
                }
                dataset.addPieSeries((JRPieSeries)series);
            }
        }
    }

    private WizardDescriptor.Panel[] getPanels() {
        WizardDescriptor.Panel[] panels = null;
        panels = new WizardDescriptor.Panel[]{new PieWizardPanel1(), new PieWizardPanel2(), new ChartCompletedWizardPanel()};
        String[] steps = new String[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            Component c = panels[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        return panels;
    }

    public String getName() {
        return "Chart Wizard";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

