/*
 * Decompiled with CFR 0.152.
 */
package rex.utils;

import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLDocumentWriter {
    static Logger logger;

    public XMLDocumentWriter() {
        logger = Logger.getLogger(XMLDocumentWriter.class);
    }

    public void write(Node node) {
        this.write(node, "");
    }

    public void write(Node node, String align) {
        short nodeType = node.getNodeType();
        if (nodeType == 9) {
            logger.info((Object)(align + "<?xml version='1.0'?>"));
            for (Node child = ((Document)node).getFirstChild(); child != null; child = child.getNextSibling()) {
                this.write(child, align);
            }
        } else if (nodeType == 10) {
            logger.info((Object)("<!DOCTYPE " + ((DocumentType)node).getName() + ">"));
        } else if (nodeType == 1) {
            Element element = (Element)node;
            logger.info((Object)(align + "<" + element.getTagName()));
            NamedNodeMap attrs = element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                logger.info((Object)(" " + attrs.item(i).getNodeName() + "='" + this.transform(attrs.item(i).getNodeValue()) + "'"));
            }
            logger.info((Object)">");
            String newalign = align + "    ";
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.write(child, newalign);
            }
            logger.info((Object)(align + "</" + element.getTagName() + ">"));
        } else if (nodeType == 3) {
            String text = ((Text)node).getData().trim();
            if (text != null && text.length() > 0) {
                logger.info((Object)(align + this.transform(text)));
            }
        } else if (nodeType == 7) {
            logger.info((Object)(align + "<?" + ((ProcessingInstruction)node).getTarget() + " " + ((ProcessingInstruction)node).getData() + "?>"));
        } else if (nodeType == 5) {
            logger.info((Object)(align + "&" + node.getNodeName() + ";"));
        } else if (nodeType == 4) {
            logger.info((Object)(align + "<" + "![CDATA[" + ((CDATASection)node).getData() + "]]" + ">"));
        } else if (nodeType == 8) {
            logger.info((Object)(align + "<!--" + ((Comment)node).getData() + "-->"));
        } else {
            logger.error((Object)("Ignoring node: " + node.getClass().getName()));
        }
    }

    String transform(String s) {
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        block7: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                default: {
                    sb.append(c[i]);
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                }
            }
        }
        return sb.toString();
    }
}

