/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes;

import com.jaspersoft.ireport.components.table.TableElementNode;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnAfterAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnBeforeAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnEndAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnGroupAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnStartAction;
import com.jaspersoft.ireport.components.table.actions.DeleteTableCellAction;
import com.jaspersoft.ireport.components.table.actions.DeleteTableColumnAction;
import com.jaspersoft.ireport.components.table.actions.GroupColumnsAction;
import com.jaspersoft.ireport.components.table.actions.TableCellDoHorizontalLayoutAction;
import com.jaspersoft.ireport.components.table.actions.TableCellDoVerticalLayoutAction;
import com.jaspersoft.ireport.components.table.nodes.properties.CellHeightProperty;
import com.jaspersoft.ireport.components.table.nodes.properties.CellPaddingAndBordersProperty;
import com.jaspersoft.ireport.components.table.nodes.properties.CellStyleProperty;
import com.jaspersoft.ireport.components.table.nodes.properties.ColumnPrintWhenExpressionProperty;
import com.jaspersoft.ireport.components.table.nodes.properties.ColumnPropertyExpressionsProperty;
import com.jaspersoft.ireport.components.table.nodes.properties.ColumnWidthProperty;
import com.jaspersoft.ireport.components.table.nodes.properties.RowSpanProperty;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.ElementContainerChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TableCellNode
extends IRIndexedNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignComponentElement tableElement = null;
    private BaseColumn column = null;
    private DesignCell cell = null;
    private byte section = 0;
    private JRGroup group = null;

    public TableCellNode(JasperDesign jd, JRDesignComponentElement tableElement, BaseColumn column, DesignCell cell, byte section, JRGroup group, Lookup doLkp) {
        this(new ElementContainerChildren(jd, (JRDesignElementGroup)cell, doLkp), jd, tableElement, column, cell, section, group, doLkp);
    }

    public TableCellNode(ElementContainerChildren pc, JasperDesign jd, JRDesignComponentElement tableElement, BaseColumn column, DesignCell cell, byte section, JRGroup group, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{jd, tableElement, column, cell}), doLkp}));
        this.jd = jd;
        this.column = column;
        this.tableElement = tableElement;
        this.section = section;
        this.group = group;
        this.cell = cell;
        super.setName("Table cell");
        if (column instanceof StandardColumnGroup) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/header-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/cell-16.png");
        }
        cell.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                int i;
                List elements = TableCellNode.this.getCell().getChildren();
                int[] permutations = ev.getPermutation();
                Object[] elementsArray = new Object[elements.size()];
                for (i = 0; i < elementsArray.length; ++i) {
                    elementsArray[permutations[i]] = elements.get(i);
                }
                elements.clear();
                for (i = 0; i < elementsArray.length; ++i) {
                    elements.add(elementsArray[i]);
                }
                TableCellNode.this.getCell().getEventSupport().firePropertyChange("children", null, (Object)TableCellNode.this.getCell().getChildren());
            }
        });
    }

    public String getDisplayName() {
        if (this.column instanceof StandardColumnGroup) {
            return NbBundle.getMessage(TableElementNode.class, (String)"table.groupCell.name", (Object)(TableModelUtils.getColumnIndex(this.getTable(), this.getColumn()) + 1));
        }
        return NbBundle.getMessage(TableElementNode.class, (String)"table.cell.name", (Object)(TableModelUtils.getColumnIndex(this.getTable(), this.getColumn()) + 1));
    }

    public Action[] getActions(boolean popup) {
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get(DeleteTableCellAction.class));
        list.add(null);
        list.add(SystemAction.get(AddTableColumnAfterAction.class));
        list.add(SystemAction.get(AddTableColumnBeforeAction.class));
        list.add(SystemAction.get(AddTableColumnStartAction.class));
        list.add(SystemAction.get(AddTableColumnEndAction.class));
        list.add(SystemAction.get(AddTableColumnGroupAction.class));
        list.add(null);
        list.add(SystemAction.get(DeleteTableColumnAction.class));
        list.add(null);
        list.add(SystemAction.get(GroupColumnsAction.class));
        list.add(null);
        list.add(SystemAction.get(PasteAction.class));
        list.add(SystemAction.get(TableCellDoVerticalLayoutAction.class));
        list.add(SystemAction.get(TableCellDoHorizontalLayoutAction.class));
        return list.toArray(new Action[list.size()]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new CellStyleProperty(this.getCell(), this.jd));
        set.put((Node.Property)new CellHeightProperty(this.getCell(), this.getTable(), this.getJasperDesign()));
        set.put((Node.Property)new RowSpanProperty(this.getCell(), this.getTable(), this.getJasperDesign()));
        set.put((Node.Property)new ColumnWidthProperty((StandardBaseColumn)this.getColumn(), this.getTable(), this.getJasperDesign()));
        set.put((Node.Property)new CellPaddingAndBordersProperty(this.getCell()));
        JRDesignDataset dataset = this.getJasperDesign().getMainDesignDataset();
        if (this.getTable().getDatasetRun() != null && this.getTable().getDatasetRun().getDatasetName() != null) {
            dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.getTable().getDatasetRun().getDatasetName());
        }
        set.put((Node.Property)new ColumnPrintWhenExpressionProperty((StandardBaseColumn)this.getColumn(), dataset));
        set.put((Node.Property)new ColumnPropertyExpressionsProperty((StandardBaseColumn)this.getColumn(), dataset));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (ModelUtils.containsProperty((Node.PropertySet[])this.getPropertySets(), (String)evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public BaseColumn getColumn() {
        return this.column;
    }

    public JRDesignComponentElement getComponentElement() {
        return this.tableElement;
    }

    public StandardTable getTable() {
        return (StandardTable)this.getComponentElement().getComponent();
    }

    public DesignCell getCell() {
        return this.cell;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public byte getSection() {
        return this.section;
    }

    public JRGroup getGroup() {
        return this.group;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public boolean hasCustomizer() {
        return true;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        Node[] dropNodes = NodeTransfer.nodes((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction((Transferable)t);
        if (dropNode == null) {
            ElementPasteType.setLastPastedNodes((Node[])dropNodes);
        }
        if (null != dropNode) {
            JRDesignElement element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class);
            if (element instanceof JRDesignComponentElement && ((JRDesignComponentElement)element).getComponent() == this.getTable()) {
                return null;
            }
            if (null != element) {
                return new ElementPasteType(element.getElementGroup(), (JRElementGroup)this.getCell(), (Object)element, dropAction, (Node)this);
            }
            if (dropNode instanceof ElementGroupNode) {
                JRDesignElementGroup g = ((ElementGroupNode)dropNode).getElementGroup();
                return new ElementPasteType(g.getElementGroup(), (JRElementGroup)this.getCell(), (Object)g, dropAction, (Node)this);
            }
        }
        return null;
    }
}

