/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.rowset.CachedRowSet;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRJdbcQueryExecuter.class);
    public static final String CANONICAL_LANGUAGE = "SQL";
    protected static final String CLAUSE_ID_IN = "IN";
    protected static final String CLAUSE_ID_NOTIN = "NOTIN";
    public static final String CLAUSE_ID_EQUAL = "EQUAL";
    public static final String CLAUSE_ID_NOTEQUAL = "NOTEQUAL";
    public static final String CLAUSE_ID_LESS = "LESS";
    public static final String CLAUSE_ID_GREATER = "GREATER";
    public static final String CLAUSE_ID_LESS_OR_EQUAL = "LESS]";
    public static final String CLAUSE_ID_GREATER_OR_EQUAL = "[GREATER";
    public static final String CLAUSE_ID_BETWEEN = "BETWEEN";
    public static final String CLAUSE_ID_BETWEEN_CLOSED = "[BETWEEN]";
    public static final String CLAUSE_ID_BETWEEN_LEFT_CLOSED = "[BETWEEN";
    public static final String CLAUSE_ID_BETWEEN_RIGHT_CLOSED = "BETWEEN]";
    protected static final String TYPE_FORWARD_ONLY = "forwardOnly";
    protected static final String TYPE_SCROLL_INSENSITIVE = "scrollInsensitive";
    protected static final String TYPE_SCROLL_SENSITIVE = "scrollSensitive";
    protected static final String CONCUR_READ_ONLY = "readOnly";
    protected static final String CONCUR_UPDATABLE = "updatable";
    protected static final String HOLD_CURSORS_OVER_COMMIT = "hold";
    protected static final String CLOSE_CURSORS_AT_COMMIT = "close";
    protected static final String CACHED_ROWSET_CLASS = "com.sun.rowset.CachedRowSetImpl";
    protected Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    protected PreparedStatement statement;
    protected ResultSet resultSet;
    private boolean isCachedRowSet;
    private TimeZone timeZone;
    private boolean timeZoneOverride;

    public JRJdbcQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(jasperReportsContext, dataset, parameters);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn((Object)"The supplied java.sql.Connection object is null.");
        }
        this.isCachedRowSet = this.getBooleanParameterOrProperty("net.sf.jasperreports.jdbc.cached.rowset", false);
        this.setTimeZone();
        this.registerFunctions();
        this.parseQuery();
    }

    public JRJdbcQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parameters);
    }

    protected void registerFunctions() {
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    protected void setTimeZone() {
        String timezoneId = (String)this.getParameterValue("net.sf.jasperreports.jdbc.time.zone", true);
        if (timezoneId != null) {
            this.timeZoneOverride = true;
        } else {
            timezoneId = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.time.zone");
        }
        this.timeZone = timezoneId == null || timezoneId.length() == 0 ? null : TimeZone.getTimeZone(timezoneId);
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public JRDataSource createDatasource() throws JRException {
        dataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                if (this.isCachedRowSet) {
                    try {
                        clazz = Class.forName("com.sun.rowset.CachedRowSetImpl");
                        constructor = clazz.getConstructor(new Class[0]);
                        this.resultSet = (ResultSet)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JRException(e);
                    }
                    ((CachedRowSet)this.resultSet).populate(this.statement.executeQuery());
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e) {
                        if (!JRJdbcQueryExecuter.log.isErrorEnabled()) ** GOTO lbl25
                        JRJdbcQueryExecuter.log.error((Object)"Error while closing statement.", (Throwable)e);
                    }
                    finally {
                        this.statement = null;
                    }
                } else {
                    this.resultSet = this.statement.executeQuery();
                }
lbl25:
                // 4 sources

                dataSource = new JRResultSetDataSource(this.getJasperReportsContext(), this.resultSet);
                dataSource.setTimeZone(this.timeZone, this.timeZoneOverride);
            }
            catch (SQLException e) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), e);
            }
        }
        return dataSource;
    }

    protected void createStatement() throws JRException {
        String queryString = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL query string: " + queryString));
        }
        if (this.connection != null && queryString != null && queryString.trim().length() > 0) {
            try {
                Integer reportMaxCount;
                int maxFieldSize;
                String type = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.result.set.type");
                String concurrency = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.concurrency");
                String holdability = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.holdability");
                if (type == null && concurrency == null && holdability == null) {
                    this.statement = this.connection.prepareStatement(queryString);
                } else {
                    type = type == null ? TYPE_FORWARD_ONLY : type;
                    concurrency = concurrency == null ? CONCUR_READ_ONLY : concurrency;
                    this.statement = holdability == null ? this.connection.prepareStatement(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency)) : this.connection.prepareStatement(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency), JRJdbcQueryExecuter.getHoldability(holdability, this.connection));
                }
                int fetchSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (fetchSize != 0) {
                    this.statement.setFetchSize(fetchSize);
                }
                if ((maxFieldSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.max.field.size", 0)) != 0) {
                    this.statement.setMaxFieldSize(maxFieldSize);
                }
                if ((reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT")) != null) {
                    this.statement.setMaxRows(reportMaxCount);
                }
                this.visitQueryParameters(new JRAbstractQueryExecuter.QueryParameterVisitor(){
                    int paramIdx = 1;

                    @Override
                    public void visit(JRAbstractQueryExecuter.QueryParameter queryParameter) {
                        try {
                            if (queryParameter.isMulti()) {
                                this.paramIdx += JRJdbcQueryExecuter.this.setStatementMultiParameters(this.paramIdx, queryParameter.getName(), queryParameter.isIgnoreNulls());
                            } else {
                                JRJdbcQueryExecuter.this.setStatementParameter(this.paramIdx, queryParameter.getName());
                                ++this.paramIdx;
                            }
                        }
                        catch (SQLException e) {
                            throw new JRAbstractQueryExecuter.VisitExceptionWrapper(e);
                        }
                    }

                    @Override
                    public void visit(JRAbstractQueryExecuter.ValuedQueryParameter valuedQueryParameter) {
                        Class<Object> type = valuedQueryParameter.getType();
                        Object value = valuedQueryParameter.getValue();
                        if (type == null) {
                            Class clazz = type = value == null ? Object.class : value.getClass();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Parameter #" + this.paramIdx + " (of type " + type.getName() + "): " + value));
                        }
                        try {
                            JRJdbcQueryExecuter.this.setStatementParameter(this.paramIdx, type, value, JRJdbcQueryExecuter.this.dataset);
                            ++this.paramIdx;
                        }
                        catch (SQLException e) {
                            throw new JRAbstractQueryExecuter.VisitExceptionWrapper(e);
                        }
                    }
                });
            }
            catch (JRAbstractQueryExecuter.VisitExceptionWrapper e) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + queryString + "\n\n", e.getCause());
            }
            catch (SQLException e) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + queryString + "\n\n", e);
            }
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    protected void setStatementParameter(int parameterIndex, String parameterName) throws SQLException {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Class<?> clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter #" + parameterIndex + " (" + parameterName + " of type " + clazz.getName() + "): " + parameterValue));
        }
        this.setStatementParameter(parameterIndex, clazz, parameterValue, parameter);
    }

    protected int setStatementMultiParameters(int parameterIndex, String parameterName, boolean ignoreNulls) throws SQLException {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Object paramValue = parameter.getValue();
        int index = 0;
        if (paramValue.getClass().isArray()) {
            int arrayCount = Array.getLength(paramValue);
            for (int count = 0; count < arrayCount; ++count) {
                Object value = Array.get(paramValue, count);
                if (ignoreNulls && value == null) continue;
                this.setStatementMultiParameter(parameterIndex + index, parameterName, count, value, parameter);
                ++index;
            }
        } else if (paramValue instanceof Collection) {
            Collection values = (Collection)paramValue;
            int count = 0;
            for (Object value : values) {
                if (!ignoreNulls || value != null) {
                    this.setStatementMultiParameter(parameterIndex + index, parameterName, count, value, parameter);
                    ++index;
                }
                ++count;
            }
        } else {
            throw new JRRuntimeException("Multi parameter value is not array nor collection.");
        }
        return index;
    }

    protected void setStatementMultiParameter(int parameterIndex, String parameterName, int valueIndex, Object value, JRPropertiesHolder properties) throws SQLException {
        if (value == null) {
            throw new JRRuntimeException("Multi parameters cannot contain null values.");
        }
        Class<?> type = value.getClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter #" + parameterIndex + " (" + parameterName + "[" + valueIndex + "] of type " + type.getName() + "): " + value));
        }
        this.setStatementParameter(parameterIndex, type, value, properties);
    }

    protected void setStatementParameter(int parameterIndex, Class<?> parameterType, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (Boolean.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -7);
            } else {
                this.statement.setBoolean(parameterIndex, (Boolean)parameterValue);
            }
        } else if (Byte.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -6);
            } else {
                this.statement.setByte(parameterIndex, (Byte)parameterValue);
            }
        } else if (Double.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 8);
            } else {
                this.statement.setDouble(parameterIndex, (Double)parameterValue);
            }
        } else if (Float.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 6);
            } else {
                this.statement.setFloat(parameterIndex, ((Float)parameterValue).floatValue());
            }
        } else if (Integer.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 4);
            } else {
                this.statement.setInt(parameterIndex, (Integer)parameterValue);
            }
        } else if (Long.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -5);
            } else {
                this.statement.setLong(parameterIndex, (Long)parameterValue);
            }
        } else if (Short.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 5);
            } else {
                this.statement.setShort(parameterIndex, (Short)parameterValue);
            }
        } else if (BigDecimal.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 3);
            } else {
                this.statement.setBigDecimal(parameterIndex, (BigDecimal)parameterValue);
            }
        } else if (String.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 12);
            } else {
                this.statement.setString(parameterIndex, parameterValue.toString());
            }
        } else if (Timestamp.class.isAssignableFrom(parameterType)) {
            this.setTimestamp(parameterIndex, parameterValue, properties);
        } else if (Time.class.isAssignableFrom(parameterType)) {
            this.setTime(parameterIndex, parameterValue, properties);
        } else if (java.util.Date.class.isAssignableFrom(parameterType)) {
            this.setDate(parameterIndex, parameterValue, properties);
        } else if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 2000);
        } else {
            this.statement.setObject(parameterIndex, parameterValue);
        }
    }

    protected void setTimestamp(int parameterIndex, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 93);
        } else {
            Calendar cal = this.getParameterCalendar(properties);
            if (cal == null) {
                this.statement.setTimestamp(parameterIndex, (Timestamp)parameterValue);
            } else {
                this.statement.setTimestamp(parameterIndex, (Timestamp)parameterValue, cal);
            }
        }
    }

    protected void setTime(int parameterIndex, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 92);
        } else {
            Calendar cal = this.getParameterCalendar(properties);
            if (cal == null) {
                this.statement.setTime(parameterIndex, (Time)parameterValue);
            } else {
                this.statement.setTime(parameterIndex, (Time)parameterValue, cal);
            }
        }
    }

    protected void setDate(int parameterIndex, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 91);
        } else {
            Calendar cal = this.getParameterCalendar(properties);
            if (cal == null) {
                this.statement.setDate(parameterIndex, new Date(((java.util.Date)parameterValue).getTime()));
            } else {
                this.statement.setDate(parameterIndex, new Date(((java.util.Date)parameterValue).getTime()), cal);
            }
        }
    }

    protected Calendar getParameterCalendar(JRPropertiesHolder properties) {
        String timezoneId;
        TimeZone tz = this.timeZoneOverride ? this.timeZone : (properties.hasProperties() && properties.getPropertiesMap().containsProperty("net.sf.jasperreports.jdbc.time.zone") ? ((timezoneId = this.getPropertiesUtil().getProperty(properties, "net.sf.jasperreports.jdbc.time.zone")) == null || timezoneId.length() == 0 ? null : TimeZone.getTimeZone(timezoneId)) : this.timeZone);
        Calendar cal = tz == null ? null : Calendar.getInstance(tz);
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing result set.", (Throwable)e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing statement.", (Throwable)e);
            }
            finally {
                this.statement = null;
            }
        }
    }

    @Override
    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Exception e) {
                throw new JRException("Error cancelling SQL statement", e);
            }
        }
        return false;
    }

    protected static int getResultSetType(String type) {
        if (TYPE_FORWARD_ONLY.equals(type)) {
            return 1003;
        }
        if (TYPE_SCROLL_INSENSITIVE.equals(type)) {
            return 1004;
        }
        if (TYPE_SCROLL_SENSITIVE.equals(TYPE_SCROLL_SENSITIVE)) {
            return 1005;
        }
        return 1003;
    }

    protected static int getConcurrency(String concurrency) {
        if (CONCUR_READ_ONLY.equals(concurrency)) {
            return 1007;
        }
        if (CONCUR_UPDATABLE.equals(concurrency)) {
            return 1008;
        }
        return 1007;
    }

    protected static int getHoldability(String holdability, Connection connection) throws SQLException {
        if (HOLD_CURSORS_OVER_COMMIT.equals(holdability)) {
            return 1;
        }
        if (CLOSE_CURSORS_AT_COMMIT.equals(holdability)) {
            return 2;
        }
        return connection.getHoldability();
    }
}

