/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nickyb.sqleonardo.querybuilder.BaseMask;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class MaskAlias
extends BaseMask {
    private QueryTokens.AbstractDatabaseObject querytoken;
    private JTextField value;

    public MaskAlias(QueryTokens.AbstractDatabaseObject token, QueryBuilder builder) {
        super("database object.edit", builder);
        this.querytoken = token;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel pnl = new JPanel();
        pnl.setLayout(gbl);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 6, 0, 6);
        JLabel lbl = new JLabel("identifier:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        JTextField txt = new JTextField(token.getIdentifier());
        txt.setEditable(false);
        gbl.setConstraints(txt, gbc);
        pnl.add(txt);
        gbc.insets = new Insets(5, 6, 0, 6);
        lbl = new JLabel("alias:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        gbc.insets = new Insets(0, 6, 0, 6);
        this.value = new JTextField();
        gbl.setConstraints(this.value, gbc);
        pnl.add(this.value);
        this.setComponentCenter(pnl);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 100);
    }

    protected boolean onConfirm() {
        if (this.querytoken instanceof QueryTokens.Table) {
            DiagramEntity entity = this.builder.diagram.getEntity((QueryTokens.Table)this.querytoken);
            this.querytoken.setAlias(this.value.getText());
            entity.setQueryToken((QueryTokens.Table)this.querytoken);
        } else {
            if (this.builder.browser.getQueryItem() instanceof BrowserItems.DiagramQueryTreeItem) {
                if (this.value.getText() == null || this.value.getText().trim().length() == 0) {
                    String message = "Please, set a valid alias.";
                    if (SwingUtilities.getWindowAncestor(this.builder) instanceof Frame) {
                        JOptionPane.showMessageDialog((Frame)SwingUtilities.getWindowAncestor(this.builder), message, "SQLeonardo", 2);
                    } else if (SwingUtilities.getWindowAncestor(this.builder) instanceof Dialog) {
                        JOptionPane.showMessageDialog((Dialog)SwingUtilities.getWindowAncestor(this.builder), message, "SQLeonardo", 2);
                    }
                    return false;
                }
                BrowserItems.DiagramQueryTreeItem dqti = (BrowserItems.DiagramQueryTreeItem)this.builder.browser.getQueryItem();
                dqti.getDiagramObject().getField(this.querytoken.getAlias()).getLabelComponent().setText(this.value.getText());
                dqti.getDiagramObject().getField(this.querytoken.getAlias()).getQueryToken().setName(this.value.getText());
                dqti.getDiagramObject().getField(this.querytoken.getAlias()).setName(this.value.getText());
                dqti.getDiagramObject().pack();
                this.builder.browser.reload(dqti.getParent().getParent().getChildAt(0));
            }
            this.querytoken.setAlias(this.value.getText());
        }
        return true;
    }

    protected void onShow() {
        if (this.querytoken.isAliasSet()) {
            this.value.setText(this.querytoken.getAlias());
        } else {
            this.value.setText("");
        }
    }
}

