/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.MaskDriver;
import nickyb.sqleonardo.environment.ctrl.explorer.MaskLibraries;
import nickyb.sqleonardo.environment.ctrl.explorer.MaskLibraryChooser;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

public class DialogDriver
extends AbstractDialogConfirm {
    public static final short ITEM_NEW = 0;
    public static final short ITEM_MODIFY = 1;
    public static final short ITEM_DUPLICATE = 2;
    private short request;
    private SideNavigator navigator;
    private UoDriver uoDv;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JCheckBox cbxShowFileSystem;
    private int step = 0;
    private MaskLibraryChooser mChoose;
    private MaskLibraries mLibs;
    private MaskDriver mDv;
    private CommandButton btnBack;

    public DialogDriver(SideNavigator navigator, short request) {
        super((Component)Application.window, "driver." + (request == 1 ? "edit" : "new"));
        this.request = request;
        this.navigator = navigator;
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.mDv = new MaskDriver();
        this.cardPanel.add("last", this.mDv);
        this.getContentPane().add(this.cardPanel);
        this.btnBack = this.insertButton(1, "< back");
        this.cbxShowFileSystem = new JCheckBox("add library (browse filesystem)");
        this.bar.add((Component)this.cbxShowFileSystem, 0);
    }

    protected void setBarEnabled(boolean b) {
        super.setBarEnabled(b);
        this.btnBack.setEnabled(this.step != 0);
    }

    private void showFirst() {
        this.step = 0;
        this.btnBack.setEnabled(false);
        this.btnConfirm.setText("next >");
        this.cardLayout.show(this.cardPanel, "first");
        this.cbxShowFileSystem.setVisible(true);
    }

    private void showNext() {
        this.step = 1;
        this.btnBack.setEnabled(true);
        this.cardLayout.show(this.cardPanel, "next");
        this.cbxShowFileSystem.setVisible(false);
    }

    private void showLast(boolean enabled) {
        this.step = 2;
        this.mDv.load(this.uoDv);
        this.mDv.setEnabled(enabled);
        this.btnBack.setEnabled(true);
        this.btnBack.setVisible(this.request != 1);
        this.btnConfirm.setText("ok");
        this.cardLayout.show(this.cardPanel, "last");
        this.cbxShowFileSystem.setVisible(false);
    }

    protected void onOpen() {
        this.cardPanel.setVisible(false);
        if (this.request == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.navigator.getSelectionPath().getLastPathComponent();
            this.uoDv = (UoDriver)node.getUserObject();
            this.mDv.load(this.uoDv);
            boolean oneconnection = false;
            for (int i = 0; !oneconnection && i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                oneconnection = ((UoDatasource)child.getUserObject()).isConnected();
            }
            this.showLast(!oneconnection);
        } else {
            this.uoDv = new UoDriver();
            this.mLibs = new MaskLibraries();
            this.cardPanel.add("first", this.mLibs);
            this.mChoose = new MaskLibraryChooser();
            this.cardPanel.add("next", this.mChoose);
            if (this.request == 2) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.navigator.getSelectionPath().getLastPathComponent();
                this.uoDv.library = ((UoDriver)node.getUserObject()).library;
                this.mLibs.setLibrary(this.uoDv.library);
                this.uoDv.classname = ((UoDriver)node.getUserObject()).classname;
                this.uoDv.example = ((UoDriver)node.getUserObject()).example;
                this.showLast(true);
            } else {
                this.showFirst();
            }
        }
        this.cardPanel.setVisible(true);
    }

    protected boolean onConfirm() {
        if (this.step == 0) {
            if (this.cbxShowFileSystem.isSelected()) {
                this.showNext();
            } else if (this.findDriver(this.mLibs.getLibrary()) && this.mLibs.unload(this.uoDv)) {
                this.showLast(true);
            }
        } else if (this.step == 1) {
            if (this.findDriver(this.mChoose.getLibrary())) {
                this.showLast(true);
            }
        } else if (this.mDv.unload(this.uoDv)) {
            if (this.request == 1) {
                this.navigator.reloadSelection();
                return true;
            }
            this.navigator.add(this.uoDv);
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.btnBack) {
            if (this.step == 2 && this.cbxShowFileSystem.isSelected()) {
                this.showNext();
            } else {
                this.showFirst();
            }
        } else {
            super.actionPerformed(ae);
        }
    }

    private boolean findDriver(String library) {
        if (library == null) {
            Application.alert("SQLeonardo", "select one library!");
            return false;
        }
        this.mDv.clearDrivers();
        try {
            ZipFile zf = new ZipFile(library);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") || name.indexOf("$") != -1 || name.toLowerCase().indexOf("driver") == -1) continue;
                name = name.replace('/', '.');
                this.mDv.addDriver(name.substring(0, name.indexOf(".class")));
            }
            zf.close();
            this.uoDv.library = library;
            this.uoDv.classname = null;
        }
        catch (Exception ioe) {
            Application.println(ioe, true);
            return false;
        }
        return true;
    }
}

