/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@UDFType(deterministic=true)
public abstract class GenericUDF {
    public abstract ObjectInspector initialize(ObjectInspector[] var1) throws UDFArgumentException;

    public ObjectInspector initializeAndFoldConstants(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector oi = this.initialize(arguments);
        if (this.getRequiredFiles() != null || this.getRequiredJars() != null) {
            return oi;
        }
        boolean allConstant = true;
        for (int ii = 0; ii < arguments.length; ++ii) {
            if (ObjectInspectorUtils.isConstantObjectInspector(arguments[ii])) continue;
            allConstant = false;
            break;
        }
        if (allConstant && !ObjectInspectorUtils.isConstantObjectInspector(oi) && FunctionRegistry.isDeterministic(this) && !FunctionRegistry.isStateful(this) && ObjectInspectorUtils.supportsConstantObjectInspector(oi)) {
            DeferredObject[] argumentValues = new DeferredJavaObject[arguments.length];
            for (int ii = 0; ii < arguments.length; ++ii) {
                argumentValues[ii] = new DeferredJavaObject(((ConstantObjectInspector)arguments[ii]).getWritableConstantValue());
            }
            try {
                Object constantValue = this.evaluate(argumentValues);
                oi = ObjectInspectorUtils.getConstantObjectInspector(oi, constantValue);
            }
            catch (HiveException e) {
                throw new UDFArgumentException(e);
            }
        }
        return oi;
    }

    public String[] getRequiredJars() {
        return null;
    }

    public String[] getRequiredFiles() {
        return null;
    }

    public abstract Object evaluate(DeferredObject[] var1) throws HiveException;

    public abstract String getDisplayString(String[] var1);

    public static class DeferredJavaObject
    implements DeferredObject {
        private Object value;

        public DeferredJavaObject(Object value) {
            this.value = value;
        }

        @Override
        public Object get() throws HiveException {
            return this.value;
        }
    }

    public static interface DeferredObject {
        public Object get() throws HiveException;
    }
}

