/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;

public class UndoWatcher {
    private static Collection extractCES(Collection collection) {
        HashSet<CloneableEditorSupport> hashSet = new HashSet<CloneableEditorSupport>();
        for (RefactoringElement refactoringElement : collection) {
            PositionBounds positionBounds = refactoringElement.getPosition();
            if (positionBounds == null) continue;
            CloneableEditorSupport cloneableEditorSupport = positionBounds.getBegin().getCloneableEditorSupport();
            hashSet.add(cloneableEditorSupport);
        }
        return hashSet;
    }

    public static void watch(RefactoringSession refactoringSession, InvalidationListener invalidationListener) {
        UndoManager.getDefault().watch(UndoWatcher.extractCES(refactoringSession.getRefactoringElements()), invalidationListener);
    }

    public static void stopWatching(InvalidationListener invalidationListener) {
        UndoManager.getDefault().stopWatching(invalidationListener);
    }

    public static void watch(DataObject dataObject) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        assert (editorCookie instanceof CloneableEditorSupport);
        UndoManager.getDefault().watch(Collections.singleton((CloneableEditorSupport)editorCookie), null);
    }
}

