/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive.connection;

import com.jaspersoft.hadoop.hive.connection.HiveConnection;
import com.jaspersoft.hadoop.hive.connection.HiveConnectionFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class HiveConnectionManager {
    private GenericObjectPool<HiveConnection> connectionsPool;
    private GenericObjectPool.Config poolConfiguration;
    private HiveConnectionFactory connectionFactory;
    private final Logger logger = Logger.getLogger(HiveConnectionManager.class);

    public HiveConnectionManager() {
        this.connectionFactory = new HiveConnectionFactory();
        this.poolConfiguration = new GenericObjectPool.Config();
        this.poolConfiguration.testOnBorrow = true;
        this.poolConfiguration.testWhileIdle = true;
        this.poolConfiguration.whenExhaustedAction = (byte)2;
        this.poolConfiguration.maxActive = 4;
        this.poolConfiguration.maxIdle = 2;
        this.poolConfiguration.minIdle = 1;
    }

    private GenericObjectPool<HiveConnection> startConnectionsPool() {
        if (this.connectionsPool == null) {
            this.connectionsPool = new GenericObjectPool((PoolableObjectFactory)this.connectionFactory, this.poolConfiguration);
        }
        return this.connectionsPool;
    }

    public HiveConnection borrowConnection() throws Exception {
        if (this.connectionsPool == null) {
            this.startConnectionsPool();
        }
        if (this.connectionsPool == null) {
            this.logger.error((Object)"No connection pool created");
            return null;
        }
        return (HiveConnection)this.connectionsPool.borrowObject();
    }

    public void returnConnection(HiveConnection connection) {
        if (this.connectionsPool == null) {
            this.logger.error((Object)"No connection pool created");
            return;
        }
        try {
            this.connectionsPool.returnObject((Object)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.connectionsPool != null) {
            try {
                this.connectionsPool.clear();
                this.connectionsPool.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setMaxActive(int maxActive) {
        this.poolConfiguration.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.poolConfiguration.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.poolConfiguration.minIdle = minIdle;
    }

    public void setJdbcURL(String jdbcURL) {
        this.connectionFactory.setJdbcURL(jdbcURL);
    }
}

