/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.netbeans.modules.openfile.FileChooser;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OpenFileAction
implements ActionListener {
    private static boolean running;

    private HelpCtx getHelpCtx() {
        return new HelpCtx(OpenFileAction.class);
    }

    protected JFileChooser prepareFileChooser() {
        FileChooser fileChooser = new FileChooser();
        File file = OpenFileAction.findStartingDirectory();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, (File)file);
        HelpCtx.setHelpIDString((JComponent)fileChooser, (String)this.getHelpCtx().getHelpID());
        return fileChooser;
    }

    public static File[] chooseFilesToOpen(JFileChooser jFileChooser) throws UserCancelException {
        File[] fileArray;
        do {
            int n;
            if ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) continue;
            throw new UserCancelException();
        } while ((fileArray = jFileChooser.getSelectedFiles()).length == 0);
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (running) {
            return;
        }
        try {
            File[] fileArray;
            running = true;
            JFileChooser jFileChooser = this.prepareFileChooser();
            try {
                fileArray = OpenFileAction.chooseFilesToOpen(jFileChooser);
            }
            catch (UserCancelException userCancelException) {
                running = false;
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                OpenFile.openFile(fileArray[i], -1);
            }
        }
        finally {
            running = false;
        }
    }

    private static File findStartingDirectory() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            File file;
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (dataObject == null || (file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile())) == null) continue;
            if (file.isFile()) {
                file = file.getParentFile();
            }
            return file;
        }
        return new File(System.getProperty("user.home"));
    }
}

