/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb;

import com.jaspersoft.mongodb.query.MongoDbQueryWrapper;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

public class MongoDbDataSource
implements JRDataSource {
    private MongoDbQueryWrapper wrapper;
    private DBObject currentDbObject;
    public static final String CONNECTION = "com.jaspersoft.mongodb.connection";
    public static final String QUERY_LANGUAGE = "MongoDbQuery";
    private static final Logger logger = Logger.getLogger(MongoDbDataSource.class);
    private boolean hasIterator = false;
    private boolean hasCommandResult = false;
    private Iterator<?> resultsIterator;
    private Map<?, ?> currentResult;

    public MongoDbDataSource(MongoDbQueryWrapper wrapper) {
        logger.info((Object)"New MongoDB Data Source");
        this.wrapper = wrapper;
        boolean bl = this.hasIterator = wrapper.iterator != null;
        if (!this.hasIterator) {
            this.hasCommandResult = wrapper.commandResults != null;
            this.resultsIterator = wrapper.commandResults.iterator();
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        try {
            if (this.hasIterator) {
                return this.getCursorValue(field.getName());
            }
            if (this.hasCommandResult) {
                return this.getCommandResult(field.getName());
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }

    private Object getCommandResult(String fieldName) {
        return this.currentResult.get(fieldName);
    }

    private Object getCursorValue(String fieldName) {
        String[] ids = fieldName.split("\\.");
        DBObject fieldObject = this.currentDbObject;
        for (int index = 0; index < ids.length; ++index) {
            boolean isLast = index == ids.length - 1;
            String id = ids[index];
            Object currentFieldObject = fieldObject.get(id);
            if (currentFieldObject == null) {
                return null;
            }
            if (currentFieldObject instanceof DBObject) {
                fieldObject = (DBObject)currentFieldObject;
                if (!isLast) continue;
                return fieldObject;
            }
            if (isLast) {
                return fieldObject.get(id);
            }
            return null;
        }
        return null;
    }

    public boolean next() throws JRException {
        boolean next = false;
        if (this.hasIterator && (next = this.wrapper.iterator.hasNext())) {
            this.currentDbObject = this.wrapper.iterator.next();
        } else if (this.hasCommandResult) {
            next = this.resultsIterator.hasNext();
            this.currentResult = null;
            if (next) {
                this.currentResult = (Map)this.resultsIterator.next();
            }
        }
        return next;
    }
}

