/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.data.JRXmlaDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlaQueryExecuter
extends JRAbstractQueryExecuter {
    private final String theUrl;
    private final String theDatasource;
    private final String theCatalog;
    private static final Log log = LogFactory.getLog((Class)JRXmlaQueryExecuter.class);

    public JRXmlaQueryExecuter(JRDataset dataset, Map parametersMap) {
        super(dataset, parametersMap);
        String strCatalog;
        String strDatasource;
        String strURL = (String)this.getParameterValue("XMLA_DATA_URL");
        if (strURL == null) {
            strURL = JRXmlaDataSource.url;
        }
        this.theUrl = strURL;
        if (this.theUrl == null) {
            log.warn((Object)"The supplied url is null.");
        }
        if ((strDatasource = (String)this.getParameterValue("XMLA_DATA_DATASOURCE")) == null) {
            strDatasource = JRXmlaDataSource.datasource;
        }
        this.theDatasource = strDatasource;
        if (this.theDatasource == null) {
            log.warn((Object)"The supplied datasource is null.");
        }
        if ((strCatalog = (String)this.getParameterValue("XMLA_DATA_CATALOG")) == null) {
            strCatalog = JRXmlaDataSource.catalog;
        }
        this.theCatalog = strCatalog;
        if (this.theCatalog == null) {
            log.warn((Object)"The supplied catalog is null.");
        }
        this.parseQuery();
    }

    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    public JRDataSource createDatasource() throws JRException {
        JRGroup[] groups;
        JRXmlaDataSource datasource = null;
        String mdxQuery = this.getQueryString();
        String groupFieldName = null;
        if (this.dataset != null && (groups = this.dataset.getGroups()) != null && groups.length > 0) {
            groupFieldName = groups[0].getName();
        }
        if (this.theUrl != null && this.theDatasource != null && this.theCatalog != null && mdxQuery != null) {
            try {
                datasource = new JRXmlaDataSource(this.theUrl, this.theDatasource, this.theCatalog, groupFieldName, mdxQuery);
            }
            catch (Exception e) {
                throw new JRException((Throwable)e);
            }
        }
        return datasource;
    }

    public void close() {
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }
}

